/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.printer.builder.tspl;

import com.digiwin.mobile.mobileuibot.printer.enums.PrinterCommandTypeEnum;
import com.digiwin.mobile.mobileuibot.printer.factory.PrinterCommandBuilder;
import com.digiwin.mobile.mobileuibot.printer.model.CommandRequired;
import com.digiwin.mobile.mobileuibot.printer.model.ReportData;
import com.digiwin.mobile.mobileuibot.printer.model.ReportDetail;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Scope(value="prototype")
public class TSPLPrinterCommandBuilder
implements PrinterCommandBuilder {
    public String getPrinterType() {
        return PrinterCommandTypeEnum.TSPL.name();
    }

    public ReportDetail getReportFilePaths(ReportDetail report, String pdfUrl) {
        report.setBmpFilesPath((List)Lists.newArrayList((Object[])new String[]{pdfUrl}));
        report.setCopy(1);
        return report;
    }

    public List<String> buildPrintCommand(List<String> imagePaths) throws Exception {
        if (CollectionUtils.isEmpty(imagePaths)) {
            return Lists.newArrayList();
        }
        ReportData reportData = new ReportData();
        reportData.setPdfUrls(imagePaths);
        return this.printerCommandString(reportData);
    }

    private List<CommandRequired> getCommandBytes(ReportDetail report, String pdfUrl) throws IOException {
        ArrayList<CommandRequired> reportBytesCopy = new ArrayList<CommandRequired>();
        report = this.getReportFilePaths(report, pdfUrl);
        for (String path : report.getBmpFilesPath()) {
            BufferedImage originalBitmap = ImageIO.read(new File(path));
            reportBytesCopy.add(new CommandRequired(this.copyBitmap(originalBitmap), report.getHeight(), report.getWidth(), report.getCopy()));
        }
        return reportBytesCopy;
    }

    private List<String> printerCommandString(ReportData reportData) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        List reportBytesCopy = this.getCommandBytes(reportData);
        if (!reportBytesCopy.isEmpty()) {
            for (List reportBytesData : reportBytesCopy) {
                for (CommandRequired reportInfo : reportBytesData) {
                    BufferedImage sourceBmp = reportInfo.getBitmap();
                    byte[] commandByte = this.getBitmapBytes(sourceBmp, reportInfo.getWidth(), reportInfo.getHeight());
                    for (int i = 0; i < reportInfo.getCopy(); ++i) {
                        result.add(Base64.getEncoder().encodeToString(commandByte));
                    }
                    sourceBmp.flush();
                }
            }
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u751f\u6210\u5341\u516d\u8fdb\u5236\u6307\u4ee4\uff0c\u6ca1\u6709\u6807\u7b7e\u4fe1\u606f");
        }
        return result;
    }

    private List<byte[]> printerCommandByte(ReportData reportData) throws IOException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        List reportBytesCopy = this.getCommandBytes(reportData);
        if (!reportBytesCopy.isEmpty()) {
            for (List reportBytesData : reportBytesCopy) {
                for (CommandRequired reportInfo : reportBytesData) {
                    BufferedImage sourceBmp = reportInfo.getBitmap();
                    byte[] commandByte = this.getBitmapBytes(sourceBmp, reportInfo.getWidth(), reportInfo.getHeight());
                    for (int i = 0; i < reportInfo.getCopy(); ++i) {
                        result.add(commandByte);
                    }
                    sourceBmp.flush();
                }
            }
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u751f\u6210\u5341\u516d\u8fdb\u5236\u6307\u4ee4\uff0c\u6ca1\u6709\u6807\u7b7e\u4fe1\u606f");
        }
        return result;
    }

    private List<List<CommandRequired>> getCommandBytes(ReportData reportData) throws IOException {
        ArrayList<List<CommandRequired>> reportBytesCopy = new ArrayList<List<CommandRequired>>();
        if (!reportData.getPdfUrls().isEmpty()) {
            for (String pdfUrl : reportData.getPdfUrls()) {
                reportBytesCopy.add(this.getCommandBytes(new ReportDetail(), pdfUrl));
            }
        } else {
            for (ReportDetail report : reportData.getData()) {
                reportBytesCopy.add(this.getCommandBytes(report, ""));
            }
        }
        return reportBytesCopy;
    }

    private byte[] getBitmapBytes(BufferedImage getImage, String width, String height) {
        int k = 0;
        int sendWidth = getImage.getWidth();
        int sendHeight = getImage.getHeight();
        if (sendHeight % 8 != 0) {
            sendHeight += 8 - sendHeight % 8;
        }
        if (sendWidth % 8 != 0) {
            sendWidth += 8 - sendWidth % 8;
        }
        byte[] bmpData = new byte[sendWidth * sendHeight / 8];
        byte[] sendBmpData = new byte[bmpData.length + 1000];
        Arrays.fill(bmpData, (byte)-1);
        double redSum = 0.0;
        double greenSum = 0.0;
        double blueSum = 0.0;
        double total = sendWidth * sendHeight;
        for (int i = 0; i < getImage.getWidth(); ++i) {
            for (int j = 0; j < getImage.getHeight(); ++j) {
                Color color = new Color(getImage.getRGB(i, j));
                redSum += (double)color.getAlpha();
                greenSum += (double)color.getGreen();
                blueSum += (double)color.getBlue();
            }
        }
        int meanR = (int)(redSum / total);
        int meanG = (int)(greenSum / total);
        int meanB = (int)(blueSum / total);
        for (int j = 0; j < getImage.getHeight(); ++j) {
            for (int i = 0; i < getImage.getWidth(); ++i) {
                Color color = new Color(getImage.getRGB(i, j));
                if (!((double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.114 < (double)meanR * 0.299 + (double)meanG * 0.587 + (double)meanB * 0.114)) continue;
                int n = j * sendWidth / 8 + i / 8;
                bmpData[n] = (byte)(bmpData[n] & (byte)(~(1 << 7 - i % 8)));
            }
        }
        sendBmpData[k++] = 67;
        sendBmpData[k++] = 76;
        sendBmpData[k++] = 83;
        sendBmpData[k++] = 10;
        sendBmpData[k++] = 83;
        sendBmpData[k++] = 73;
        sendBmpData[k++] = 90;
        sendBmpData[k++] = 69;
        sendBmpData[k++] = 32;
        if (width == null || width.isEmpty()) {
            width = String.valueOf((int)Math.ceil((double)getImage.getWidth() / 203.0 * 25.4));
        }
        byte[] widthData = this.convertStringToHex(width);
        System.arraycopy(widthData, 0, sendBmpData, k, widthData.length);
        k += widthData.length;
        sendBmpData[k++] = 32;
        sendBmpData[k++] = 109;
        sendBmpData[k++] = 109;
        sendBmpData[k++] = 44;
        if (height == null || height.isEmpty()) {
            height = String.valueOf((int)Math.ceil((double)getImage.getHeight() / 203.0 * 25.4));
        }
        byte[] heightData = this.convertStringToHex(height);
        System.arraycopy(heightData, 0, sendBmpData, k, heightData.length);
        k += heightData.length;
        sendBmpData[k++] = 32;
        sendBmpData[k++] = 109;
        sendBmpData[k++] = 109;
        sendBmpData[k++] = 10;
        sendBmpData[k++] = 66;
        sendBmpData[k++] = 73;
        sendBmpData[k++] = 84;
        sendBmpData[k++] = 77;
        sendBmpData[k++] = 65;
        sendBmpData[k++] = 80;
        sendBmpData[k++] = 32;
        sendBmpData[k++] = 48;
        sendBmpData[k++] = 44;
        sendBmpData[k++] = 48;
        sendBmpData[k++] = 44;
        byte[] wdata = this.convertStringToHex(String.valueOf(getImage.getWidth() % 8 > 0 ? getImage.getWidth() / 8 + 1 : getImage.getWidth() / 8));
        System.arraycopy(wdata, 0, sendBmpData, k, wdata.length);
        k += wdata.length;
        sendBmpData[k++] = 44;
        byte[] hdata = this.convertStringToHex(String.valueOf(getImage.getHeight()));
        System.arraycopy(hdata, 0, sendBmpData, k, hdata.length);
        k += hdata.length;
        sendBmpData[k++] = 44;
        sendBmpData[k++] = 48;
        sendBmpData[k++] = 44;
        System.arraycopy(bmpData, 0, sendBmpData, k, bmpData.length);
        k += bmpData.length;
        sendBmpData[k++] = 10;
        sendBmpData[k++] = 80;
        sendBmpData[k++] = 82;
        sendBmpData[k++] = 73;
        sendBmpData[k++] = 78;
        sendBmpData[k++] = 84;
        sendBmpData[k++] = 32;
        sendBmpData[k++] = 49;
        sendBmpData[k++] = 10;
        return sendBmpData;
    }

    private void memset(byte[] buf, byte val, int size) {
        for (int i = 0; i < size; ++i) {
            buf[i] = val;
        }
    }

    private byte[] convertStringToHex(String input) {
        byte[] hexValues = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            hexValues[i] = (byte)input.charAt(i);
        }
        return hexValues;
    }

    private BufferedImage copyBitmap(BufferedImage original) {
        BufferedImage copy = new BufferedImage(original.getWidth(), original.getHeight(), original.getType());
        Graphics2D g = copy.createGraphics();
        g.drawImage((Image)original, 0, 0, null);
        g.dispose();
        return copy;
    }

    public static void main(String[] args) throws Exception {
        ReportData reportData = new ReportData();
        reportData.setPdfUrls((List)Lists.newArrayList((Object[])new String[]{"C:\\Users\\wjw\\Downloads\\UserBasis001.bmp"}));
        List strings = new TSPLPrinterCommandBuilder().printerCommandString(reportData);
        System.out.println(strings);
    }
}

