/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.printer.factory;

import com.digiwin.mobile.mobileuibot.printer.factory.PrinterCommandBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrinterCommandFactory
implements InitializingBean {
    private final Map<String, Class<? extends PrinterCommandBuilder>> builderMap = new ConcurrentHashMap();
    @Autowired
    private List<PrinterCommandBuilder> printerCommandBuilderList;

    public Class<? extends PrinterCommandBuilder> getBuilder(String printerType) {
        return StringUtils.isEmpty((CharSequence)printerType) ? null : (Class)this.builderMap.get(printerType);
    }

    public void afterPropertiesSet() throws Exception {
        for (PrinterCommandBuilder builder : this.printerCommandBuilderList) {
            this.builderMap.put(builder.getPrinterType(), builder.getClass());
        }
    }
}

