/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.milestone.Milestone;
import com.digiwin.mobile.mobileuibot.core.component.milestone.MilestoneNode;
import com.digiwin.mobile.mobileuibot.core.component.milestone.MilestoneNodeContent;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityStateEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEnginePanelInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEngineTaskCode;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanelTask;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.task.model.MobileProcessStatusEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class UiBotModelBuildProjectV2PageStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildProjectV2PageStrategy.class);
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        Boolean isShare = apiRequest.getRawData().getBoolean("isShare");
        DigiwinAtmcEnginePanelInfo enginePanelInfo = this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(apiRequest.getDataId(), "", apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        this.buildAppbarButtonList(apiRequest, enginePanelInfo, uiBotModel, isShare);
        uiBotModel.getRenderData().addWrapperedComponentToBody(this.buildProjectTitleBody(apiRequest, enginePanelInfo));
        uiBotModel.getRenderData().addWrapperedComponentToBody(this.buildMilestoneWrapper(enginePanelInfo, isShare));
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private void buildAppbarButtonList(ApiRequest apiRequest, DigiwinAtmcEnginePanelInfo enginePanelInfo, UiBotModel uiBotModel, Boolean isShare) {
        ArrayList<Button> appbarButtonList = new ArrayList<Button>();
        if (BooleanUtils.isNotTrue((Boolean)isShare)) {
            Map reassign = enginePanelInfo.getReassign();
            if (null != reassign && Boolean.TRUE.equals(reassign.get("reAssignAble"))) {
                Map reassignRawData = (Map)JsonUtil.objectToJavaObject((Object)enginePanelInfo.getReassign(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                reassignRawData.put("appCode", enginePanelInfo.getTask().getAppCode());
                reassignRawData.put("projectDetail", enginePanelInfo.getTask());
                uiBotModel.setReassignButton(Button.createApprovalReassign((String)(apiRequest.getDataId() + ""), (Map)reassignRawData, (String)apiRequest.getLocale(), (String)"PROJECT", (Integer)58926));
                if (reassign.get("reassignSize") != null && (Integer)reassign.get("reassignSize") > 0) {
                    appbarButtonList.add(Button.createReassignReport((String)(apiRequest.getDataId() + ""), (String)apiRequest.getLocale(), (String)"PROJECT", (Integer)58926));
                }
            }
            Map othersRawData = (Map)JsonUtil.objectToJavaObject((Object)enginePanelInfo.getReassign(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            othersRawData.put("appCode", enginePanelInfo.getTask().getAppCode());
            appbarButtonList.add(Button.createProjectShareWithOthers((String)apiRequest.getDataId(), (Map)othersRawData, (String)apiRequest.getLocale(), (LocaleService)this.localeService));
        }
        uiBotModel.setAppbarButtonList(appbarButtonList);
    }

    public BaseMobileComponentWrapper<BaseMobileComponent> buildProjectTitleBody(ApiRequest apiRequest, DigiwinAtmcEnginePanelInfo enginePanelInfo) {
        if (enginePanelInfo == null || enginePanelInfo.getTask() == null) {
            return new BaseMobileComponentWrapper((BaseMobileComponent)TitleBody.createEmpty(), "DW_TITLE_BODY");
        }
        TitleBody titleBody = this.buildProjectTitle(enginePanelInfo.getTask(), apiRequest);
        this.buildProjectTitleDesc(apiRequest, titleBody, enginePanelInfo.getTask());
        return new BaseMobileComponentWrapper((BaseMobileComponent)titleBody, "DW_" + titleBody.returnComponentType());
    }

    public TitleBody buildProjectTitle(DigiwinAtmcPanelTask panelTask, ApiRequest apiRequest) {
        ArrayList tags = new ArrayList();
        PageDesc pageDesc = new PageDesc();
        pageDesc.setTitle(panelTask.getName());
        return TitleBody.create((String)(DateTimeUtil.getMonthDateOfTime((String)panelTask.getEndTime()) + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u9700\u5b8c\u6210") + " " + panelTask.getName()), (PageDesc)pageDesc, tags);
    }

    private void buildProjectTitleDesc(ApiRequest apiRequest, TitleBody titleBody, DigiwinAtmcPanelTask panelTask) {
        if (null == titleBody.getContent()) {
            titleBody.setContent(new TitleContent());
        }
        if (titleBody.getContent().getDesc() == null) {
            titleBody.getContent().setDesc(new PageDesc());
        }
        PageDesc desc = titleBody.getContent().getDesc();
        desc.addContent(Integer.valueOf(59274), ProjectStringUtil.getProjectDateDistanceString((String)apiRequest.getLocale(), (DigiwinAtmcPanelTask)panelTask), PageDescContentTypeEnum.NORMAL.getValue());
        desc.addContent(Integer.valueOf(59274), ProjectStringUtil.getProjectSourceInfoString((String)apiRequest.getLocale(), (DigiwinAtmcPanelTask)panelTask), PageDescContentTypeEnum.NORMAL.getValue());
        desc.addContent(Integer.valueOf(59274), ProjectStringUtil.getProjectInitiatorInfoString((String)apiRequest.getLocale(), (DigiwinAtmcPanelTask)panelTask), PageDescContentTypeEnum.NORMAL.getValue());
        Map sourcesByMainTaskId = this.digiwinAtmcProxyService.getSourcesByMainTaskId(apiRequest.getDataId(), "", apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (!CollectionUtils.isEmpty((Map)sourcesByMainTaskId)) {
            sourcesByMainTaskId.forEach((k, v) -> desc.addContent(Integer.valueOf(59274), this.localeService.getLanguageValue(apiRequest.getLocale(), "\u53d1\u8d77\u65f6\u95f4\uff1a") + v.getStartTime(), PageDescContentTypeEnum.NORMAL.getValue()));
        }
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildMilestoneWrapper(DigiwinAtmcEnginePanelInfo enginePanelInfo, Boolean isShare) {
        if (enginePanelInfo.getRoute() == null || enginePanelInfo.getRoute().getSelectRoute() == null || CollectionUtils.isEmpty((Collection)enginePanelInfo.getRoute().getSelectRoute().getActivities())) {
            return UiBotRenderData.createEmptyWrapper();
        }
        Milestone milestone = new Milestone();
        milestone.setNodeList(this.buildNodeList(isShare, enginePanelInfo));
        return new BaseMobileComponentWrapper((BaseMobileComponent)milestone, "DW_MILESTONE");
    }

    private List<MilestoneNode> buildNodeList(Boolean isShare, DigiwinAtmcEnginePanelInfo enginePanelInfo) {
        String tmTaskId = enginePanelInfo.getTask().getTmTaskId();
        Long projectId = enginePanelInfo.getTask().getId();
        ArrayList<MilestoneNode> nodeList = new ArrayList<MilestoneNode>();
        enginePanelInfo.getRoute().getSelectRoute().getActivities().forEach(activity -> {
            MilestoneNode node = new MilestoneNode();
            node.setName(activity.getName());
            List taskCodes = activity.getTaskCodes();
            if (CollectionUtils.isEmpty((Collection)taskCodes)) {
                node.setDefaultSelect(Boolean.valueOf(false));
                node.setStatus(MobileProcessStatusEnum.COMPLETED.getStatus());
                node.setContentList(new ArrayList());
                nodeList.add(node);
                return;
            }
            DigiwinAtmcEngineTaskCode taskCode = (DigiwinAtmcEngineTaskCode)taskCodes.get(0);
            if (DigiwinAtmcActivityStateEnum.DOING.getState().equals(taskCode.getState())) {
                node.setDefaultSelect(Boolean.valueOf(true));
                node.setStatus(MobileProcessStatusEnum.IN_PROGRESS.getStatus());
            } else if (DigiwinAtmcActivityStateEnum.DONE.getState().equals(taskCode.getState())) {
                node.setDefaultSelect(Boolean.valueOf(false));
                node.setStatus(MobileProcessStatusEnum.COMPLETED.getStatus());
            } else {
                node.setDefaultSelect(Boolean.valueOf(false));
                node.setStatus(MobileProcessStatusEnum.NO_START.getStatus());
            }
            node.setContentList(this.buildContentList(taskCodes, isShare, tmTaskId, projectId + ""));
            nodeList.add(node);
        });
        if (nodeList.stream().allMatch(node -> BooleanUtils.isNotTrue((Boolean)node.getDefaultSelect()))) {
            ((MilestoneNode)nodeList.get(0)).setDefaultSelect(Boolean.valueOf(true));
        }
        return nodeList;
    }

    private List<MilestoneNodeContent> buildContentList(List<DigiwinAtmcEngineTaskCode> taskCodes, Boolean isShare, String tmTaskId, String projectId) {
        ArrayList<MilestoneNodeContent> contentList = new ArrayList<MilestoneNodeContent>();
        taskCodes.forEach(taskCode -> {
            MilestoneNodeContent content = new MilestoneNodeContent();
            content.setName(taskCode.getName());
            HashMap<String, String> rawData = new HashMap<String, String>();
            rawData.put("tmTaskId", tmTaskId);
            rawData.put("tmActivityId", taskCode.getId());
            content.setAction(this.buildContentAction(projectId, rawData));
            contentList.add(content);
        });
        return contentList;
    }

    private Action<Map<String, Object>> buildContentAction(String dataId, Map<String, Object> rawData) {
        Action action = new Action();
        action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/uibot/model");
        action.setDataId(dataId);
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_MILESTONE_PAGE.name());
        action.setRawData(rawData);
        return action;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

