/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.aim.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimNewMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimWorknewsMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.ExpireApplicationNoticeInfo;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.impl.DigiwinAimProxyServiceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="digiwinAimProxyService")
public class DigiwinAimProxyServiceImpl
implements DigiwinAimProxyService {
    private static final Logger logger = LoggerFactory.getLogger(DigiwinAimProxyServiceImpl.class);
    private final HttpService httpService;

    public DigiwinAimProxyServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public List<DigiwinAimMessageSummary> listImportantMessageSummary(String locale, String userToken) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v1" + "/message/summary?importance={importance}";
        HashMap<String, String> uriVariables = new HashMap<String, String>(1);
        uriVariables.put("importance", "1");
        1 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, userToken), uriVariables, (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public DigiwinAimNewMessageSummary listMessageSummary(String locale, String userToken, Integer pageNum, Integer pageSize) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v2" + "/message/summary";
        HashMap<String, Object> uriVariables = new HashMap<String, Object>(2);
        uriVariables.put("channelType", "app");
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("pageSize", pageSize);
        2 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, userToken), JsonUtil.javaObjectToJsonString(uriVariables), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAimNewMessageSummary)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAimNewMessageSummary();
    }

    public Integer countMessageUnRead(String locale, String userToken, Integer state) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v2" + "/message/summary";
        HashMap<String, Object> uriVariables = new HashMap<String, Object>(1);
        uriVariables.put("channelType", "app");
        uriVariables.put("state", state);
        uriVariables.put("pageNum", 0);
        uriVariables.put("pageSize", 1);
        3 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, userToken), JsonUtil.javaObjectToJsonString(uriVariables), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        DigiwinAimNewMessageSummary digiwinAimNewMessageSummary = statusCode.is2xxSuccessful() ? (DigiwinAimNewMessageSummary)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAimNewMessageSummary();
        return digiwinAimNewMessageSummary.getTotalElements();
    }

    public List<DigiwinAimWorknewsMessageSummary> listWorknewsMessageSummary(String locale, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v1" + "/worknews/message/summary";
        4 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), Collections.emptyMap(), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public List<DigiwinAimMessage> listImportantMessageByAimMessageCategoryId(String locale, String userToken, String aimMessageCategoryId) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v1" + "/message/" + aimMessageCategoryId + "/summary?importance={importance}";
        HashMap<String, String> uriVariables = new HashMap<String, String>(1);
        uriVariables.put("importance", "1");
        5 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, userToken), uriVariables, (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public List<DigiwinAimMessage> listMessageSummaryByAimMessageCategoryId(String locale, String userToken, Integer pageNum, Integer pageSize, String aimMessageCategoryId) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v2" + "/message/summary";
        HashMap<String, Object> uriVariables = new HashMap<String, Object>(2);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("subTypeCategory", aimMessageCategoryId);
        6 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, userToken), JsonUtil.javaObjectToJsonString(uriVariables), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? ((DigiwinAimNewMessageSummary)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse()).getContent() : Collections.emptyList();
    }

    public Long setMessageCategoryRead(String locale, String userToken, String subTypeCategory) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v1" + "/message/read";
        HashMap<String, String> bodyPayload = new HashMap<String, String>(2);
        bodyPayload.put("importance", "1");
        bodyPayload.put("subTypeCategory", subTypeCategory);
        7 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, userToken), JsonUtil.javaObjectToJsonString(bodyPayload), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (Long)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Long.valueOf(-1L);
    }

    public Long batchMessageRead(String locale, String iamUserToken, List<String> gidList) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v2" + "/message/read";
        HashMap<String, List<String>> bodyPayload = new HashMap<String, List<String>>(1);
        bodyPayload.put("gidList", gidList);
        8 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), JsonUtil.javaObjectToJsonString(bodyPayload), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (Long)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Long.valueOf(-1L);
    }

    public List<ExpireApplicationNoticeInfo> getExpireApplicationNoticeInfo(String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v2/expire/list";
        9 responseType = new /* Unavailable Anonymous Inner Class!! */;
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setUserToken(iamUserToken);
        athenaBasicHttpRequestHead.setTenantId(tenantId);
        ResponseEntity responseEntity = this.httpService.doGet(url, athenaBasicHttpRequestHead, new HashMap(1), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() && Optional.ofNullable(responseEntity).map(HttpEntity::getBody).map(DigiwinAthenaApiResponse::getStatus).orElse(-1).intValue() == HttpStatus.OK.value() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public void sendUserMessage(String iamUserToken, String messageData) {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v2" + "/batch/user/message";
        try {
            this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), messageData, Object.class);
        }
        catch (Exception e) {
            logger.error("Iam\u7ed9\u7528\u6237\u53d1\u9001\u6d88\u606f\u901a\u77e5\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public Integer readAll(String locale, String userToken) {
        10 responseType;
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v2" + "/message/readAll?channelType=app";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, userToken), new HashMap(1), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (Integer)((DigiwinAthenaApiResponse)Objects.requireNonNull(responseEntity.getBody())).getResponse() : Integer.valueOf(0);
    }

    public String getTenantRouteType(String userToken) {
        11 responseType;
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v1" + "/tenant/route/getType?app=mui";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken), new HashMap(1), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (String)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : null;
    }

    public Integer oneClickRemove() {
        String url = AppContext.getApiUrlSetting().getAimUrl() + "/api/aim/v2" + "/message/summary/remove?channelType=app";
        12 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(), new HashMap(1), (ParameterizedTypeReference)responseType);
        Integer removeNum = 0;
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            removeNum = ((JSONObject)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse()).getInteger("removeNum");
        }
        return removeNum;
    }
}

