/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.ocr.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsData;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsEnum;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.ocr.model.ApiRequestOcr;
import com.digiwin.mobile.mobileuibot.ocr.model.OcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiOcrCarNumber;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiOcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ai.service.DigiwinAiProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.ocr.model.OcrData;
import com.digiwin.mobile.mobileuibot.proxy.ocr.service.OcrService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="ocrService")
public class OcrServiceImpl
implements OcrService {
    private static Logger logger = LoggerFactory.getLogger(OcrServiceImpl.class);
    @Autowired
    private HttpService httpService;
    @Autowired
    private DigiwinAiProxyService digiwinAiProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private ZhilinkService zhilinkService;

    public List<OcrData> getIDCardByOcr(String flag, String pic) {
        String url = AppContext.getApiUrlSetting().getOcrApiUrl() + "/datasnap/rest/TServerMethods1/PictureRecognition/IDCard";
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("Token", OcrServiceImpl.getMD5String((String)("DIGIWINAIKEY" + OcrServiceImpl.dateLong())).toUpperCase());
        params.put("Flag", flag);
        params.put("Data", pic);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(params), Map.class);
        if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
            Map map = (Map)((List)((Map)responseEntity.getBody()).get("result")).get(0);
            return this.mapToObject(map);
        }
        return null;
    }

    public List<OcrData> getBankCardByOcr(String pic) {
        ArrayList ocrDataList = new ArrayList();
        String url = AppContext.getApiUrlSetting().getOcrApiUrl() + "/datasnap/rest/TServerMethods1/PictureRecognition/BankCard";
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("Token", OcrServiceImpl.getMD5String((String)("DIGIWINAIKEY" + OcrServiceImpl.dateLong())).toUpperCase());
        params.put("Data", pic);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(params), Map.class);
        if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
            Map map = (Map)((List)((Map)responseEntity.getBody()).get("result")).get(0);
            return this.mapToObject(map);
        }
        return null;
    }

    public DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> getOcrCarNumber(String locale, String iamUserToken, String userId, String tenantId, String image) {
        return this.digiwinAiProxyService.getOcrCarNumber(locale, iamUserToken, userId, tenantId, image);
    }

    public OcrCarNumberResult getZtbOcrCarNumber(ApiRequestOcr apiRequest, String image) {
        String rawDataStr = apiRequest.getRawDataStr();
        logger.error("\u6536\u7684rawDataStr:", (Object)rawDataStr);
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String userId = apiRequest.getUserId();
        String tenantId = apiRequest.getTenantId();
        OcrCarNumberResult ocrCarNumberResult = new OcrCarNumberResult();
        DigiwinAiApiResponse digiwinAiApiResponse = this.getOcrCarNumber(locale, iamUserToken, userId, tenantId, image);
        if (digiwinAiApiResponse.getCode() != 0) {
            return this.buildErrorRusult("-1", ocrCarNumberResult, this.localeService.getLanguageValue(locale, "\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5"));
        }
        Map rawData = (Map)JSONObject.parseObject((String)rawDataStr, Map.class);
        Optional<Object> scanRequestIdOpt = Optional.ofNullable(rawData).map(item -> item.get("scanRequestId"));
        if (scanRequestIdOpt.isPresent() && rawData != null && ComponentSettingRequestIdEnum.OCR_ZTB_CAR_NUMBER.getReuqestId().equalsIgnoreCase((String)rawData.get("scanRequestId"))) {
            return this.buildZtbResult(digiwinAiApiResponse, rawData, apiRequest, ocrCarNumberResult);
        }
        HashMap<String, Action> resultMap = new HashMap<String, Action>(1);
        resultMap.put("action", this.buildAction(locale, digiwinAiApiResponse));
        ocrCarNumberResult.setResultMap(resultMap);
        return ocrCarNumberResult;
    }

    private OcrCarNumberResult buildZtbResult(DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> digiwinAiApiResponse, Map<String, Object> rawData, ApiRequestOcr apiRequest, OcrCarNumberResult ocrCarNumberResult) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String userId = apiRequest.getUserId();
        String tenantId = apiRequest.getTenantId();
        List digiwinAiOcrCarNumberList = ((DigiwinAiOcrCarNumberResult)digiwinAiApiResponse.getData()).getWordsResult();
        if (!CollectionUtils.isEmpty((Collection)digiwinAiOcrCarNumberList)) {
            String taskNo = (String)rawData.get("task_no");
            Map joinTenant = this.zhilinkService.joinTenant(iamUserToken, locale, taskNo, userId);
            if (!((Boolean)joinTenant.get("isSuccess")).booleanValue()) {
                Action action = (Action)joinTenant.get("action");
                return this.buildErrorRusult("-1", ocrCarNumberResult, action.getToastMsg());
            }
            DigiwinAiOcrCarNumber carNumber = (DigiwinAiOcrCarNumber)digiwinAiOcrCarNumberList.get(0);
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("task_no", taskNo);
            params.put("license_plate_no", carNumber.getNumber());
            Map codeScan = this.digiwinEspProxyService.taskTransportOcrScan(iamUserToken, tenantId, locale, params);
            if (CollectionUtils.isEmpty((Map)codeScan)) {
                return this.buildErrorRusult("-2", ocrCarNumberResult, this.localeService.getLanguageValue(locale, "\u5f53\u524d\u8f66\u724c\u672a\u6709\u53f8\u673a\u4fe1\u606f\u8bf7\u8054\u7cfb\u53f8\u673a\u7ef4\u62a4\u5904\u7406"));
            }
            Map vehicleInfo = (Map)codeScan.get("vehicle_info");
            List submitParamsList = (List)JSONObject.parseObject((String)apiRequest.getSubmitParamsStr(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            JSONArray cargoInformation = JSONObject.parseArray((String)apiRequest.getCargoInformation());
            if (!CollectionUtils.isEmpty((Map)codeScan) && !CollectionUtils.isEmpty((Map)vehicleInfo)) {
                if (!CollectionUtils.isEmpty((Collection)submitParamsList)) {
                    block8: for (ActionSubmitParam submitParam : submitParamsList) {
                        switch (submitParam.getType()) {
                            case "LOGISTICS": {
                                List logisticsDataList = ModuleUtils.listMapToListObject((List)((List)submitParam.getParams()), LogisticsData.class);
                                for (LogisticsData data : logisticsDataList) {
                                    if (LogisticsEnum.SEND.getValue().equals(data.getType())) {
                                        codeScan.put("delivery_address_id", data.getId());
                                        continue;
                                    }
                                    if (!LogisticsEnum.RECEIVER.getValue().equals(data.getType())) continue;
                                    codeScan.put("receipt_address_id", data.getId());
                                }
                                continue block8;
                            }
                            case "INPUT_DATETIME_PICKER": {
                                InputDateTimePicker inputDateTimePicker = (InputDateTimePicker)JsonUtil.objectToJavaObject((Object)submitParam.getParams(), InputDateTimePicker.class);
                                codeScan.put(submitParam.getSchema(), InputDateTime.getDateTypeDateStringByType((InputDateTime)inputDateTimePicker.getDatetimeValue(), (Integer)InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType()));
                                break;
                            }
                        }
                    }
                }
                ocrCarNumberResult.setResultMap(this.zhilinkService.buildDriverCodeResultMap(new HashMap(2), rawData, codeScan, vehicleInfo, (Object)cargoInformation));
                ocrCarNumberResult.setCode("0");
                return ocrCarNumberResult;
            }
            return this.buildErrorRusult("-2", ocrCarNumberResult, this.localeService.getLanguageValue(locale, "\u5f53\u524d\u8f66\u724c\u672a\u6709\u53f8\u673a\u4fe1\u606f\u8bf7\u8054\u7cfb\u53f8\u673a\u7ef4\u62a4\u5904\u7406"));
        }
        return this.buildErrorRusult("-1", ocrCarNumberResult, this.localeService.getLanguageValue(locale, "\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5"));
    }

    private OcrCarNumberResult buildErrorRusult(String code, OcrCarNumberResult ocrCarNumberResult, String errorMsg) {
        ocrCarNumberResult.setErrorMsg(errorMsg);
        ocrCarNumberResult.setCode(code);
        return ocrCarNumberResult;
    }

    private Action buildAction(String locale, DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> digiwinAiApiResponse) {
        Set numberSet = ((DigiwinAiOcrCarNumberResult)digiwinAiApiResponse.getData()).getWordsResult().stream().map(e -> e.getNumber()).collect(Collectors.toSet());
        String numbersStr = "\u5f53\u524d\u8bc6\u522b\u8f66\u724c\u53f7\uff1a" + StringUtils.join(numberSet, (String)"\r\n");
        Action action = new Action();
        action.setType(ActionTypeEnum.POP_PROMPT.getValue());
        PopPromptMsg popPromptMsg = new PopPromptMsg();
        popPromptMsg.setTitle(this.localeService.getLanguageValue(locale, "\u63d0\u793a"));
        popPromptMsg.setContent(numbersStr);
        Button button = new Button();
        button.setName(this.localeService.getLanguageValue(locale, "\u786e\u5b9a"));
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        button.setAction(new Action(ActionTypeEnum.BACK.getValue()));
        popPromptMsg.setButtonList(Collections.singletonList(button));
        action.setPopPromptMsg(popPromptMsg);
        return action;
    }

    public static String dateLong() {
        Calendar cd = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String str = sdf.format(cd.getTime());
        System.out.println(str);
        return str;
    }

    public static String getMD5String(String str) {
        try {
            return DigestUtils.md5DigestAsHex((byte[])str.getBytes("utf-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OcrData> mapToObject(Map map) {
        ArrayList<OcrData> ocrDataList = new ArrayList<OcrData>();
        Set keys = map.keySet();
        for (String key : keys) {
            OcrData ocrData = new OcrData();
            ocrData.setField(key);
            ocrData.setFieldValue((String)map.get(key));
            ocrDataList.add(ocrData);
        }
        return ocrDataList;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(OcrServiceImpl.getMD5String((String)("DIGIWINAIKEY" + OcrServiceImpl.dateLong())).toUpperCase());
    }
}

