/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.statsindex;

import com.digiwin.mobile.mobileuibot.common.string.RegexUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataAnalysisData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartFieldDisplayFormat;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableDecimalRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableUnit;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSetting
implements AgileDataRenderSetting {
    private static final Logger log = LoggerFactory.getLogger(IndexSetting.class);
    private static final long serialVersionUID = -7797686096822946834L;
    private String title;
    private String value = "0";
    private String percent;
    private Integer decimal;
    private String businessType;
    private String description;
    private UiBotTableDecimalRule decimalRule;
    private UiBotTableUnit unit;
    private List<AgileDataAnalysisData> dimensionData;
    private List<AgileDataAnalysisData> measurementData;

    public String getActualTitle(AgileDataIntermediateDataItem statisticDataItem) {
        return this.title;
    }

    public String getActualValue(AgileDataIntermediateDataItem statisticDataItem) {
        if (RegexUtil.isMatch((String)"^(\\-|\\+)?\\d+(\\.\\d+)?((E|e)(\\-)?\\d+)?$", (CharSequence)this.value)) {
            return this.getActualValueFormatted(this.value, statisticDataItem);
        }
        return this.value;
    }

    private String getActualValueFormatted(String value, AgileDataIntermediateDataItem statisticDataItem) {
        AgileDataChartFieldDisplayFormat format = new AgileDataChartFieldDisplayFormat().setPercent(this.percent).setDecimal(this.decimal);
        if (null == this.decimal) {
            return this.value;
        }
        return format.getFormattedString(Double.valueOf(new BigDecimal(this.value).doubleValue()));
    }

    public String getTitle() {
        return this.title;
    }

    public String getValue() {
        return this.value;
    }

    public String getPercent() {
        return this.percent;
    }

    public Integer getDecimal() {
        return this.decimal;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getDescription() {
        return this.description;
    }

    public UiBotTableDecimalRule getDecimalRule() {
        return this.decimalRule;
    }

    public UiBotTableUnit getUnit() {
        return this.unit;
    }

    public List<AgileDataAnalysisData> getDimensionData() {
        return this.dimensionData;
    }

    public List<AgileDataAnalysisData> getMeasurementData() {
        return this.measurementData;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setPercent(String percent) {
        this.percent = percent;
    }

    public void setDecimal(Integer decimal) {
        this.decimal = decimal;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDecimalRule(UiBotTableDecimalRule decimalRule) {
        this.decimalRule = decimalRule;
    }

    public void setUnit(UiBotTableUnit unit) {
        this.unit = unit;
    }

    public void setDimensionData(List<AgileDataAnalysisData> dimensionData) {
        this.dimensionData = dimensionData;
    }

    public void setMeasurementData(List<AgileDataAnalysisData> measurementData) {
        this.measurementData = measurementData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexSetting)) {
            return false;
        }
        IndexSetting other = (IndexSetting)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$decimal = this.getDecimal();
        Integer other$decimal = other.getDecimal();
        if (this$decimal == null ? other$decimal != null : !((Object)this$decimal).equals(other$decimal)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$percent = this.getPercent();
        String other$percent = other.getPercent();
        if (this$percent == null ? other$percent != null : !this$percent.equals(other$percent)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        UiBotTableDecimalRule this$decimalRule = this.getDecimalRule();
        UiBotTableDecimalRule other$decimalRule = other.getDecimalRule();
        if (this$decimalRule == null ? other$decimalRule != null : !this$decimalRule.equals(other$decimalRule)) {
            return false;
        }
        UiBotTableUnit this$unit = this.getUnit();
        UiBotTableUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        List this$dimensionData = this.getDimensionData();
        List other$dimensionData = other.getDimensionData();
        if (this$dimensionData == null ? other$dimensionData != null : !((Object)this$dimensionData).equals(other$dimensionData)) {
            return false;
        }
        List this$measurementData = this.getMeasurementData();
        List other$measurementData = other.getMeasurementData();
        return !(this$measurementData == null ? other$measurementData != null : !((Object)this$measurementData).equals(other$measurementData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $decimal = this.getDecimal();
        result = result * 59 + ($decimal == null ? 43 : ((Object)$decimal).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $percent = this.getPercent();
        result = result * 59 + ($percent == null ? 43 : $percent.hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        UiBotTableDecimalRule $decimalRule = this.getDecimalRule();
        result = result * 59 + ($decimalRule == null ? 43 : $decimalRule.hashCode());
        UiBotTableUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        List $dimensionData = this.getDimensionData();
        result = result * 59 + ($dimensionData == null ? 43 : ((Object)$dimensionData).hashCode());
        List $measurementData = this.getMeasurementData();
        result = result * 59 + ($measurementData == null ? 43 : ((Object)$measurementData).hashCode());
        return result;
    }

    public String toString() {
        return "IndexSetting(title=" + this.getTitle() + ", value=" + this.getValue() + ", percent=" + this.getPercent() + ", decimal=" + this.getDecimal() + ", businessType=" + this.getBusinessType() + ", description=" + this.getDescription() + ", decimalRule=" + this.getDecimalRule() + ", unit=" + this.getUnit() + ", dimensionData=" + this.getDimensionData() + ", measurementData=" + this.getMeasurementData() + ")";
    }
}

