/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotLayoutJsonDeserializer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableAttachmentColumnAttribute;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditor;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditorOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableDecimalRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableUnit;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class UiBotTableColumn
extends UiBotBizFieldBase {
    private static final long serialVersionUID = 6293604605440647803L;
    public static final String VALUE_EMPTY_SYMBOL = "-";
    public static final String VALUE_EMPTY_STRING_SYMBOL = "";
    public static final Integer AGILE_DATA_DEFAULT_DECIMAL = 2;
    private List<UiBotTableColumn> columns;
    private Boolean filterable;
    private String headerName;
    private JSONArray operations;
    private String path;
    private Boolean showIcon;
    private Boolean editable;
    private Boolean sortable;
    private Boolean rowGroupable;
    private JSONObject dataPrecision;
    private UiBotTableColumnEditor editor;
    private List<PcUiBotTagDefinition> tagDefinitions;
    private UiBotTableAttachmentColumnAttribute attribute;
    private Boolean thousandthPercentile;
    private String buckets;
    private Map<String, Object> extendParas;
    private Integer decimal = -1;
    @JsonDeserialize(contentUsing=PcUiBotLayoutJsonDeserializer.class)
    private List<UiBotLayout> group;
    private String businessType;
    private String percent;
    private UiBotTableDecimalRule decimalRule;
    private UiBotTableUnit unit;
    private Integer ocrType;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    private String mContentType;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    private Boolean mRequired;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    private Integer maxLength = 255;
    private String enumKey;

    public static UiBotTableColumn create(String headerName, String schema) {
        UiBotTableColumn column = new UiBotTableColumn();
        column.setHeaderName(headerName);
        column.setSchema(schema);
        return column;
    }

    public static void main(String[] args) {
        System.out.println(UiBotTableColumn.getMaxPublicSubNameBetweenColumns((String)"new_issue_qty", (String)"old_issue_qty"));
    }

    public static String getMaxPublicSubNameBetweenColumns(String columnHeaderName1, String columnHeaderName2) {
        if (null == columnHeaderName1 || null == columnHeaderName2) {
            return "";
        }
        if (columnHeaderName1.isEmpty() || columnHeaderName2.isEmpty()) {
            return "";
        }
        columnHeaderName1 = columnHeaderName1.toLowerCase();
        columnHeaderName2 = columnHeaderName2.toLowerCase();
        int len1 = columnHeaderName1.length();
        int len2 = columnHeaderName2.length();
        String min = null;
        String max = null;
        String target = null;
        min = len1 <= len2 ? columnHeaderName1 : columnHeaderName2;
        max = len1 > len2 ? columnHeaderName1 : columnHeaderName2;
        for (int i = min.length(); i >= 1; --i) {
            for (int j = 0; j <= min.length() - i; ++j) {
                target = min.substring(j, j + i);
                for (int k = 0; k <= max.length() - i; ++k) {
                    if (!max.substring(k, k + i).equals(target)) continue;
                    return target;
                }
            }
        }
        return "";
    }

    public boolean canEdit() {
        boolean nonFileCanEdit = Optional.ofNullable(this.getEditable()).orElse(false) != false || Optional.ofNullable(this.getEditor()).map(UiBotTableColumnEditor::getEditable).orElse(false) != false;
        boolean fileCanEdit = this.getType() != null && this.getType().toUpperCase().contains("UPLOAD") && this.getAttribute().getEditable() != false;
        return nonFileCanEdit || fileCanEdit;
    }

    public void doSetCanEdit() {
        this.setEditable(Boolean.valueOf(true));
        Optional.ofNullable(this.getEditor()).ifPresent(editor -> editor.setEditable(Boolean.valueOf(true)));
        if (null != this.getType() && this.getType().toUpperCase().contains("UPLOAD")) {
            Optional.ofNullable(this.getAttribute()).ifPresent(attribute -> attribute.setEditable(Boolean.valueOf(true)));
        }
    }

    public void doSetCanNotEdit() {
        this.setEditable(Boolean.valueOf(false));
        Optional.ofNullable(this.getEditor()).ifPresent(editor -> editor.setEditable(Boolean.valueOf(false)));
        if (null != this.getType() && this.getType().toUpperCase().contains("UPLOAD")) {
            Optional.ofNullable(this.getAttribute()).ifPresent(attribute -> attribute.setEditable(Boolean.valueOf(false)));
        }
    }

    public void reverseEditableState() {
        if (this.canEdit()) {
            this.doSetCanNotEdit();
        } else {
            this.doSetCanEdit();
        }
    }

    public boolean canUpload() {
        return this.getType() != null && this.getType().toUpperCase().contains("UPLOAD") && this.getAttribute().getUploadEnable() != false;
    }

    public boolean canEditWithSelect() {
        return this.canEdit() && "SELECT".equalsIgnoreCase(Optional.ofNullable(this.getEditor()).map(UiBotTableColumnEditor::getType).orElse(""));
    }

    public boolean canEditWithOpenWindow() {
        return this.canEdit() && "OPERATION_EDITOR".equalsIgnoreCase(Optional.ofNullable(this.getType()).orElse(""));
    }

    public boolean isNumericData() {
        return null != this.getDataType() && "numeric".equalsIgnoreCase(this.getDataType());
    }

    public boolean isRenderInPercentType() {
        return null != this.getPercent() && this.getPercent().contains("percent");
    }

    public String getValueForDisplay(Map<String, Object> bizData) {
        return this.getValueForDisplay(bizData, false);
    }

    public String getValueForDisplay(Map<String, Object> bizData, boolean isAgileData) {
        String bizDataSchema = this.getSchema();
        String type = Optional.ofNullable(this.getType()).orElse("");
        String dataType = this.getDataType();
        String editorType = Optional.ofNullable(this.getEditor()).map(UiBotTableColumnEditor::getType).orElse("");
        String value = "";
        boolean isPercentType = this.isRenderInPercentType();
        if (!bizData.containsKey(bizDataSchema) || null == bizData.get(bizDataSchema)) {
            value = "";
        } else if ("boolean".equalsIgnoreCase(dataType) || "string".equalsIgnoreCase(dataType)) {
            Object rawValue = bizData.get(bizDataSchema);
            value = String.valueOf(rawValue);
            if ("".equalsIgnoreCase(editorType) && "LABEL".equalsIgnoreCase(type) && "null".equalsIgnoreCase(value)) {
                value = "-";
            }
            if ("SELECT".equalsIgnoreCase(editorType) || "SELECT".equalsIgnoreCase(type)) {
                String bizValue = String.valueOf(bizData.get(bizDataSchema));
                value = this.getSelectFieldOptionTitle(this, bizValue);
            }
            if (isPercentType) {
                Integer percentDecimal = this.decimal;
                BigDecimal bigDecimalValue = new BigDecimal(value);
                value = null == percentDecimal ? String.format("%,f%%", bigDecimalValue.movePointRight(2).doubleValue()) : String.format("%,." + percentDecimal + "f%%", bigDecimalValue.movePointRight(2).doubleValue());
            }
            if (rawValue instanceof Double && this.decimal <= -1) {
                value = MathUtil.stripTrailingZerosInDoubleString((String)value);
            }
        } else if ("date".equalsIgnoreCase(dataType)) {
            value = String.valueOf(bizData.get(bizDataSchema));
            value = null != value && value.length() > 10 ? value.substring(0, 10) : value;
            value = DateTimeUtil.getDateTextInMobileShowDefaultPattern((String)value);
        } else if ("numeric".equalsIgnoreCase(dataType)) {
            BigDecimal bigDecimalValue = new BigDecimal(String.valueOf(bizData.get(bizDataSchema)));
            double dValue = bigDecimalValue.doubleValue();
            boolean hasThousandthPercentile = Optional.ofNullable(this.getThousandthPercentile()).orElse(false);
            value = hasThousandthPercentile && isPercentType ? (this.decimal <= -1 ? bigDecimalValue.toPlainString() : String.format("%,." + this.decimal + "f%%", bigDecimalValue.movePointRight(2).doubleValue())) : (hasThousandthPercentile && !isPercentType ? (this.decimal <= -1 ? bigDecimalValue.toPlainString() : String.format("%,." + this.decimal + "f", dValue)) : (!hasThousandthPercentile && isPercentType ? (this.decimal <= -1 ? bigDecimalValue.toPlainString() : String.format("%." + this.decimal + "f%%", bigDecimalValue.movePointRight(2).doubleValue())) : (this.decimal <= -1 ? bigDecimalValue.toPlainString() : String.format("%." + this.decimal + "f", dValue))));
            if (!isAgileData) {
                value = MathUtil.stripTrailingZerosInDoubleString((String)value);
                this.setType("LABEL");
            }
        } else if ("object".equalsIgnoreCase(dataType)) {
            if ("FORM_OPERATION_EDITOR".equalsIgnoreCase(type)) {
                if ("task_member_info".equals(bizDataSchema)) {
                    List opertaionValueList = (List)bizData.get(bizDataSchema);
                    for (Object map : opertaionValueList) {
                        if (!(map instanceof HashMap)) continue;
                        value = value + ((HashMap)map).get("executor_name") + ",";
                    }
                    value = StringUtils.hasLength((String)value) ? value.substring(0, value.length() - 1) : "-";
                } else {
                    List opertaionValueList = (List)bizData.get(bizDataSchema);
                    ArrayList values = new ArrayList();
                    String commonKeyName = bizDataSchema.substring(0, bizDataSchema.indexOf("info"));
                    opertaionValueList.forEach(opeMap -> {
                        String noKey = commonKeyName + "no";
                        String nameKey = commonKeyName + "name";
                        String displayValue = (String)opeMap.get(noKey) + " " + (String)opeMap.get(nameKey);
                        values.add(displayValue);
                    });
                    value = String.join((CharSequence)";", values);
                }
            } else {
                value = "";
            }
            this.setType("LABEL");
        } else if (type.toUpperCase().contains("UPLOAD")) {
            value = "";
            this.setType("LABEL");
        } else if ("DYNAMIC_GRAPH_VIEWER".equalsIgnoreCase(type)) {
            List tempList;
            Object dataObj = bizData.get(bizDataSchema);
            Map data = dataObj instanceof List ? ((tempList = (List)dataObj).isEmpty() ? Collections.emptyMap() : (Map)tempList.get(0)) : (dataObj instanceof Map ? (Map)dataObj : Collections.emptyMap());
            String graphNo = String.valueOf(data.getOrDefault("graph_no", ""));
            value = StringUtils.hasLength((String)graphNo) ? graphNo : "";
        } else {
            value = String.valueOf(bizData.get(bizDataSchema));
        }
        return null == value || value.trim().isEmpty() ? "" : value;
    }

    private String getSelectFieldOptionTitle(UiBotTableColumn column, String bizDataValue) {
        UiBotTableColumnEditor editor = column.getEditor();
        if (null == editor || !editor.getSchema().equalsIgnoreCase(column.getSchema()) || !"SELECT".equalsIgnoreCase(editor.getType())) {
            return "-";
        }
        if (null == editor.getOptions()) {
            return "-";
        }
        for (UiBotTableColumnEditorOption option : editor.getOptions()) {
            String optionValue = String.valueOf(option.getValue());
            if (!optionValue.equalsIgnoreCase(bizDataValue)) continue;
            return String.valueOf(option.getTitle());
        }
        return "-";
    }

    public UiBotTableColumn(String headerName) {
        this.headerName = headerName;
    }

    public static UiBotTableColumn createEmpty() {
        return new UiBotTableColumn();
    }

    public Map<String, Object> parseExecuteContextToRawData(UiBotTableColumn column, UiBotExecuteContext executeContext) {
        HashMap<String, Object> rawData = new HashMap<String, Object>(8);
        if (column.getOperations() != null && column.getOperations().size() > 0) {
            JSONObject operation = column.getOperations().getJSONObject(0);
            rawData.put("dataSourceSet", operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("dataSourceSet"));
            rawData.put("defaultShow", operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getBooleanValue("defaultShow"));
            JSONObject executeContextObj = operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("executeContext");
            if (executeContextObj != null) {
                rawData.put("executeContext", executeContextObj);
            } else {
                rawData.put("executeContext", executeContext);
            }
            rawData.put("multipleSelect", operation.getJSONObject("openWindowDefine").getBooleanValue("multipleSelect"));
            rawData.put("selectedFirstRow", operation.getJSONObject("openWindowDefine").getBooleanValue("selectedFirstRow"));
            rawData.put("queryTagSuffix", "DIALOG");
            rawData.put("buttons", operation.getJSONObject("openWindowDefine").getJSONArray("buttons"));
        }
        HashMap<String, String> parameter = new HashMap<String, String>(8);
        parameter.put("", "");
        rawData.put("parameter", parameter);
        return rawData;
    }

    public List<UiBotTableColumn> getColumns() {
        return this.columns;
    }

    public Boolean getFilterable() {
        return this.filterable;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public JSONArray getOperations() {
        return this.operations;
    }

    public String getPath() {
        return this.path;
    }

    public Boolean getShowIcon() {
        return this.showIcon;
    }

    public Boolean getEditable() {
        return this.editable;
    }

    public Boolean getSortable() {
        return this.sortable;
    }

    public Boolean getRowGroupable() {
        return this.rowGroupable;
    }

    public JSONObject getDataPrecision() {
        return this.dataPrecision;
    }

    public UiBotTableColumnEditor getEditor() {
        return this.editor;
    }

    public List<PcUiBotTagDefinition> getTagDefinitions() {
        return this.tagDefinitions;
    }

    public UiBotTableAttachmentColumnAttribute getAttribute() {
        return this.attribute;
    }

    public Boolean getThousandthPercentile() {
        return this.thousandthPercentile;
    }

    public String getBuckets() {
        return this.buckets;
    }

    public Map<String, Object> getExtendParas() {
        return this.extendParas;
    }

    public Integer getDecimal() {
        return this.decimal;
    }

    public List<UiBotLayout> getGroup() {
        return this.group;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getPercent() {
        return this.percent;
    }

    public UiBotTableDecimalRule getDecimalRule() {
        return this.decimalRule;
    }

    public UiBotTableUnit getUnit() {
        return this.unit;
    }

    public Integer getOcrType() {
        return this.ocrType;
    }

    public String getMContentType() {
        return this.mContentType;
    }

    public Boolean getMRequired() {
        return this.mRequired;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getEnumKey() {
        return this.enumKey;
    }

    public void setColumns(List<UiBotTableColumn> columns) {
        this.columns = columns;
    }

    public void setFilterable(Boolean filterable) {
        this.filterable = filterable;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public void setOperations(JSONArray operations) {
        this.operations = operations;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setShowIcon(Boolean showIcon) {
        this.showIcon = showIcon;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public void setRowGroupable(Boolean rowGroupable) {
        this.rowGroupable = rowGroupable;
    }

    public void setDataPrecision(JSONObject dataPrecision) {
        this.dataPrecision = dataPrecision;
    }

    public void setEditor(UiBotTableColumnEditor editor) {
        this.editor = editor;
    }

    public void setTagDefinitions(List<PcUiBotTagDefinition> tagDefinitions) {
        this.tagDefinitions = tagDefinitions;
    }

    public void setAttribute(UiBotTableAttachmentColumnAttribute attribute) {
        this.attribute = attribute;
    }

    public void setThousandthPercentile(Boolean thousandthPercentile) {
        this.thousandthPercentile = thousandthPercentile;
    }

    public void setBuckets(String buckets) {
        this.buckets = buckets;
    }

    public void setExtendParas(Map<String, Object> extendParas) {
        this.extendParas = extendParas;
    }

    public void setDecimal(Integer decimal) {
        this.decimal = decimal;
    }

    @JsonDeserialize(contentUsing=PcUiBotLayoutJsonDeserializer.class)
    public void setGroup(List<UiBotLayout> group) {
        this.group = group;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setPercent(String percent) {
        this.percent = percent;
    }

    public void setDecimalRule(UiBotTableDecimalRule decimalRule) {
        this.decimalRule = decimalRule;
    }

    public void setUnit(UiBotTableUnit unit) {
        this.unit = unit;
    }

    public void setOcrType(Integer ocrType) {
        this.ocrType = ocrType;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setMContentType(String mContentType) {
        this.mContentType = mContentType;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setMRequired(Boolean mRequired) {
        this.mRequired = mRequired;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setEnumKey(String enumKey) {
        this.enumKey = enumKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UiBotTableColumn)) {
            return false;
        }
        UiBotTableColumn other = (UiBotTableColumn)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$filterable = this.getFilterable();
        Boolean other$filterable = other.getFilterable();
        if (this$filterable == null ? other$filterable != null : !((Object)this$filterable).equals(other$filterable)) {
            return false;
        }
        Boolean this$showIcon = this.getShowIcon();
        Boolean other$showIcon = other.getShowIcon();
        if (this$showIcon == null ? other$showIcon != null : !((Object)this$showIcon).equals(other$showIcon)) {
            return false;
        }
        Boolean this$editable = this.getEditable();
        Boolean other$editable = other.getEditable();
        if (this$editable == null ? other$editable != null : !((Object)this$editable).equals(other$editable)) {
            return false;
        }
        Boolean this$sortable = this.getSortable();
        Boolean other$sortable = other.getSortable();
        if (this$sortable == null ? other$sortable != null : !((Object)this$sortable).equals(other$sortable)) {
            return false;
        }
        Boolean this$rowGroupable = this.getRowGroupable();
        Boolean other$rowGroupable = other.getRowGroupable();
        if (this$rowGroupable == null ? other$rowGroupable != null : !((Object)this$rowGroupable).equals(other$rowGroupable)) {
            return false;
        }
        Boolean this$thousandthPercentile = this.getThousandthPercentile();
        Boolean other$thousandthPercentile = other.getThousandthPercentile();
        if (this$thousandthPercentile == null ? other$thousandthPercentile != null : !((Object)this$thousandthPercentile).equals(other$thousandthPercentile)) {
            return false;
        }
        Integer this$decimal = this.getDecimal();
        Integer other$decimal = other.getDecimal();
        if (this$decimal == null ? other$decimal != null : !((Object)this$decimal).equals(other$decimal)) {
            return false;
        }
        Integer this$ocrType = this.getOcrType();
        Integer other$ocrType = other.getOcrType();
        if (this$ocrType == null ? other$ocrType != null : !((Object)this$ocrType).equals(other$ocrType)) {
            return false;
        }
        Boolean this$mRequired = this.getMRequired();
        Boolean other$mRequired = other.getMRequired();
        if (this$mRequired == null ? other$mRequired != null : !((Object)this$mRequired).equals(other$mRequired)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        List this$columns = this.getColumns();
        List other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$headerName = this.getHeaderName();
        String other$headerName = other.getHeaderName();
        if (this$headerName == null ? other$headerName != null : !this$headerName.equals(other$headerName)) {
            return false;
        }
        JSONArray this$operations = this.getOperations();
        JSONArray other$operations = other.getOperations();
        if (this$operations == null ? other$operations != null : !this$operations.equals(other$operations)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        JSONObject this$dataPrecision = this.getDataPrecision();
        JSONObject other$dataPrecision = other.getDataPrecision();
        if (this$dataPrecision == null ? other$dataPrecision != null : !this$dataPrecision.equals(other$dataPrecision)) {
            return false;
        }
        UiBotTableColumnEditor this$editor = this.getEditor();
        UiBotTableColumnEditor other$editor = other.getEditor();
        if (this$editor == null ? other$editor != null : !this$editor.equals(other$editor)) {
            return false;
        }
        List this$tagDefinitions = this.getTagDefinitions();
        List other$tagDefinitions = other.getTagDefinitions();
        if (this$tagDefinitions == null ? other$tagDefinitions != null : !((Object)this$tagDefinitions).equals(other$tagDefinitions)) {
            return false;
        }
        UiBotTableAttachmentColumnAttribute this$attribute = this.getAttribute();
        UiBotTableAttachmentColumnAttribute other$attribute = other.getAttribute();
        if (this$attribute == null ? other$attribute != null : !this$attribute.equals(other$attribute)) {
            return false;
        }
        String this$buckets = this.getBuckets();
        String other$buckets = other.getBuckets();
        if (this$buckets == null ? other$buckets != null : !this$buckets.equals(other$buckets)) {
            return false;
        }
        Map this$extendParas = this.getExtendParas();
        Map other$extendParas = other.getExtendParas();
        if (this$extendParas == null ? other$extendParas != null : !((Object)this$extendParas).equals(other$extendParas)) {
            return false;
        }
        List this$group = this.getGroup();
        List other$group = other.getGroup();
        if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        String this$percent = this.getPercent();
        String other$percent = other.getPercent();
        if (this$percent == null ? other$percent != null : !this$percent.equals(other$percent)) {
            return false;
        }
        UiBotTableDecimalRule this$decimalRule = this.getDecimalRule();
        UiBotTableDecimalRule other$decimalRule = other.getDecimalRule();
        if (this$decimalRule == null ? other$decimalRule != null : !this$decimalRule.equals(other$decimalRule)) {
            return false;
        }
        UiBotTableUnit this$unit = this.getUnit();
        UiBotTableUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$mContentType = this.getMContentType();
        String other$mContentType = other.getMContentType();
        if (this$mContentType == null ? other$mContentType != null : !this$mContentType.equals(other$mContentType)) {
            return false;
        }
        String this$enumKey = this.getEnumKey();
        String other$enumKey = other.getEnumKey();
        return !(this$enumKey == null ? other$enumKey != null : !this$enumKey.equals(other$enumKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UiBotTableColumn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $filterable = this.getFilterable();
        result = result * 59 + ($filterable == null ? 43 : ((Object)$filterable).hashCode());
        Boolean $showIcon = this.getShowIcon();
        result = result * 59 + ($showIcon == null ? 43 : ((Object)$showIcon).hashCode());
        Boolean $editable = this.getEditable();
        result = result * 59 + ($editable == null ? 43 : ((Object)$editable).hashCode());
        Boolean $sortable = this.getSortable();
        result = result * 59 + ($sortable == null ? 43 : ((Object)$sortable).hashCode());
        Boolean $rowGroupable = this.getRowGroupable();
        result = result * 59 + ($rowGroupable == null ? 43 : ((Object)$rowGroupable).hashCode());
        Boolean $thousandthPercentile = this.getThousandthPercentile();
        result = result * 59 + ($thousandthPercentile == null ? 43 : ((Object)$thousandthPercentile).hashCode());
        Integer $decimal = this.getDecimal();
        result = result * 59 + ($decimal == null ? 43 : ((Object)$decimal).hashCode());
        Integer $ocrType = this.getOcrType();
        result = result * 59 + ($ocrType == null ? 43 : ((Object)$ocrType).hashCode());
        Boolean $mRequired = this.getMRequired();
        result = result * 59 + ($mRequired == null ? 43 : ((Object)$mRequired).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        List $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $headerName = this.getHeaderName();
        result = result * 59 + ($headerName == null ? 43 : $headerName.hashCode());
        JSONArray $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : $operations.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        JSONObject $dataPrecision = this.getDataPrecision();
        result = result * 59 + ($dataPrecision == null ? 43 : $dataPrecision.hashCode());
        UiBotTableColumnEditor $editor = this.getEditor();
        result = result * 59 + ($editor == null ? 43 : $editor.hashCode());
        List $tagDefinitions = this.getTagDefinitions();
        result = result * 59 + ($tagDefinitions == null ? 43 : ((Object)$tagDefinitions).hashCode());
        UiBotTableAttachmentColumnAttribute $attribute = this.getAttribute();
        result = result * 59 + ($attribute == null ? 43 : $attribute.hashCode());
        String $buckets = this.getBuckets();
        result = result * 59 + ($buckets == null ? 43 : $buckets.hashCode());
        Map $extendParas = this.getExtendParas();
        result = result * 59 + ($extendParas == null ? 43 : ((Object)$extendParas).hashCode());
        List $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        String $percent = this.getPercent();
        result = result * 59 + ($percent == null ? 43 : $percent.hashCode());
        UiBotTableDecimalRule $decimalRule = this.getDecimalRule();
        result = result * 59 + ($decimalRule == null ? 43 : $decimalRule.hashCode());
        UiBotTableUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $mContentType = this.getMContentType();
        result = result * 59 + ($mContentType == null ? 43 : $mContentType.hashCode());
        String $enumKey = this.getEnumKey();
        result = result * 59 + ($enumKey == null ? 43 : $enumKey.hashCode());
        return result;
    }

    public String toString() {
        return "UiBotTableColumn(columns=" + this.getColumns() + ", filterable=" + this.getFilterable() + ", headerName=" + this.getHeaderName() + ", operations=" + this.getOperations() + ", path=" + this.getPath() + ", showIcon=" + this.getShowIcon() + ", editable=" + this.getEditable() + ", sortable=" + this.getSortable() + ", rowGroupable=" + this.getRowGroupable() + ", dataPrecision=" + this.getDataPrecision() + ", editor=" + this.getEditor() + ", tagDefinitions=" + this.getTagDefinitions() + ", attribute=" + this.getAttribute() + ", thousandthPercentile=" + this.getThousandthPercentile() + ", buckets=" + this.getBuckets() + ", extendParas=" + this.getExtendParas() + ", decimal=" + this.getDecimal() + ", group=" + this.getGroup() + ", businessType=" + this.getBusinessType() + ", percent=" + this.getPercent() + ", decimalRule=" + this.getDecimalRule() + ", unit=" + this.getUnit() + ", ocrType=" + this.getOcrType() + ", mContentType=" + this.getMContentType() + ", mRequired=" + this.getMRequired() + ", maxLength=" + this.getMaxLength() + ", enumKey=" + this.getEnumKey() + ")";
    }

    public UiBotTableColumn() {
    }

    public UiBotTableColumn(List<UiBotTableColumn> columns, Boolean filterable, String headerName, JSONArray operations, String path, Boolean showIcon, Boolean editable, Boolean sortable, Boolean rowGroupable, JSONObject dataPrecision, UiBotTableColumnEditor editor, List<PcUiBotTagDefinition> tagDefinitions, UiBotTableAttachmentColumnAttribute attribute, Boolean thousandthPercentile, String buckets, Map<String, Object> extendParas, Integer decimal, List<UiBotLayout> group, String businessType, String percent, UiBotTableDecimalRule decimalRule, UiBotTableUnit unit, Integer ocrType, String mContentType, Boolean mRequired, Integer maxLength, String enumKey) {
        this.columns = columns;
        this.filterable = filterable;
        this.headerName = headerName;
        this.operations = operations;
        this.path = path;
        this.showIcon = showIcon;
        this.editable = editable;
        this.sortable = sortable;
        this.rowGroupable = rowGroupable;
        this.dataPrecision = dataPrecision;
        this.editor = editor;
        this.tagDefinitions = tagDefinitions;
        this.attribute = attribute;
        this.thousandthPercentile = thousandthPercentile;
        this.buckets = buckets;
        this.extendParas = extendParas;
        this.decimal = decimal;
        this.group = group;
        this.businessType = businessType;
        this.percent = percent;
        this.decimalRule = decimalRule;
        this.unit = unit;
        this.ocrType = ocrType;
        this.mContentType = mContentType;
        this.mRequired = mRequired;
        this.maxLength = maxLength;
        this.enumKey = enumKey;
    }
}

