/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionVariable;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActionBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.MetadataService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class ActionCreateServiceBase {
    private static final Logger log = LoggerFactory.getLogger(ActionCreateServiceBase.class);
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    protected void appendActionInfo(PcUiBotTmActionBase tmAction, PcUiBotExecuteContext executeContext) {
        List dataKeys;
        PcUiBotApiMetadata metadataDataDTO;
        PcUiBotTmAction submitAction;
        if (tmAction instanceof PcUiBotTmQueryAction) {
            PcUiBotTmQueryAction tmQueryAction = (PcUiBotTmQueryAction)tmAction;
            if (tmQueryAction.getLeft() != null) {
                this.appendActionInfo((PcUiBotTmActionBase)tmQueryAction.getLeft(), executeContext);
            }
            if (tmQueryAction.getRightList() != null) {
                for (PcUiBotTmQueryAction action : tmQueryAction.getRightList()) {
                    this.appendActionInfo((PcUiBotTmActionBase)action, executeContext);
                }
            }
        } else if (tmAction instanceof PcUiBotTmAction && (submitAction = (PcUiBotTmAction)tmAction).getAttachActions() != null) {
            for (PcUiBotTmAction action : submitAction.getAttachActions()) {
                this.appendActionInfo((PcUiBotTmActionBase)action, executeContext);
            }
        }
        if ("ESP".equals(tmAction.getType()) && CollectionUtils.isEmpty((Collection)tmAction.getDataKeys()) && (metadataDataDTO = this.getMetadata(executeContext, tmAction.getActionId())) != null && !CollectionUtils.isEmpty((Collection)metadataDataDTO.getResponseFields()) && !CollectionUtils.isEmpty((Collection)(dataKeys = PcUiBotApiMetadataUtil.getDataKeys((List)((PcUiBotMetadataField)metadataDataDTO.getResponseFields().get(0)).getSubFields())))) {
            tmAction.setDataKeys(dataKeys);
        }
    }

    public PcUiBotApiMetadata getMetadata(PcUiBotExecuteContext executeContext, String actionId) {
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables("actionId", actionId).build();
        KnowledgeMapsActionMetadataQueryResult rawMetadataQueryResult = this.digiwinKnowledgeMapsProxyService.actionMetadata(athenaApiRequest);
        return this.metadataService.createApiMetadata(rawMetadataQueryResult);
    }

    protected void processActionParas(PcUiBotAction action, PcUiBotExecuteContext executeContext) {
        PcUiBotSubmitAction submitAction;
        if (!CollectionUtils.isEmpty((Collection)action.getActionParams())) {
            for (PcUiBotActionParameterMapping actionParam : action.getActionParams()) {
                if ("SYSTEM".equals(actionParam.getType())) {
                    if ("SYSTEM_EMPLOYEE_ID".equals(actionParam.getValue())) {
                        actionParam.setValue(this.digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                        actionParam.setType("CONSTANT");
                    } else if ("SYSTEM_USER_ID".equals(actionParam.getValue())) {
                        actionParam.setValue(executeContext.getAuthoredUser().getUserId());
                        actionParam.setType("CONSTANT");
                    }
                }
                if (!"TM_VARIABLE".equals(actionParam.getType())) continue;
                Map variableMap = this.digiwinKnowledgeMapsProxyService.getMechanismParamValue(executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getLocale(), actionParam.getValue());
                Object value = variableMap.get(actionParam.getValue());
                actionParam.setType("CONSTANT");
                if (value == null) {
                    log.debug("variable get from km is null,variable name is:{}", (Object)actionParam.getValue());
                    continue;
                }
                actionParam.setValueType(this.checkValueType(value));
                if (value instanceof String) {
                    actionParam.setValue(String.valueOf(value));
                    continue;
                }
                actionParam.setValue(JsonUtil.javaObjectToJsonString(value));
            }
        }
        if (action instanceof PcUiBotSubmitAction && (submitAction = (PcUiBotSubmitAction)action).getAttachActions() != null) {
            submitAction.getAttachActions().forEach(actionDTO -> this.processActionParas((PcUiBotAction)actionDTO, executeContext));
        }
    }

    private String checkValueType(Object value) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(mapper.writeValueAsString(value));
            if (jsonNode.isContainerNode()) {
                return PcUiBotActionVariable.VariableType.JSON.getValue();
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    protected PcUiBotActionServiceId createActionServiceId(PcUiBotTmActionBase tmActionDTO, String tenantId) {
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        if (StringUtils.isEmpty((Object)tmActionDTO.getProductName())) {
            actionServiceId.setProd(null);
        } else {
            actionServiceId.setProd(tmActionDTO.getProductName());
        }
        actionServiceId.setTenant_id(tenantId);
        actionServiceId.setHostAcct("athena");
        if (tmActionDTO.getNeedProxyToken() != null && tmActionDTO.getNeedProxyToken().booleanValue()) {
            if (StringUtils.hasText((String)AppRequestContext.getContextEntity().getProxyToken())) {
                actionServiceId.setProxyToken(AppRequestContext.getContextEntity().getProxyToken());
            } else if (StringUtils.hasText((String)AppRequestContext.getContextEntity().getIamUserToken())) {
                actionServiceId.setProxyToken(AppRequestContext.getContextEntity().getIamUserToken());
            }
        }
        actionServiceId.setServiceUri(tmActionDTO.getUrl());
        actionServiceId.setName(tmActionDTO.getServiceName());
        return actionServiceId;
    }

    protected PcUiBotSubmitAction initSubmitAction(PcUiBotTmAction tmAction, String tenantId, Map<String, Object> businessUnit, PcUiBotExecuteContext executeContext) {
        this.appendActionInfo((PcUiBotTmActionBase)tmAction, executeContext);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setActionId(tmAction.getActionId());
        action.setServiceId(this.createActionServiceId((PcUiBotTmActionBase)tmAction, tenantId));
        action.setCategory(tmAction.getType());
        action.setUuid(tmAction.getUuid());
        action.setBtnId(tmAction.getBtnId());
        action.setBtnType(tmAction.getBtnType());
        action.setJumpAction(tmAction.getJumpAction());
        action.setTitle(tmAction.getTitle());
        action.setReturnText((Object)tmAction.getReturnText());
        action.setBusinessUnit(businessUnit);
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setBackFills(tmAction.getBackFills());
        action.setTargetDataState(tmAction.getTargetDataState());
        action.setConfirm(tmAction.getConfirm());
        action.setActionType(tmAction.getActionType());
        if (action.getActionType() == null && tmAction.getExtendParas() != null && tmAction.getExtendParas().containsKey("actionType")) {
            action.setActionType(tmAction.getExtendParas().get("actionType").toString());
        }
        action.setId(tmAction.getId());
        action.setActionParams(tmAction.getActionParams());
        action.setCategory(tmAction.getType());
        action.setActionParams(tmAction.getActionParams());
        action.setDefaultAction(true);
        action.setId(tmAction.getId());
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setDefaultAction(tmAction.isDefaultAction());
        action.setActionScript(tmAction.getActionScript());
        action.setParas(tmAction.getParas());
        this.processActionParas((PcUiBotAction)action, executeContext);
        return action;
    }

    protected void taskSubmitActionCheck(DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        if (taskWithBacklogData == null || CollectionUtils.isEmpty((Collection)taskWithBacklogData.getBacklog())) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u4e3a\u4e0d\u5b58\u5728\u7684\u4efb\u52a1\u521b\u5efa\u63d0\u4ea4\u903b\u8f91");
        }
    }

    protected void addAttachApprovalConfig(PcUiBotSubmitAction action, PcUiBotTmActivity tmActivity) {
    }
}

