/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ActionCreateServiceBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmServiceInvokeType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmTaskParser;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class BpmActionCreateService
extends ActionCreateServiceBase {
    public PcUiBotSubmitAction createAgreeAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        return this.createAction(taskData, backlogData, BpmServiceInvokeType.Agree);
    }

    public PcUiBotSubmitAction createRejectAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        return this.createAction(taskData, backlogData, BpmServiceInvokeType.Reject);
    }

    public PcUiBotSubmitAction createTerminateProcessAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        return this.createAction(taskData, backlogData, BpmServiceInvokeType.TerminateProcess);
    }

    public PcUiBotSubmitAction createAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData, BpmServiceInvokeType invokeType) {
        BpmTaskParser bpmTaskParser = this.getBpmTaskParser(taskData);
        if (bpmTaskParser == null) {
            return new PcUiBotSubmitAction();
        }
        PcUiBotSubmitAction action = this.createSubmitAction(invokeType.getTitle(), AppContext.getApiUrlSetting().getBpmUrl() + "/restful/standard/bpm_cloud" + bpmTaskParser.getRelativeUrl(invokeType), invokeType.getName());
        action.setParas(bpmTaskParser.getParameter(taskData, backlogData, invokeType));
        return action;
    }

    private BpmTaskParser getBpmTaskParser(DigiwinAtmcTaskWithBacklogData taskData) {
        if (Objects.equals("UserTask", taskData.getBpmActivityType())) {
            return (BpmTaskParser)SpringContextHolder.getBean((String)"bpmUserTaskParser");
        }
        if (Objects.equals("WaitingTask", taskData.getBpmActivityType()) || Objects.equals("UIBOT__ERROR", taskData.getBpmActivityType())) {
            return (BpmTaskParser)SpringContextHolder.getBean((String)"bpmWaitingTaskParser");
        }
        return null;
    }

    private PcUiBotSubmitAction createSubmitAction(String title, String serviceUri, String name) {
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setTitle(title);
        action.setCategory("WF");
        action.setServiceId(this.createActionServiceId(serviceUri, name));
        return action;
    }

    private PcUiBotActionServiceId createActionServiceId(String serviceUri, String name) {
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        actionServiceId.setServiceUri(serviceUri);
        actionServiceId.setName(name);
        return actionServiceId;
    }
}

