/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmServiceInvokeType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmTaskParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service(value="bpmWaitingTaskParser")
public class BpmWaitingTaskParser
implements BpmTaskParser {
    public String getRelativeUrl(BpmServiceInvokeType invokeType) {
        if (invokeType.equals((Object)BpmServiceInvokeType.Dispatch)) {
            return "/v1/process-engine/tasks/dispatch-waiting-task";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.Agree)) {
            return "/v1/process-engine/tasks/dispatch-waiting-task";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.ReExecute) || invokeType.equals((Object)BpmServiceInvokeType.ReApprove)) {
            return "/v1/process-engine/tasks/reexecute-task";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.TerminateProcess)) {
            return "/v1/process-engine/process-instances/terminate-process";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.AddTask)) {
            return "/v1/process-engine/tasks/add-task";
        }
        return "/v1/process-engine/tasks/terminate-waiting-task";
    }

    public Map<String, Object> getParameter(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData, BpmServiceInvokeType invokeType) {
        String performerId = ((Map)backlogData.getWorkitemList().get(0)).get("performerId").toString();
        String workitemId = ((Map)backlogData.getWorkitemList().get(0)).get("workitemId").toString();
        if (invokeType.equals((Object)BpmServiceInvokeType.TerminateProcess)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("processSerialNumber", taskData.getProcessSerialNumber());
            map.put("performerId", performerId);
            map.put("workitemId", workitemId);
            map.put("comment", "\u5206\u6279\u63d0\u4ea4\u6700\u540e\u4e00\u6279\u6570\u636e\u7ec8\u6b62\u6d41\u7a0b");
            map.put("locale", AppRequestContext.getContextEntity().getLocale());
            return map;
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.AddTask)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("processSerialNumber", taskData.getProcessSerialNumber());
            map.put("workitemId", workitemId);
            map.put("performerId", performerId);
            if (!Objects.equals(performerId, AppRequestContext.getContextEntity().getUserId())) {
                map.put("performerType", 1);
                map.put("agentPerformerId", AppRequestContext.getContextEntity().getUserId());
            }
            map.put("addType", "BackwardDispatch");
            map.put("comment", "\u52a0\u7b7e");
            map.put("locale", AppRequestContext.getContextEntity().getLocale());
            HashMap<String, String> taskMap = new HashMap<String, String>();
            taskMap.put("taskName", backlogData.getPerformerName() + " \u52a0\u7b7e");
            taskMap.put("performMode", "FIREST_GET_FIRST_WIN");
            taskMap.put("performType", "NORMAL");
            taskMap.put("performers", "");
            ArrayList<HashMap<String, String>> taskList = new ArrayList<HashMap<String, String>>();
            taskList.add(taskMap);
            map.put("taskList", taskList);
            return map;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processSerialNumber", taskData.getProcessSerialNumber());
        map.put("taskId", taskData.getBpmActivityId());
        map.put("comment", "");
        map.put("performerId", performerId);
        map.put("locale", AppRequestContext.getContextEntity().getLocale());
        return map;
    }
}

