/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataProcess;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DataSourceDTOFactory;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryActionCreateService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DataSourceAnalysisServiceBase {
    @Autowired
    protected QueryActionCreateService queryActionService;

    protected PcUiBotDataSourceDTO createDataSourceWithoutTask(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmQueryAction) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tmQueryAction.getName())) {
            dataSourceName = tmQueryAction.getName();
        }
        PcUiBotQueryAction queryAction = this.queryActionService.createDataSourceWithoutTask(executeContext, tmQueryAction);
        PcUiBotDataSourceDTO dataSourceDTO = null;
        if (null != queryAction) {
            List processors = this.getDataProcess(tmQueryAction, null, dataSourceName, null, null);
            dataSourceDTO = DataSourceDTOFactory.create((PcUiBotTmQueryAction)tmQueryAction, (PcUiBotQueryAction)queryAction, (String)dataSourceName, (List)processors, (boolean)true);
        }
        if (dataSourceDTO != null) {
            if (tmQueryAction.getLimit() != null) {
                dataSourceDTO.setLimit(tmQueryAction.getLimit());
            }
            dataSourceDTO.setNotArray(tmQueryAction.getNotArray());
            if (tmQueryAction.getMetadataFields() != null) {
                dataSourceDTO.setMetadataFields(tmQueryAction.getMetadataFields());
            }
            return dataSourceDTO;
        }
        return null;
    }

    protected PcUiBotDataSourceDTO createBatchQueryWithoutBacklog(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, PcUiBotTmDataFilter tmDataFilter) {
        if (StringUtils.isEmpty((Object)dataSourceName)) {
            dataSourceName = tmAction.getName();
        }
        ArrayList<PcUiBotQueryAction> actionList = new ArrayList<PcUiBotQueryAction>();
        for (DigiwinAtmcTaskWithBacklogData task : executeContext.getTaskWithBacklogDataList()) {
            PcUiBotQueryAction queryAction = this.queryActionService.createQueryAction(executeContext.getDataStateCode(), tmAction, task, executeContext.getProjectData(), tmDataFilter, dataSourceName, executeContext);
            actionList.add(queryAction);
        }
        if (!CollectionUtils.isEmpty(actionList)) {
            this.mergeQueryByBusinessUnit(actionList);
            List processors = this.getDataProcess(tmAction, tmDataFilter, dataSourceName, null, null);
            return DataSourceDTOFactory.createDataSource(actionList, (List)processors, (String)dataSourceName, (PcUiBotTmQueryAction)tmAction);
        }
        return null;
    }

    protected PcUiBotDataSourceDTO createBatchQueryBacklog(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, List<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList, DigiwinAtmcProjectData projectData, PcUiBotTmDataFilter tmDataFilter, boolean isProject) {
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tmAction.getName())) {
            dataSourceName = tmAction.getName();
        }
        ArrayList<PcUiBotQueryAction> actionList = new ArrayList<PcUiBotQueryAction>();
        block12: for (DigiwinAtmcTaskWithBacklogData digiwinAtmcTaskWithBacklogData : taskWithBacklogDataList) {
            switch (tmAction.getType()) {
                case "ATMC": 
                case "ATMC_CHANGE": 
                case "ESP": 
                case "TM": 
                case "RAWDATA": 
                case "SD": 
                case "LCDP": {
                    PcUiBotQueryAction queryAction = this.queryActionService.createQueryAction(executeContext.getDataStateCode(), tmAction, digiwinAtmcTaskWithBacklogData, projectData, tmDataFilter, dataSourceName, executeContext);
                    if (queryAction == null) continue block12;
                    actionList.add(queryAction);
                    continue block12;
                }
            }
            throw new ServiceException(String.format("\u5bf9\u4e8e%s\u7c7b\u578b\u7684\u6570\u636e\u6e90\u4e0d\u652f\u6301\u6279\u91cf\u5408\u5e76\u67e5\u8be2", tmAction.getType()));
        }
        if (actionList.size() > 1) {
            if (isProject) {
                this.mergeQueryByBusinessUnit(actionList);
            } else {
                PcUiBotQueryAction queryAction = this.mergeQuery(actionList);
                actionList.clear();
                actionList.add(queryAction);
            }
        }
        List processors = this.getDataProcess(tmAction, tmDataFilter, dataSourceName, null, projectData);
        for (PcUiBotTmDataProcess processor : processors) {
            if (!"atmcBatchDataService".equals(processor.getServiceName())) continue;
            processor.setTaskWithBacklogDataList(taskWithBacklogDataList);
            processor.setProjectData(projectData);
            break;
        }
        if ((pcUiBotDataSourceDTO = DataSourceDTOFactory.createDataSource(actionList, (List)processors, (String)dataSourceName, (PcUiBotTmQueryAction)tmAction)) != null) {
            if (tmDataFilter != null) {
                pcUiBotDataSourceDTO.setLimit(tmDataFilter.getLimit());
            }
            if (tmAction.getLimit() != null) {
                pcUiBotDataSourceDTO.setLimit(tmAction.getLimit());
            }
            pcUiBotDataSourceDTO.setNotArray(tmAction.getNotArray());
            if (tmAction.getMetadataFields() != null) {
                pcUiBotDataSourceDTO.setMetadataFields(tmAction.getMetadataFields());
            }
        }
        return pcUiBotDataSourceDTO;
    }

    private void mergeQueryByBusinessUnit(List<PcUiBotQueryAction> actions) {
        actions.forEach(act -> {
            if (act.getBusinessUnit() == null) {
                act.setBusinessUnit(new HashMap());
            }
        });
        ArrayList<PcUiBotQueryAction> list = new ArrayList<PcUiBotQueryAction>();
        Map<Object, List<PcUiBotQueryAction>> group = actions.stream().collect(Collectors.groupingBy(act -> act.getBusinessUnit()));
        for (Map.Entry<Object, List<PcUiBotQueryAction>> groupItem : group.entrySet()) {
            list.add(this.mergeQuery(groupItem.getValue()));
        }
        actions.clear();
        actions.addAll(list);
    }

    private PcUiBotQueryAction mergeQuery(List<PcUiBotQueryAction> actions) {
        if (actions.isEmpty()) {
            return null;
        }
        if (actions.size() == 1) {
            return actions.get(0);
        }
        PcUiBotQueryAction firstAction = actions.remove(0);
        Map firstActionParams = firstAction.getParas();
        for (PcUiBotQueryAction action : actions) {
            if (action.getParas() == null) continue;
            for (Map.Entry requestParamsEntry : action.getParas().entrySet()) {
                String schema = (String)requestParamsEntry.getKey();
                Object fields = requestParamsEntry.getValue();
                if (!firstActionParams.containsKey(schema)) {
                    firstActionParams.put(schema, fields);
                    continue;
                }
                Object oriFieldsObj = firstActionParams.get(schema);
                if (!(oriFieldsObj instanceof List)) continue;
                List oriFields = (List)oriFieldsObj;
                HashSet compareSet = new HashSet();
                if (!(fields instanceof List)) continue;
                List jsonArray = (List)fields;
                compareSet.addAll(oriFields);
                for (Object item : jsonArray) {
                    if (compareSet.contains(item)) continue;
                    oriFields.add(item);
                    compareSet.add(item);
                }
            }
        }
        return firstAction;
    }

    protected PcUiBotDataSourceDTO create(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, DigiwinAtmcProjectData projectData, PcUiBotTmDataFilter tmDataFilter) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tmAction.getName())) {
            dataSourceName = tmAction.getName();
        }
        PcUiBotDataSourceDTO dataSourceDTO = null;
        switch (tmAction.getType()) {
            case "ATMC": 
            case "ATMC_CHANGE": 
            case "ESP": 
            case "TM": 
            case "RAWDATA": 
            case "SD": 
            case "LCDP": {
                PcUiBotQueryAction queryAction = this.queryActionService.createQueryAction(executeContext.getDataStateCode(), tmAction, taskWithBacklogData, projectData, tmDataFilter, dataSourceName, executeContext);
                if (queryAction == null) {
                    return null;
                }
                List processors = this.getDataProcess(tmAction, tmDataFilter, dataSourceName, taskWithBacklogData, projectData);
                dataSourceDTO = DataSourceDTOFactory.create((PcUiBotTmQueryAction)tmAction, (PcUiBotQueryAction)queryAction, (String)dataSourceName, (List)processors, (boolean)true);
                break;
            }
            case "MIX_MERGE": {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u5de6\u8fb9\u662fnull");
                }
                if (CollectionUtils.isEmpty((Collection)tmAction.getRightList())) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u53f3\u8fb9\u662fnull");
                }
                PcUiBotDataSourceDTO left = this.create(executeContext, "", tmAction.getLeft(), taskWithBacklogData, projectData, tmDataFilter);
                ArrayList<PcUiBotDataSourceDTO> rightList = new ArrayList<PcUiBotDataSourceDTO>();
                int index = 0;
                for (PcUiBotTmQueryAction tmQueryAction : tmAction.getRightList()) {
                    PcUiBotDataSourceDTO dataSourceBase = this.create(executeContext, "" + index, tmQueryAction, taskWithBacklogData, projectData, tmDataFilter);
                    rightList.add(dataSourceBase);
                    ++index;
                }
                dataSourceDTO = new PcUiBotDataSourceDTO();
                dataSourceDTO.setType("MIX_MERGE");
                dataSourceDTO.setLeft(left);
                dataSourceDTO.setRightList(rightList);
                dataSourceDTO.setName(dataSourceName);
                dataSourceDTO.setActionId(tmAction.getLeft().getActionId());
                dataSourceDTO.setDataKeys(tmAction.getLeft().getDataKeys());
                dataSourceDTO.setAction(left.getAction());
                List processors = this.getDataProcess(tmAction, tmDataFilter, dataSourceName, taskWithBacklogData, projectData);
                dataSourceDTO.setDataSourceProcessors(processors);
                break;
            }
            case "MIX_LEFT_JOIN": {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u5de6\u8fb9\u662fnull");
                }
                if (CollectionUtils.isEmpty((Collection)tmAction.getRightList())) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u53f3\u8fb9\u662fnull");
                }
                PcUiBotDataSourceDTO left = this.create(executeContext, "", tmAction.getLeft(), taskWithBacklogData, projectData, tmDataFilter);
                ArrayList<PcUiBotDataSourceDTO> rightList = new ArrayList<PcUiBotDataSourceDTO>();
                int index = 0;
                for (PcUiBotTmQueryAction tmQueryAction : tmAction.getRightList()) {
                    PcUiBotDataSourceDTO dataSourceBase = this.create(executeContext, "" + index, tmQueryAction, taskWithBacklogData, projectData, tmDataFilter);
                    rightList.add(dataSourceBase);
                    ++index;
                }
                dataSourceDTO = new PcUiBotDataSourceDTO();
                dataSourceDTO.setType("MIX_LEFT_JOIN");
                dataSourceDTO.setLeft(left);
                dataSourceDTO.setRightList(rightList);
                dataSourceDTO.setName(dataSourceName);
                dataSourceDTO.setActionId(tmAction.getLeft().getActionId());
                dataSourceDTO.setDataKeys(tmAction.getLeft().getDataKeys());
                dataSourceDTO.setAction(left.getAction());
                dataSourceDTO.setOverride(tmAction.getOverride());
                List processors = this.getDataProcess(tmAction, tmDataFilter, dataSourceName, taskWithBacklogData, projectData);
                dataSourceDTO.setDataSourceProcessors(processors);
            }
        }
        if (dataSourceDTO != null) {
            if (tmDataFilter != null) {
                dataSourceDTO.setLimit(tmDataFilter.getLimit());
            }
            if (tmAction.getLimit() != null) {
                dataSourceDTO.setLimit(tmAction.getLimit());
            }
            dataSourceDTO.setNotArray(tmAction.getNotArray());
            if (tmAction.getMetadataFields() != null) {
                dataSourceDTO.setMetadataFields(tmAction.getMetadataFields());
            }
            dataSourceDTO.setTitle(tmAction.getTitle());
        }
        this.addExtendedData(taskWithBacklogData, dataSourceDTO);
        return dataSourceDTO;
    }

    public void addExtendedData(DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotDataSourceDTO dataSourceDTO) {
        if (dataSourceDTO.getExtendedData() == null) {
            dataSourceDTO.setExtendedData(new HashMap());
        }
        if (taskWithBacklogData != null && !CollectionUtils.isEmpty((Collection)taskWithBacklogData.getBacklog())) {
            dataSourceDTO.getExtendedData().put("__workitemSqlId", ((DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0)).getBacklogId());
            dataSourceDTO.getExtendedData().put("__processSerialNumber", taskWithBacklogData.getProcessSerialNumber());
            if (!CollectionUtils.isEmpty((Collection)((DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0)).getWorkitemList())) {
                dataSourceDTO.getExtendedData().put("__workitemId", ((Map)((DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0)).getWorkitemList().get(0)).get("workitemId"));
            }
        }
    }

    protected List<PcUiBotTmDataProcess> getDataProcess(PcUiBotTmQueryAction tmAction, PcUiBotTmDataFilter tmDataFilter, String dataSourceName, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, DigiwinAtmcProjectData projectData) {
        ArrayList<PcUiBotTmDataProcess> processors = new ArrayList<PcUiBotTmDataProcess>();
        if (!CollectionUtils.isEmpty((Collection)tmAction.getDataProcessors())) {
            if (tmDataFilter != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)tmDataFilter.getCode())) {
                for (PcUiBotTmDataProcess dataSourceProcessor : tmAction.getDataProcessors()) {
                    if (CollectionUtils.isEmpty((Collection)dataSourceProcessor.getDataFilterNames()) || !dataSourceProcessor.getDataFilterNames().contains(tmDataFilter.getCode()) || "executeCompleted".equals(dataSourceProcessor.getActivePoint())) continue;
                    processors.add(dataSourceProcessor.clone());
                }
            }
            for (PcUiBotTmDataProcess dataSourceProcessor : tmAction.getDataProcessors()) {
                if (!CollectionUtils.isEmpty((Collection)dataSourceProcessor.getDataFilterNames()) || !CollectionUtils.isEmpty((Collection)dataSourceProcessor.getDataSourceNames()) && !dataSourceProcessor.getDataSourceNames().contains(dataSourceName) || "executeCompleted".equals(dataSourceProcessor.getActivePoint())) continue;
                processors.add(dataSourceProcessor.clone());
            }
        }
        for (PcUiBotTmDataProcess processor : processors) {
            if ("atmcDataService".equals(processor.getServiceName()) || "recommendProcessService".equals(processor.getServiceName())) {
                processor.setTaskWithBacklogData(taskWithBacklogData);
                processor.setProjectData(projectData);
            }
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)"atmcBatchDataService", (CharSequence)processor.getServiceName()) || taskWithBacklogData == null) continue;
            processor.setTaskWithBacklogDataList((List)Lists.newArrayList((Object[])new DigiwinAtmcTaskWithBacklogData[]{taskWithBacklogData}));
            processor.setProjectData(projectData);
        }
        return processors;
    }
}

