/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.DesignerTrigger;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TagMergeService {
    public PcUiBotTagDefinition mergeTagAttributes(PcUiBotMetadataField metadataField) {
        if (metadataField == null) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)metadataField.getTagDefinitions())) {
            return null;
        }
        List tagDefinitions = metadataField.getTagDefinitions();
        PcUiBotTagDefinition tagDefinitionDTO = null;
        for (PcUiBotTagDefinition tagDefinition : tagDefinitions) {
            if (!StringUtils.isNotBlank((CharSequence)tagDefinition.getInterpreterServiceName())) continue;
            tagDefinitionDTO = tagDefinition;
        }
        if (tagDefinitionDTO == null || StringUtils.isBlank((CharSequence)tagDefinitionDTO.getInterpreterServiceName())) {
            return null;
        }
        return tagDefinitionDTO;
    }

    public List<PcUiBotTagDefinition> getInterpreterTags(PcUiBotMetadataField metadataField) {
        if (CollectionUtils.isEmpty((Collection)metadataField.getTagDefinitions())) {
            return new ArrayList<PcUiBotTagDefinition>();
        }
        HashSet<String> codes = new HashSet<String>();
        ArrayList<PcUiBotTagDefinition> result = new ArrayList<PcUiBotTagDefinition>();
        for (PcUiBotTagDefinition tagDefinition : metadataField.getTagDefinitions()) {
            if (!StringUtils.isNotBlank((CharSequence)tagDefinition.getInterpreterServiceName()) || codes.contains(tagDefinition.getCode())) continue;
            codes.add(tagDefinition.getCode());
            result.add(tagDefinition);
        }
        return result;
    }

    public void addTagRules(String path, List<PcUiBotMetadataField> showFields, List<Map<String, Object>> rules) {
        for (PcUiBotMetadataField showField : showFields) {
            String pathName = "";
            pathName = StringUtils.isBlank((CharSequence)path) ? showField.getName() : path + "." + showField.getName();
            if ("object".equals(showField.getDataType())) {
                this.addTagRules(pathName, showField.getSubFields(), rules);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)showField.getTagDefinitions()) || !showField.isCanEdit()) continue;
            for (PcUiBotTagDefinition tagDefinition : showField.getTagDefinitions()) {
                if (tagDefinition.getRuleDefinition() == null || CollectionUtils.isEmpty((Collection)tagDefinition.getRuleDefinition().getRules())) continue;
                for (JSONObject rule : tagDefinition.getRuleDefinition().getRules()) {
                    UiBotRule uiBotRule = (UiBotRule)JsonUtil.objectToJavaObject((Object)rule, UiBotRule.class);
                    uiBotRule.setPath(path);
                    DesignerTrigger trigger = uiBotRule.getTrigger();
                    if (trigger != null) {
                        trigger.setApiUrl("/api/atmc/v1/" + trigger.getApiUrl());
                    }
                    rules.add((Map<String, Object>)rule);
                }
            }
        }
    }
}

