/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAttachmentConfigInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmApproval;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmSequence;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TaskSubmitActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotAttachmentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TmApprovalService {
    @Autowired
    private TaskSubmitActionCreateService submitActionCreateService;
    @Autowired
    private LocaleService localeService;

    public void process(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, PcUiBotTaskPageDefine actionVO) {
        if (executeContext.isShared()) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)executeContext.getTaskWithBacklogDataList())) {
            return;
        }
        if (!actionVO.isDefaultShow()) {
            return;
        }
        if (!Objects.equals(executeContext.getIdentity(), "performer")) {
            return;
        }
        DigiwinAtmcTaskWithBacklogData taskWithBacklogData = executeContext.getTaskWithBacklogData();
        List submits = null;
        if (tmActivity.getApprove() != null) {
            if ("sequence".equals(tmActivity.getApprove().getType()) && tmActivity.getApprove().getSequence() != null) {
                List sequence = tmActivity.getApprove().getSequence();
                if (sequence.size() == 1) {
                    submits = ((PcUiBotTmSequence)tmActivity.getApprove().getSequence().get(0)).getSubmits();
                } else {
                    Iterator iterator = sequence.iterator();
                    while (iterator.hasNext()) {
                        PcUiBotTmSequence tmSequence = (PcUiBotTmSequence)iterator.next();
                        if (!Objects.equals(taskWithBacklogData.getBpmActivityId(), tmSequence.getKey()) && (!taskWithBacklogData.getBpmActivityId().contains("-ADD-") || !taskWithBacklogData.getBpmActivityId().startsWith(tmSequence.getKey()))) continue;
                        submits = tmSequence.getSubmits();
                        break;
                    }
                }
            } else if ("decision".equals(tmActivity.getApprove().getType()) && tmActivity.getPages() != null) {
                submits = tmActivity.getPages().getSubmitActions();
            }
        }
        if (submits == null && tmActivity.getApproves() != null) {
            if (tmActivity.getApproves().size() == 1) {
                submits = ((PcUiBotTmApproval)tmActivity.getApproves().get(0)).getSubmits();
            } else {
                for (PcUiBotTmApproval tmApproval : tmActivity.getApproves()) {
                    if (!Objects.equals(taskWithBacklogData.getBpmActivityId(), tmApproval.getKey()) && (!taskWithBacklogData.getBpmActivityId().contains("-ADD-") || !taskWithBacklogData.getBpmActivityId().startsWith(tmApproval.getKey()))) continue;
                    submits = tmApproval.getSubmits();
                    break;
                }
            }
        }
        if (!CollectionUtils.isEmpty(submits)) {
            PcUiBotAttachmentUtil.appendEffectAfterSubmitAction((PcUiBotExecuteContext)executeContext, (PcUiBotAttachmentConfigInfo)tmActivity.getAttachment(), submits);
            ArrayList<PcUiBotSubmitAction> actionsList = new ArrayList<PcUiBotSubmitAction>();
            for (PcUiBotTmAction tmAction : submits) {
                PcUiBotSubmitAction submitAction = this.submitActionCreateService.create(executeContext, executeContext.getProjectData(), taskWithBacklogData, tmAction);
                if (submitAction == null) continue;
                submitAction.setSubmitType(dataState.getSubmitType());
                if (submitAction.getSubmitType() == null) {
                    if (dataState.getSubmitType() != null) {
                        submitAction.setSubmitType(dataState.getSubmitType());
                    } else {
                        PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                        submitType.setIsBatch(Boolean.valueOf(false));
                        submitType.setSchema(actionVO.getDataSourceSet().getMainDatasource());
                        submitAction.setSubmitType(submitType);
                        dataState.setSubmitType(submitType);
                    }
                }
                this.setApprovalActionStartApproveActivity(submitAction, tmActivity);
                actionsList.add(submitAction);
            }
            if (actionsList.size() > 0) {
                ((PcUiBotSubmitAction)actionsList.get(0)).setDefaultAction(true);
            }
            actionVO.setSubmitActions(actionsList);
            String finishedActionId = ((DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0)).getFinishedActionId();
            if (!StringUtils.isEmpty((Object)finishedActionId)) {
                for (DigiwinAtmcTaskWithBacklogData withBacklogData : executeContext.getTaskWithBacklogDataList()) {
                    if (!StringUtils.isEmpty((Object)((DigiwinAtmcBacklogData)withBacklogData.getBacklog().get(0)).getFinishedActionId())) continue;
                    finishedActionId = null;
                    break;
                }
            }
            if (!StringUtils.isEmpty((Object)finishedActionId)) {
                this.backlogFinishedByApprove(actionVO, submits, finishedActionId);
            }
        }
    }

    public void setApprovalActionStartApproveActivity(PcUiBotSubmitAction submitAction, PcUiBotTmActivity tmActivity) {
        if (("WF".equals(submitAction.getCategory()) || "TaskEngine".equals(submitAction.getCategory())) && "reapprove".equals(submitAction.getServiceId().getName())) {
            ArrayList<String> startApproveActivity = new ArrayList<String>();
            startApproveActivity.add(tmActivity.getActivityId());
            submitAction.setStartApproveActivity(startApproveActivity);
        } else if (("WF".equals(submitAction.getCategory()) || "TaskEngine".equals(submitAction.getCategory())) && "reexecute".equals(submitAction.getServiceId().getName())) {
            submitAction.setStartApproveActivity(tmActivity.getStartApproveActivity());
        }
        if (!CollectionUtils.isEmpty((Collection)submitAction.getAttachActions())) {
            for (PcUiBotSubmitAction attachAction : submitAction.getAttachActions()) {
                this.setApprovalActionStartApproveActivity(attachAction, tmActivity);
            }
        }
    }

    private void backlogFinishedByApprove(PcUiBotTaskPageDefine action, List<PcUiBotTmAction> tmSubmitActions, String finishedActionId) {
        action.setFinished(Boolean.valueOf(true));
        action.setOperations(null);
        action.setSubmitActions(null);
        if (!CollectionUtils.isEmpty(tmSubmitActions)) {
            for (PcUiBotTmAction tmSubmitAction : tmSubmitActions) {
                if (!Objects.equals(tmSubmitAction.getId(), finishedActionId) && !Objects.equals(tmSubmitAction.getActionId(), finishedActionId)) continue;
                if (StringUtils.isEmpty((Object)tmSubmitAction.getReturnText())) {
                    action.setFinishedTitle(tmSubmitAction.getTitle());
                } else {
                    action.setFinishedTitle(tmSubmitAction.getReturnText());
                }
                return;
            }
        }
        String locale = Optional.ofNullable(action.getExecuteContext()).map(PcUiBotExecuteContext::getLocale).orElse("zh_CN");
        if (StringUtils.isEmpty((Object)action.getFinishedTitle())) {
            if (Objects.equals(finishedActionId, "athena_bpm_reassign")) {
                action.setFinishedTitle(this.localeService.getLanguageValue(locale, "\u8f6c\u6d3e"));
            } else if (Objects.equals(finishedActionId, "athena_bpm_cancel")) {
                action.setFinishedTitle(this.localeService.getLanguageValue(locale, "\u64a4\u9500"));
            } else if (Objects.equals(finishedActionId, "uibot_retrive")) {
                action.setFinishedTitle(this.localeService.getLanguageValue(locale, "\u5df2\u64a4\u56de"));
            } else if (Objects.equals(finishedActionId, "uibot_action_id_finished")) {
                action.setFinishedTitle(this.localeService.getLanguageValue(locale, "\u5df2\u7ed3\u675f"));
            }
        }
    }
}

