/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.designer.uibot.support.PcUiBotOpenWindowDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAttachDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotOperationAPIDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotOperationDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotScriptFilterDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationOpenWindowDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationScriptCondition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.DataViewOpenWindowDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ActionDataSourceAnalysisService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.SubmitActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotMessageUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotOperationsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TmPageOperationService {
    @Autowired
    private ActionDataSourceAnalysisService tmDataSourceService;
    @Autowired
    private PcUiBotOpenWindowDefineAnalyzer pcUiBotOpenWindowDefineAnalyzer;
    @Autowired
    private SubmitActionCreateService submitActionCreateService;
    @Autowired
    private DataViewOpenWindowDefineAnalyzer dataViewOpenWindowDefineAnalyzer;
    private static final List<String> OPEN_WINDOW_OPERATE_LIST = Arrays.asList("openwindow", "openChart", "open-task-window", "openpage");
    private static final List<String> OPERATION_TYPE_LIST = Arrays.asList("add-row", "openpage");

    public void createOperations(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> tmOperationList) {
        if (CollectionUtils.isEmpty(tmOperationList)) {
            return;
        }
        tmOperationList.forEach(tmOperationDTO -> TmPageOperationService.handleOperationTypeRelation((PcUiBotTmOperation)tmOperationDTO));
        ArrayList<PcUiBotOperationDTO> operationList = new ArrayList<PcUiBotOperationDTO>();
        for (PcUiBotTmOperation tmOperation : tmOperationList) {
            PcUiBotSubmitAction submitAction;
            PcUiBotOperationDTO operationDTO = new PcUiBotOperationDTO();
            operationList.add(operationDTO);
            operationDTO.setId(tmOperation.getId());
            operationDTO.setTitle(PcUiBotMessageUtils.getMessageByCurrentLanguage((Object)tmOperation.getTitle()));
            operationDTO.setPosition(tmOperation.getPosition());
            operationDTO.setIcon(tmOperation.getIcon());
            operationDTO.setDisplay(tmOperation.getDisplay());
            operationDTO.setCleanFields(tmOperation.getCleanFields());
            operationDTO.setIsMainButton(tmOperation.getIsMainButton());
            PcUiBotOperationsUtil.setCondition((PcUiBotTmOperation)tmOperation, (PcUiBotOperationDTO)operationDTO);
            operationDTO.setDescription(PcUiBotMessageUtils.getMessageByCurrentLanguage((Object)tmOperation.getDescription()));
            operationDTO.setOperate(tmOperation.getOperate());
            operationDTO.setOperateTarget(tmOperation.getOperateTarget());
            operationDTO.setOperateScript(tmOperation.getOperateScript());
            operationDTO.setEditorDefine(tmOperation.getEditorDefine());
            operationDTO.setEditor(tmOperation.getEditor());
            operationDTO.setPageCode(executeContext.getPageCode());
            operationDTO.setTargetDetailField(tmOperation.getTargetDetailField());
            operationDTO.setSequenceField(tmOperation.getSequenceField());
            operationDTO.setSequence(tmOperation.getSequence());
            operationDTO.setType(tmOperation.getType());
            operationDTO.setBackFills(tmOperation.getBackFills());
            operationDTO.setExtendedFields(tmOperation.getExtendedFields());
            operationDTO.setConfirm(tmOperation.getConfirm());
            operationDTO.setApplyAlthoughFinished(tmOperation.getApplyAlthoughFinished());
            operationDTO.setOpenFreedomAddRow(tmOperation.getOpenFreedomAddRow());
            operationDTO.setNavigateTarget(tmOperation.getNavigateTarget());
            operationDTO.setIsToolBar(tmOperation.getIsToolBar());
            operationDTO.setCopyConfigs(tmOperation.getCopyConfigs());
            if (tmOperation.getIsCustomize() != null) {
                operationDTO.setIsCustomize(tmOperation.getIsCustomize());
                if (tmOperation.getIsCustomize().booleanValue()) {
                    operationDTO.setCustomType(tmOperation.getCustomType());
                    operationDTO.setPageCode(null);
                    if (tmOperation.getSchema() != null) {
                        operationDTO.setSchema(tmOperation.getSchema());
                    }
                }
            }
            if (tmOperation.getDisabledSelected() != null) {
                operationDTO.setDisabledSelected(tmOperation.getDisabledSelected());
            }
            if (!CollectionUtils.isEmpty((Collection)tmOperation.getFields())) {
                operationDTO.setFields(tmOperation.getFields());
            }
            if (tmOperation.getEnableReload() != null) {
                operationDTO.setEnableReload(tmOperation.getEnableReload());
            }
            if (tmOperation.getEnableToolShow() != null) {
                operationDTO.setEnableToolShow(tmOperation.getEnableToolShow());
            }
            if (tmOperation.getSubmitAction() != null && null != (submitAction = this.submitActionCreateService.createSubmitAction(tmOperation.getSubmitAction(), executeContext.getTenantId(), executeContext.getBusinessUnit(), executeContext))) {
                if (submitAction.getSubmitType() == null) {
                    submitAction.setSubmitType(tmActivity.getPages().getSubmitType());
                }
                submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create((PcUiBotExecuteContext)executeContext, null));
                operationDTO.setSubmitAction(submitAction);
            }
            PcUiBotAttachDTO attachDTO = new PcUiBotAttachDTO();
            operationDTO.setAttach(attachDTO);
            attachDTO.setTarget(tmOperation.getTarget());
            attachDTO.setMode(tmOperation.getMode());
            attachDTO.setTarget(tmOperation.getTarget());
            if (tmOperation.getAfterFilter() != null) {
                attachDTO.setAfterFilter(tmOperation.getAfterFilter());
            }
            if (!StringUtils.isEmpty((Object)tmOperation.getTagGroup())) {
                attachDTO.setTarget(tmOperation.getTagGroup());
            }
            if (!StringUtils.isEmpty((Object)tmOperation.getRuleScript())) {
                attachDTO.setRuleScript(tmOperation.getRuleScript());
            }
            if (!StringUtils.isEmpty((Object)tmOperation.getRuleMessage())) {
                attachDTO.setRuleMessage(PcUiBotMessageUtils.getMessageByCurrentLanguage((Object)tmOperation.getRuleMessage()));
            }
            attachDTO.setApplyToField(tmOperation.getApplyToField());
            attachDTO.setComparisonField(tmOperation.getComparisonField());
            attachDTO.setExportExcludeFields(tmOperation.getExportExcludeFields());
            if (Objects.isNull(tmActivity)) {
                this.parseOpenWindow(executeContext, Boolean.valueOf(false), tmOperation, operationDTO);
            } else {
                this.parseOpenWindow(executeContext, tmActivity.isFlowEngine(), tmOperation, operationDTO);
            }
            if (Objects.equals(tmOperation.getOperate(), "SELECT-API")) {
                PcUiBotOperationAPIDefineDTO aglieAPIDefineDTO = new PcUiBotOperationAPIDefineDTO();
                operationDTO.setApiDefine(aglieAPIDefineDTO);
                aglieAPIDefineDTO.setApi(tmOperation.getApiDefine().getApi());
                aglieAPIDefineDTO.setDisplay(tmOperation.getApiDefine().getDisplay());
                aglieAPIDefineDTO.setUpdateSchema(tmOperation.getApiDefine().getUpdateSchema());
                PcUiBotDataSourceDTO dataSourceBase = this.tmDataSourceService.analysis(executeContext, "", tmOperation.getApiDefine().getGetDataAction(), new HashMap());
                aglieAPIDefineDTO.setGetDataAction(dataSourceBase);
            }
            if (Objects.equals(tmOperation.getOperate(), "scriptFilter")) {
                PcUiBotScriptFilterDTO scriptFilterDTO = new PcUiBotScriptFilterDTO();
                PcUiBotTmOperationScriptCondition tmOperationScriptCondition = tmOperation.getOperationScriptCondition();
                operationDTO.setScriptCondition(scriptFilterDTO);
                scriptFilterDTO.setDefaultFilter(tmOperationScriptCondition.getDefaultDisplay());
                scriptFilterDTO.setType(tmOperationScriptCondition.getType());
                scriptFilterDTO.setDescription(tmOperation.getDescription());
                scriptFilterDTO.setFilterScript(tmOperationScriptCondition.getScript());
                scriptFilterDTO.setTarget(tmOperationScriptCondition.getTarget());
                scriptFilterDTO.setTitle((Object)tmOperation.getTitle());
            }
            this.parseDrawer(operationDTO, tmOperation);
        }
        pageDefine.setOperations(operationList);
    }

    public void parseOpenWindow(PcUiBotExecuteContext executeContext, Boolean isFlowEngine, PcUiBotTmOperation tmOperation, PcUiBotOperationDTO operationDTO) {
        if (!OPEN_WINDOW_OPERATE_LIST.contains(tmOperation.getOperate())) {
            return;
        }
        boolean isDataView = Optional.of(tmOperation).map(PcUiBotTmOperation::getOpenWindowDefine).map(PcUiBotTmOperationOpenWindowDefine::getAllAction).map(PcUiBotTmQueryAction::getViewCode).map(org.apache.commons.lang3.StringUtils::isNotBlank).orElse(Boolean.FALSE);
        PcUiBotOpenWindowDefineDTO openwindowDefineDTO = isDataView ? this.dataViewOpenWindowDefineAnalyzer.analysis(executeContext, tmOperation, isFlowEngine) : this.pcUiBotOpenWindowDefineAnalyzer.analysis(executeContext, tmOperation, isFlowEngine);
        operationDTO.setOpenWindowDefine(openwindowDefineDTO);
        operationDTO.setOpenWindowConditional(tmOperation.getCondition());
    }

    private void parseDrawer(PcUiBotOperationDTO operation, PcUiBotTmOperation tmOperation) {
        String type = tmOperation.getType();
        if (!"DRAWER".equalsIgnoreCase(type)) {
            return;
        }
        operation.setTabs(tmOperation.getTabs());
        operation.setSwitchData(tmOperation.getSwitchData());
    }

    public static void handleOperationTypeRelation(PcUiBotTmOperation operation) {
        if (BooleanUtils.isTrue((Boolean)operation.getIsCustomize()) || StringUtils.isEmpty((Object)operation.getOperate()) || !OPERATION_TYPE_LIST.contains(operation.getOperate())) {
            return;
        }
        switch (operation.getOperate()) {
            case "openpage": {
                if ("BUTTON_GROUP".equals(operation.getApplyToField())) {
                    if (StringUtils.isEmpty((Object)operation.getType())) {
                        operation.setType("edit");
                        break;
                    }
                    if ("openpage".equals(operation.getType())) {
                        operation.setType("edit");
                        break;
                    }
                    if (!"copy".equals(operation.getType())) break;
                    operation.setType("openpage_copy");
                    break;
                }
                if (!StringUtils.isEmpty((Object)operation.getType())) break;
                operation.setType("add");
                break;
            }
            case "add-row": {
                operation.setType("add");
                break;
            }
        }
    }
}

