/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotCondition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PcUiBotSubmitActionUtil {
    private static final String[] COMPLETED_SUBMIT_ACTION = new String[]{"uibot_task_withdraw", "task-return"};
    private static final Map<String, String> FINISHED_ACTION_ID_TITLE_MAPPING = new HashMap();

    public static boolean isTaskWithdrawAction(PcUiBotTmAction action) {
        if (null == action) {
            return false;
        }
        if ("uibot_task_withdraw".equals(action.getActionId())) {
            return true;
        }
        List attachActions = action.getAttachActions();
        if (!CollectionUtils.isEmpty((Collection)attachActions)) {
            for (PcUiBotTmAction attachAction : attachActions) {
                if (!PcUiBotSubmitActionUtil.isTaskWithdrawAction((PcUiBotTmAction)attachAction)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTaskWithdrawAction(PcUiBotSubmitAction action) {
        if (null == action) {
            return false;
        }
        if ("uibot_task_withdraw".equals(action.getActionId())) {
            return true;
        }
        List attachActions = action.getAttachActions();
        if (!CollectionUtils.isEmpty((Collection)attachActions)) {
            for (PcUiBotSubmitAction attachAction : attachActions) {
                if (!PcUiBotSubmitActionUtil.isTaskWithdrawAction((PcUiBotSubmitAction)attachAction)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<PcUiBotSubmitAction> onlyKeepWithdrawAction(List<PcUiBotSubmitAction> submitActions) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return new ArrayList<PcUiBotSubmitAction>();
        }
        return submitActions.stream().filter(PcUiBotSubmitActionUtil::isTaskWithdrawAction).collect(Collectors.toList());
    }

    public static List<PcUiBotSubmitAction> onlyKeepAction(List<PcUiBotSubmitAction> submitActions) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return new ArrayList<PcUiBotSubmitAction>();
        }
        return submitActions.stream().filter(submitAction -> {
            for (String s : COMPLETED_SUBMIT_ACTION) {
                if (!PcUiBotSubmitActionUtil.isTaskActionByActionId((PcUiBotSubmitAction)submitAction, (String)s)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public static boolean isTaskActionByActionId(PcUiBotSubmitAction action, String actionId) {
        if (null == action) {
            return false;
        }
        if (actionId.equals(action.getActionId())) {
            return true;
        }
        List attachActions = action.getAttachActions();
        if (!CollectionUtils.isEmpty((Collection)attachActions)) {
            for (PcUiBotSubmitAction attachAction : attachActions) {
                if (!PcUiBotSubmitActionUtil.isTaskActionByActionId((PcUiBotSubmitAction)attachAction, (String)actionId)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTaskActionByActionId(PcUiBotTmAction action, String actionId) {
        if (null == action) {
            return false;
        }
        if (actionId.equals(action.getActionId())) {
            return true;
        }
        List attachActions = action.getAttachActions();
        if (!CollectionUtils.isEmpty((Collection)attachActions)) {
            for (PcUiBotTmAction attachAction : attachActions) {
                if (!PcUiBotSubmitActionUtil.isTaskActionByActionId((PcUiBotTmAction)attachAction, (String)actionId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setCondition(PcUiBotTmAction tmAction, PcUiBotSubmitAction submitAction) {
        submitAction.setApplyAlthoughFinished(tmAction.getApplyAlthoughFinished());
        if (StringUtils.isNotEmpty((CharSequence)tmAction.getCondition())) {
            PcUiBotCondition condition = new PcUiBotCondition();
            submitAction.setCondition(condition);
            condition.setScript(tmAction.getCondition());
            condition.setTrigger((List)Lists.newArrayList((Object[])new String[]{"init"}));
            List trigger = tmAction.getTrigger();
            if (!CollectionUtils.isEmpty((Collection)trigger)) {
                trigger.removeIf(StringUtils::isBlank);
            }
            if (!CollectionUtils.isEmpty((Collection)trigger)) {
                condition.setTrigger(trigger);
            }
        }
        submitAction.setHidden((PcUiBotCondition)JsonUtil.objectToJavaObject((Object)tmAction.getHidden(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
    }

    public static boolean isReturnOrTaskWithdrawAction(PcUiBotTmAction action) {
        if (null == action) {
            return false;
        }
        if ("task-return".equals(action.getActionId()) || "uibot_task_withdraw_cross_bk".equals(action.getActionId())) {
            return true;
        }
        List attachActions = action.getAttachActions();
        if (!CollectionUtils.isEmpty((Collection)attachActions)) {
            for (PcUiBotTmAction attachAction : attachActions) {
                if (!PcUiBotSubmitActionUtil.isReturnOrTaskWithdrawAction((PcUiBotTmAction)attachAction)) continue;
                return true;
            }
        }
        return false;
    }

    public static String finishedActionIdToTitle(String finishedActionId) {
        if (StringUtils.isBlank((CharSequence)finishedActionId)) {
            return "";
        }
        for (Map.Entry entry : FINISHED_ACTION_ID_TITLE_MAPPING.entrySet()) {
            if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)finishedActionId)) continue;
            return (String)entry.getValue();
        }
        return "";
    }

    public static String translateFinishedTitle(String finishedTitle) {
        if (StringUtils.isNotBlank((CharSequence)finishedTitle)) {
            return ((LocaleServiceImpl)SpringContextHolder.getBean(LocaleServiceImpl.class)).getLanguageValue(AppRequestContext.getContextEntity().getLocale(), finishedTitle);
        }
        return "";
    }

    public static String translateFinishedActionIdToTitle(String finishedActionId) {
        return PcUiBotSubmitActionUtil.translateFinishedTitle((String)PcUiBotSubmitActionUtil.finishedActionIdToTitle((String)finishedActionId));
    }

    public static boolean hasSubmitTypeBatch(List<PcUiBotSubmitAction> submitActions) {
        return PcUiBotSubmitActionUtil.getFirstBatchSubmitType(submitActions) != null;
    }

    public static PcUiBotSubmitType getFirstBatchSubmitType(List<PcUiBotSubmitAction> submitActions) {
        if (!CollectionUtils.isEmpty(submitActions)) {
            for (PcUiBotSubmitAction submitAction : submitActions) {
                PcUiBotSubmitType submitType = submitAction.getSubmitType();
                if (submitType != null && submitType.getIsBatch().booleanValue()) {
                    return submitType;
                }
                PcUiBotSubmitType b = PcUiBotSubmitActionUtil.getFirstBatchSubmitType((List)submitAction.getAttachActions());
                if (b == null) continue;
                return b;
            }
        }
        return null;
    }

    public static boolean showWhenBacklogFinished(PcUiBotTmAction action) {
        if (null == action) {
            return false;
        }
        return BooleanUtils.isTrue((Boolean)action.getApplyAlthoughFinished());
    }

    static {
        FINISHED_ACTION_ID_TITLE_MAPPING.put("athena_bpm_reassign", "backlog.activity.reassign");
        FINISHED_ACTION_ID_TITLE_MAPPING.put("athena_bpm_cancel", "backlog.activity.cancel");
        FINISHED_ACTION_ID_TITLE_MAPPING.put("uibot_retrive", "uibot.activity.retrieved");
        FINISHED_ACTION_ID_TITLE_MAPPING.put("uibot_action_id_finished", "uibot_action_id_finished");
        FINISHED_ACTION_ID_TITLE_MAPPING.put("athena_overdue_task_terminate", "athena.overdue.task.terminate");
        FINISHED_ACTION_ID_TITLE_MAPPING.put("uibot_action_id_handover", "backlog.activity.handover");
        FINISHED_ACTION_ID_TITLE_MAPPING.put("athena_bpm_reassign_repeat", "backlog.activity.reassign.repeat");
        FINISHED_ACTION_ID_TITLE_MAPPING.put("athena_bpm_handover_repeat", "backlog.activity.handover.repeat");
    }
}

