/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotShowMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotMetadataTagResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotObjectRenderTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotThemeMapTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagConstant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PcUiBotTagUtil {
    private static final Logger log = LoggerFactory.getLogger(PcUiBotTagUtil.class);
    public static final List<String> RENDER_OBJECT_TAG_CODE = Arrays.asList("BUSINESS_TREE", "BUSINESS_ATTACHMENT_FILE");

    private PcUiBotTagUtil() {
    }

    public static boolean containsTagDef(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        return null != PcUiBotTagUtil.getTagDefByCode(tagDefList, (String)tagCode);
    }

    public static boolean existBusinessTag(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        return PcUiBotTagUtil.getBusinessTagDefByCode(tagDefList, (String)tagCode) != null;
    }

    public static PcUiBotTagDefinition getBusinessTagDefByCode(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        if (CollectionUtils.isEmpty(tagDefList) || StringUtils.isBlank((CharSequence)tagCode)) {
            return null;
        }
        for (PcUiBotTagDefinition tagDef : tagDefList) {
            if (null == tagDef || !tagCode.equals(tagDef.getCode()) || !"BUSINESS".equals(tagDef.getCategory())) continue;
            return tagDef;
        }
        return null;
    }

    public static boolean existTag(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        return PcUiBotTagUtil.getTagDefByCode(tagDefList, (String)tagCode) != null;
    }

    public static PcUiBotTagDefinition getTagDefByCode(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(tagDefList) || StringUtils.isBlank((CharSequence)tagCode)) {
            return null;
        }
        for (PcUiBotTagDefinition tagDef : tagDefList) {
            if (null == tagDef || !tagCode.equals(tagDef.getCode())) continue;
            return tagDef;
        }
        return null;
    }

    public static PcUiBotTagDefinition getTagDefByStartCode(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(tagDefList) || StringUtils.isBlank((CharSequence)tagCode)) {
            return null;
        }
        for (PcUiBotTagDefinition tagDef : tagDefList) {
            if (null == tagDef || tagDef.getCode() == null || !tagDef.getCode().startsWith(tagCode)) continue;
            return tagDef;
        }
        return null;
    }

    public static boolean renderObjectMetadataField(PcUiBotMetadataField metadataField) {
        if (!"object".equals(metadataField.getDataType())) {
            return false;
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)metadataField.getTagDefinitions())) {
            return false;
        }
        for (PcUiBotTagDefinition tagDef : metadataField.getTagDefinitions()) {
            if (!(tagDef instanceof PcUiBotObjectRenderTagDefinition)) continue;
            if (metadataField.getTagDefinitions().size() > 1) {
                PcUiBotTagUtil.removeTag((PcUiBotMetadataField)metadataField, (String)"BUSINESS_OBJECT_RENDER");
            }
            return true;
        }
        for (String tagCode : RENDER_OBJECT_TAG_CODE) {
            if (!PcUiBotTagUtil.containsTagDef((List)metadataField.getTagDefinitions(), (String)tagCode)) continue;
            return true;
        }
        return false;
    }

    public static void removeTag(PcUiBotMetadataField metadataField, String tagCategory, String tmTagCode) {
        List tagDefinitions = metadataField.getTagDefinitions();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)tagDefinitions)) {
            Iterator tagDefinitionIterator = tagDefinitions.iterator();
            while (tagDefinitionIterator.hasNext()) {
                PcUiBotTagDefinition tagDefinition = (PcUiBotTagDefinition)tagDefinitionIterator.next();
                if (tagDefinition.getThemeMapTag() == null || !tagCategory.equals(tagDefinition.getCategory()) || !tmTagCode.equals(tagDefinition.getThemeMapTag().getCode())) continue;
                tagDefinitionIterator.remove();
            }
        }
    }

    public static void removeTag(PcUiBotMetadataField metadataField, String tagCode) {
        List tagDefinitions = metadataField.getTagDefinitions();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)tagDefinitions)) {
            Iterator tagDefinitionIterator = tagDefinitions.iterator();
            while (tagDefinitionIterator.hasNext()) {
                PcUiBotTagDefinition tagDefinition = (PcUiBotTagDefinition)tagDefinitionIterator.next();
                if (!tagCode.equals(tagDefinition.getCode())) continue;
                tagDefinitionIterator.remove();
            }
        }
    }

    public static boolean tagInputEnableTrim(PcUiBotMetadataField metadataField) {
        return true;
    }

    public static void handleOnlyHasNavigateTagScene(PcUiBotShowMetadata showMetadata) {
        List showFields = showMetadata.getShowFields();
        for (PcUiBotMetadataField showField : showFields) {
            if (!"object".equals(showField.getDataType())) continue;
            PcUiBotTagUtil.doHandleOnlyHasNavigateTagScene((List)showField.getSubFields());
        }
    }

    private static void doHandleOnlyHasNavigateTagScene(List<PcUiBotMetadataField> showFields) {
        for (PcUiBotMetadataField metadataField : showFields) {
            if (!"object".equals(metadataField.getDataType()) || !com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)metadataField.getSubFields())) continue;
            PcUiBotTagUtil.doHandleOnlyHasNavigateTagScene((List)metadataField.getSubFields());
        }
        for (PcUiBotMetadataField showField : showFields) {
            List tagList = showField.getTagDefinitions();
            if (!PcUiBotTagUtil.onlyHasNavigateTag((List)tagList)) continue;
            tagList.add(0, PcUiBotDefaultTagUtils.createDataTypeDefinition((PcUiBotMetadataField)showField, null));
        }
    }

    public static boolean onlyHasNavigateTag(List<PcUiBotTagDefinition> tagList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(tagList)) {
            return false;
        }
        for (PcUiBotTagDefinition pcUiBotTagDefinition : tagList) {
        }
        return true;
    }

    public static PcUiBotTagDefinition buildGroupTagDefinition(String suffixValue) {
        PcUiBotTagDefinition tagDefinition = PcUiBotTagUtil.buildTagDefinition((String)"GROUP", (String)suffixValue);
        PcUiBotThemeMapTag themeMapTag = tagDefinition.getThemeMapTag();
        themeMapTag.setCode(themeMapTag.getCategory());
        return tagDefinition;
    }

    public static PcUiBotTagDefinition buildTagDefinition(String tagCode) {
        return PcUiBotTagUtil.buildTagDefinition((String)tagCode, (String)"CUSTOM");
    }

    public static PcUiBotTagDefinition buildTagDefinition(String tagCode, String suffixValue) {
        String category = tagCode.concat("_").concat(suffixValue);
        PcUiBotThemeMapTag themeMapTag = new PcUiBotThemeMapTag();
        themeMapTag.setCode(tagCode);
        themeMapTag.setName("TEST-TAG");
        themeMapTag.setCategory(category);
        themeMapTag.setUiBotCode(tagCode);
        PcUiBotTagDefinition tag = new PcUiBotTagDefinition();
        tag.setCode(tagCode);
        tag.setCategory(category);
        tag.setCustomize(Boolean.FALSE);
        tag.setThemeMapTag(themeMapTag);
        return tag;
    }

    public static PcUiBotThemeMapTag getComponentTagOrNull(List<PcUiBotThemeMapTag> tagList) {
        return tagList.stream().filter(ele -> PcUiBotTagConstant.ComponentTagCodeEnum.isContain((String)ele.getCode())).findFirst().orElse(PcUiBotThemeMapTag.empty());
    }

    public static void cleanRelationId(List<PcUiBotMetadataTagResult> metadataMetadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataMetadataTagResults) {
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)metadataTagResult.getTags())) continue;
            for (PcUiBotThemeMapTag tag : metadataTagResult.getTags()) {
                if (!StringUtils.contains((CharSequence)tag.getCode(), (CharSequence)"__")) continue;
                tag.setCode(StringUtils.substringAfterLast((String)tag.getCode(), (String)"__"));
            }
        }
    }
}

