/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.sysmanage.cache;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/cache"})
public class CacheController {
    private static final Logger logger = LoggerFactory.getLogger(CacheController.class);
    @Resource(name="systemCacheManager")
    private CaffeineCacheManager systemCacheManager;
    @Resource(name="projectCacheManager")
    private CaffeineCacheManager projectCacheManager;

    private CaffeineCacheManager getTargetCacheManagerByCategory(String category) {
        if ("system".equals(category)) {
            return this.systemCacheManager;
        }
        if ("proxy".equals(category)) {
            return this.projectCacheManager;
        }
        return null;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public ApiResponse<Collection<String>> getCacheCategories() {
        ArrayList<String> cacheCategories = new ArrayList<String>();
        cacheCategories.add("system");
        cacheCategories.add("proxy");
        return ApiResponse.buildOK().setData(cacheCategories);
    }

    @RequestMapping(value={"/{category}"}, method={RequestMethod.GET})
    public ApiResponse<Collection<String>> getCachesNamesByCategory(@PathVariable(value="category", required=true) String category) {
        CaffeineCacheManager cacheManager = this.getTargetCacheManagerByCategory(category);
        Collection<Object> cacheNames = null != cacheManager ? cacheManager.getCacheNames() : Collections.emptyList();
        return ApiResponse.buildOK().setData(cacheNames);
    }

    @RequestMapping(value={"/{category}/{cacheName}"}, method={RequestMethod.GET})
    public ApiResponse<Object> getCacheDetailByCategoryAndCacheName(@PathVariable(value="category", required=true) String category, @PathVariable(value="cacheName", required=true) String cacheName) {
        CaffeineCacheManager cacheManager = this.getTargetCacheManagerByCategory(category);
        Cache cache = null;
        if (null != cacheManager) {
            cache = cacheManager.getCache(cacheName);
        }
        if (null != cache) {
            if (cache instanceof CaffeineCache) {
                CaffeineCache loadingCache = (CaffeineCache)cache;
                return ApiResponse.buildOK().setData((Object)loadingCache.getNativeCache().asMap());
            }
            return ApiResponse.buildOK().setData((Object)cache);
        }
        return ApiResponse.buildError((String)("There is no cache named " + cacheName));
    }

    @RequestMapping(value={"/stats/{category}/{cacheName}"}, method={RequestMethod.GET})
    public ApiResponse<Boolean> getCacheStatsByCategoryAndCacheName(@PathVariable(value="category", required=true) String category, @PathVariable(value="cacheName", required=true) String cacheName) {
        CaffeineCacheManager cacheManager = this.getTargetCacheManagerByCategory(category);
        Cache cache = null;
        if (null != cacheManager) {
            cache = cacheManager.getCache(cacheName);
        }
        if (null != cache) {
            if (cache instanceof CaffeineCache) {
                CaffeineCache loadingCache = (CaffeineCache)cache;
                return ApiResponse.buildOK().setData((Object)loadingCache.getNativeCache().stats().toString());
            }
            return ApiResponse.buildOK().setData((Object)cache);
        }
        return ApiResponse.buildError((String)("There is no cache named " + cacheName));
    }

    @RequestMapping(value={"/invalidate/{category}/{cacheName}"}, method={RequestMethod.POST})
    public ApiResponse<Boolean> invalidateCache(@PathVariable(value="category", required=true) String category, @PathVariable(value="cacheName", required=true) String cacheName) {
        CaffeineCacheManager cacheManager = this.getTargetCacheManagerByCategory(category);
        Cache cache = null;
        if (null != cacheManager) {
            cache = cacheManager.getCache(cacheName);
        }
        boolean invalidateOperateResult = false;
        if (null != cache) {
            invalidateOperateResult = cache.invalidate();
            return ApiResponse.buildOK().setData((Object)invalidateOperateResult);
        }
        return ApiResponse.buildError((String)("There is no cache named " + cacheName));
    }
}

