/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskListStrategy;
import com.digiwin.mobile.mobileuibot.environment.EnvironmentService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.UserTaskFilter;
import com.digiwin.mobile.mobileuibot.mysql.model.UserTaskFilterRequest;
import com.digiwin.mobile.mobileuibot.mysql.service.UserTaskFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.task.model.ApiRequestTaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.SaveCardSwitchRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveCommonrFilterRecordRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveGroupRecordRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveModuleInfoRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveSeniorFilterRecordRequest;
import com.digiwin.mobile.mobileuibot.task.model.TaskContentResult;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/task"})
public class TaskController {
    private static final Logger log = LoggerFactory.getLogger(TaskController.class);
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private UserTaskFilterService userTaskFilterService;
    @Autowired
    private UiBotModelBuildMyTaskListStrategy uiBotModelBuildMyTaskListStrategy;
    @Autowired
    private LocaleService localeService;

    @RequestMapping(value={"/card/content"}, method={RequestMethod.GET})
    public ApiResponse<TaskContentResult> getTaskCardContent(@RequestParam(name="dataId") String dataId, @RequestParam(name="iamUserToken") String iamUserToken, @RequestParam(name="tenantId") String tenantId, @RequestParam(name="locale") String locale, @RequestParam(name="tmCategory") String tmCategory, @RequestParam(name="tmPattern") String tmPattern, @RequestParam(name="type") String type, @RequestParam(name="tmTaskId") String tmTaskId, @RequestParam(name="tmActivityId") String tmActivityId, @RequestParam(name="proxyToken") String proxyToken) {
        TaskContentResult result = this.taskService.getTaskContentResult(dataId, iamUserToken, tenantId, locale, tmCategory, tmPattern, type, tmTaskId, tmActivityId, proxyToken);
        if (null == result) {
            return ApiResponse.buildError();
        }
        return ApiResponse.buildOK().setData((Object)result);
    }

    @PostMapping(value={"/search"})
    public ApiResponse<Map> taskSearch(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String locale = (String)params.get("locale");
        String tenantId = (String)params.get("tenantId");
        String queryParam = (String)params.get("queryParam");
        String clientId = (String)params.get("clientId");
        String userId = (String)params.get("userId");
        boolean isNotNeedSaveCondition = MapUtils.getBooleanValue((Map)params, (Object)"isNotNeedSaveCondition");
        UserTaskFilter userTaskFilter = new UserTaskFilter();
        userTaskFilter.setTenantId(tenantId);
        userTaskFilter.setUserId(userId);
        if (!isNotNeedSaveCondition) {
            this.userTaskFilterService.insertUserTaskFilterByQueryParam(userTaskFilter, queryParam);
        }
        Set ids = this.digiwinAtmcProxyService.taskSearch(queryParam, iamUserToken, tenantId, locale, clientId);
        HashMap<String, Set> map = new HashMap<String, Set>(1);
        map.put("idList", ids);
        return ApiResponse.buildOK().setData(map);
    }

    @RequestMapping(value={"/save/filterIds"}, method={RequestMethod.POST})
    public ApiResponse<Boolean> saveFilterIds(@RequestBody UserTaskFilterRequest userTaskFilterRequest) throws IOException {
        UserTaskFilter userTaskFilter = new UserTaskFilter();
        BeanUtils.copyProperties((Object)userTaskFilterRequest, (Object)userTaskFilter);
        List filterIds = userTaskFilterRequest.getFilterIds();
        if (CollectionUtils.isEmpty((Collection)filterIds)) {
            return ApiResponse.buildOK().setData((Object)this.userTaskFilterService.insertUserTaskFilterByFilterIds(userTaskFilter, ""));
        }
        StringBuffer filterId = new StringBuffer();
        for (int i = 0; i < filterIds.size(); ++i) {
            filterId.append((String)filterIds.get(i));
            if (i == filterIds.size() - 1) continue;
            filterId.append(";");
        }
        return ApiResponse.buildOK().setData((Object)this.userTaskFilterService.insertUserTaskFilterByFilterIds(userTaskFilter, filterId.toString()));
    }

    @RequestMapping(value={"/detailBacklog"}, method={RequestMethod.POST})
    public ApiResponse<MobileComponent> taskDetailBacklog(@RequestBody ApiRequestTaskDetail apiRequest) {
        TodoList result = new TodoList().setTodoList(new ArrayList()).setEnableMqtt(Boolean.valueOf(false));
        try {
            this.uiBotModelBuildMyTaskListStrategy.paddingMobileTaskListForm((ApiRequest)apiRequest, apiRequest.getMyBacklogs(), result);
            Map appConfig = this.environmentService.getAppConfig();
            boolean enableMqtt = false;
            if (Boolean.TRUE.equals(appConfig.get("enableMqtt"))) {
                enableMqtt = "true".equalsIgnoreCase(AppContext.getApiUrlSetting().getEnableMqtt());
            }
            result.setEnableMqtt(Boolean.valueOf(enableMqtt));
        }
        catch (Exception e) {
            log.error("ProxyController[taskDetailBacklog] get data error:{}", (Throwable)e);
        }
        return ApiResponse.buildOK().setData((Object)result);
    }

    @PostMapping(value={"/care"})
    public ApiResponse<Action> care(@RequestBody ApiRequest apiRequest) {
        Boolean isSuccess = this.taskService.taskImportance(apiRequest, Boolean.valueOf(true));
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "\u8bbe\u7f6e\u7279\u522b\u5173\u6ce8" + (BooleanUtils.isTrue((Boolean)isSuccess) ? "\u6210\u529f" : "\u5931\u8d25");
        action.setToastMsg(this.localeService.getLanguageValue(apiRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData((Object)action);
    }

    @PostMapping(value={"/uncare"})
    public ApiResponse<Action> uncare(@RequestBody ApiRequest apiRequest) {
        Boolean isSuccess = this.taskService.taskImportance(apiRequest, Boolean.valueOf(false));
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "\u53d6\u6d88\u7279\u522b\u5173\u6ce8" + (BooleanUtils.isTrue((Boolean)isSuccess) ? "\u6210\u529f" : "\u5931\u8d25");
        action.setToastMsg(this.localeService.getLanguageValue(apiRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData((Object)action);
    }

    @PostMapping(value={"/cancelPinning"})
    public ApiResponse<Action> cancelPinning(@RequestBody ApiRequest apiRequest) {
        Boolean isSuccess = this.taskService.cancelPinning(apiRequest);
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "\u53d6\u6d88\u67e5\u770b" + (BooleanUtils.isTrue((Boolean)isSuccess) ? "\u6210\u529f" : "\u5931\u8d25");
        action.setToastMsg(this.localeService.getLanguageValue(apiRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData((Object)action);
    }

    @PostMapping(value={"/saveSwitchGroupRecord"})
    public ApiResponse<Action> saveSwitchGroupRecord(@RequestBody SaveGroupRecordRequest apiRequest) {
        Boolean isSuccess = this.taskService.saveSwitchGroupRecord(apiRequest);
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "\u4fdd\u5b58" + (BooleanUtils.isTrue((Boolean)isSuccess) ? "\u6210\u529f" : "\u5931\u8d25");
        action.setToastMsg(this.localeService.getLanguageValue(apiRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData((Object)action);
    }

    @PostMapping(value={"/saveModuleInfo"})
    public ApiResponse<Action> saveModuleInfo(@RequestBody SaveModuleInfoRequest apiRequest) {
        Boolean isSuccess = this.taskService.saveModuleInfo(apiRequest);
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "\u4fdd\u5b58" + (BooleanUtils.isTrue((Boolean)isSuccess) ? "\u6210\u529f" : "\u5931\u8d25");
        action.setToastMsg(this.localeService.getLanguageValue(apiRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData((Object)action);
    }

    @PostMapping(value={"/saveCardSwitch"})
    public ApiResponse<Action> saveCardSwitch(@RequestBody SaveCardSwitchRequest apiRequest) {
        Boolean isSuccess = this.taskService.saveCardSwitch(apiRequest);
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "\u4fdd\u5b58" + (BooleanUtils.isTrue((Boolean)isSuccess) ? "\u6210\u529f" : "\u5931\u8d25");
        action.setToastMsg(this.localeService.getLanguageValue(apiRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData((Object)action);
    }

    @PostMapping(value={"/saveCommonFilterRecord"})
    public ApiResponse<Action> saveSeniorFilterRecord(@RequestBody SaveCommonrFilterRecordRequest apiRequest) {
        Boolean isSuccess = this.taskService.saveCommonFilterRecord(apiRequest);
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "\u4fdd\u5b58" + (BooleanUtils.isTrue((Boolean)isSuccess) ? "\u6210\u529f" : "\u5931\u8d25");
        action.setToastMsg(this.localeService.getLanguageValue(apiRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData((Object)action);
    }

    @PostMapping(value={"/saveSeniorFilterRecord"})
    public ApiResponse<Action> saveSeniorFilterRecord(@RequestBody SaveSeniorFilterRecordRequest apiRequest) {
        Boolean isSuccess = this.taskService.saveSeniorFilterRecord(apiRequest);
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "\u4fdd\u5b58" + (BooleanUtils.isTrue((Boolean)isSuccess) ? "\u6210\u529f" : "\u5931\u8d25");
        action.setToastMsg(this.localeService.getLanguageValue(apiRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData((Object)action);
    }
}

