/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabBuilder;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOne;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOneBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizApproval;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="taskDetailBuildBizApprovalStrategy")
public class TaskDetailBuildBizApprovalStrategy
implements TaskDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildBizApprovalStrategy.class);
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;
    @Autowired
    private CardOneBizApprovalBuilder cardOneBizApprovalBuilder;
    @Autowired
    private BizApprovalTabBuilder bizApprovalTabBuilder;
    @Autowired
    private BottomButtonBizApprovalBuilder bottomButtonBizApprovalBuilder;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private LocaleService localeService;

    public String getTaskDetailType() {
        return "BUSINESS_APPROVAL";
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        UiBotModel pageModel = pageSetting.getPageModel();
        TaskDetailBizApproval taskDetailBizApproval = new TaskDetailBizApproval();
        for (UiBotLayout layout : pageModel.getLayout()) {
            String layoutType;
            switch (layoutType = layout.getType()) {
                case "TITLE_BODY": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)ModuleUtils.buildTitle((UiBotModel)pcUiBotModel, (Map)pcUiBotModel.getPageData(), (DigiwinAtmcBacklogDetail)((DigiwinAtmcBacklogDetail)args[0]), (ApiRequest)apiRequest, (Boolean)true, (Boolean)true));
                    break;
                }
                case "PAGE_DESC": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)this.pageDescBuilderFactory.get("BUSINESS_APPROVAL").build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, args));
                    break;
                }
                case "CARD_ONE": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)this.cardOneBizApprovalBuilder.build(apiRequest, pageSetting, pcUiBotModel, CardOne.class, args));
                    break;
                }
                case "TABS": {
                    BizApprovalTabList tabs = this.bizApprovalTabBuilder.build(apiRequest, pageSetting, pcUiBotModel, BizApprovalTabList.class, new Object[0]);
                    tabs.forEach(tab -> tab.setMScrollMode(CustomTabScrollModeEnum.NO_SCROLL.getMode()));
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)tabs);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)this.bottomButtonBizApprovalBuilder.build(apiRequest, pageSetting, pcUiBotModel, BottomButtonList.class, args));
                    break;
                }
            }
        }
        return taskDetailBizApproval;
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        if (Arrays.asList("manual_DTD_AssignmentApproval4", "PWD_AbnormalApproval").contains(Optional.ofNullable(pcUiBotModel.getExecuteContext()).map(r -> r.getString("tmActivityId")).orElse(""))) {
            UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
            UiBotModel empty = UiBotModel.createEmptyComponent((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "\u6b64\u4f5c\u4e1a\u672a\u914d\u7f6e\u79fb\u52a8\u7aef\u754c\u9762\uff0c\u6682\u4e0d\u652f\u6301\u67e5\u770b\n\u8bf7\u524d\u5f80Web\u7aef\u67e5\u9605\u5904\u7406"), (boolean)false, null);
            uiBotModel.getLayout().addAll(empty.getLayout());
            uiBotModel.getPageData().putAll((Map)empty.getPageData());
            return uiBotModel;
        }
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetail, Boolean.valueOf(true));
        return uiBotModel;
    }
}

