/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgressList;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildApcAbnormalClosureStrategy")
public class UiBotModelBuildApcAbnormalClosureStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildApcAbnormalClosureStrategy.class);
    private static final String PROGRESS_LIST_SCHEMA = "wo_op_report_abnormal";
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc Abnormal Closeure Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        boolean isTeamTask = BooleanUtils.isTrue((Boolean)apiRawData.getBoolean("isTeamTask"));
        if (StringUtils.hasLength((String)digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)locale);
        }
        if (pcUiBotModel.getPageData().get((Object)"uiBot__APPROVAL_DESCRIPTION") == null) {
            return UiBotModel.emptyUibotModel((String)locale);
        }
        UiBotLayout uiBotLayout = UiBotModel.getCustomUibotLayout((List)pcUiBotModel.getLayout(), (String)"apc_abnormal_closecase-task-detail-waitting");
        List actions = uiBotLayout.getActions();
        List datas = (List)pcUiBotModel.getPageData().get((Object)PROGRESS_LIST_SCHEMA);
        Map data = new HashMap(16);
        Map<String, String> oneceData = new HashMap(16);
        if (!CollectionUtils.isEmpty((Collection)datas)) {
            data = (Map)datas.get(datas.size() - 1);
            oneceData = (Map)datas.get(0);
            EocPersonInfo onecePersonInfo = this.digiwinEocProxyService.getEocPersonInfo((String)oneceData.get("reporter_no"), iamUserToken, 2);
            oneceData.put("reporter_no", onecePersonInfo.getEocId());
            oneceData.put("reporter_name", onecePersonInfo.getName());
        }
        EocPersonInfo eocPersonInfo = this.digiwinEocProxyService.getEocPersonInfo(apiRequest.getUserId(), iamUserToken, 2);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.createApc((DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (UiBotModel)pcUiBotModel, (String)locale);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomGroup.class);
                    pageData.put((Object)schema, (Object)CustomGroup.createDetail((LocaleService)this.localeService, (ApiRequest)apiRequest, data, (CustomGroup)customGroup));
                    break;
                }
                case "TASK_PROGRESS_LIST": {
                    TaskProgressList progressList = (TaskProgressList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), TaskProgressList.class);
                    String title = this.localeService.getLanguageValue(locale, progressList.getTitle());
                    progressList.setTitle(title);
                    List taskProgressList = progressList.getTaskProgressList();
                    List reportAbnormalList = (List)pcUiBotModel.getPageData().get((Object)PROGRESS_LIST_SCHEMA);
                    if (CollectionUtils.isEmpty((Collection)reportAbnormalList)) {
                        layout.setType("CUSTOM_GROUP");
                        pageData.put((Object)schema, (Object)CustomGroup.createEmptyGroup((String)locale, (String)title));
                        break;
                    }
                    int i = 0;
                    for (Map reportAbnormal : reportAbnormalList) {
                        taskProgressList.add(TaskProgress.createApcProgress((int)i, (Map)reportAbnormal, (String)locale, (LocaleService)this.localeService, (String)iamUserToken, (DigiwinEocProxyService)this.digiwinEocProxyService));
                        ++i;
                    }
                    pageData.put((Object)schema, (Object)progressList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = null;
                    if (BooleanUtils.isFalse((Boolean)isTeamTask)) {
                        bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                        Map rawData = this.buildData(oneceData, eocPersonInfo);
                        rawData.put("process_person_no", apiRequest.getUserId());
                        String dataKey = (String)data.get("__DATA_KEY");
                        Map<String, String> finalOneceData = oneceData;
                        bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                            Action action;
                            String jumpPageTitle;
                            HashMap<String, Object> buttonRawData = new HashMap<String, Object>(6);
                            String buttonName = bottomButtonDigiwinAthena.getName();
                            if (StringUtils.hasLength((String)buttonName)) {
                                bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                            }
                            if (StringUtils.hasLength((String)(jumpPageTitle = (action = bottomButtonDigiwinAthena.getAction()).getJumpPageTitle()))) {
                                action.setJumpPageTitle(this.localeService.getLanguageValue(locale, jumpPageTitle));
                            }
                            if (bottomButtonDigiwinAthena.getType() == 2) {
                                buttonRawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_RETURN_BOTTOM.toString());
                                if (!CollectionUtils.isEmpty((Collection)actions)) {
                                    buttonRawData.put("action", actions.stream().filter(action1 -> action1.getDefaultAction()).findFirst().get());
                                    HashMap returnData = new HashMap(16);
                                    returnData.putAll(rawData);
                                    buttonRawData.put("oneData", finalOneceData);
                                    buttonRawData.put("data", returnData);
                                } else {
                                    buttonRawData.put("data", rawData);
                                }
                            } else {
                                buttonRawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_PROGRESS_BOTTOM.toString());
                                if (!CollectionUtils.isEmpty((Collection)actions)) {
                                    buttonRawData.put("action", actions.stream().filter(action1 -> action1.getDefaultAction() == false).findFirst().get());
                                }
                                buttonRawData.put("data", rawData);
                            }
                            buttonRawData.put("dataKey", dataKey);
                            buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                            action.setRawData(buttonRawData);
                            ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButtonDigiwinAthena, (String)"");
                        });
                    }
                    pageData.put((Object)schema, bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private Map<String, Object> buildData(Map<String, Object> data, EocPersonInfo eocPersonInfo) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(13);
        returnData.put("eoc_company_id", data.get("eoc_company_id"));
        returnData.put("eoc_site_id", data.get("eoc_site_id"));
        returnData.put("op_no", data.get("op_no"));
        returnData.put("wo_op_abnormal_report_id", data.get("wo_op_abnormal_report_id"));
        returnData.put("wo_no", data.get("wo_no"));
        returnData.put("plot_no", data.get("plot_no"));
        returnData.put("op_seq", data.get("op_seq"));
        returnData.put("op_name", data.get("op_name"));
        returnData.put("abnormal_doc_no", data.get("abnormal_doc_no"));
        returnData.put("reporter_no", eocPersonInfo.getEocId());
        returnData.put("reporter_name", eocPersonInfo.getName());
        return returnData;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

