/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildOutSourceWorkReportCompleteDetailStrategy")
public class TaskDetailBuildOutSourceWorkReportCompleteDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildOutSourceWorkReportCompleteDetailStrategy.class);
    private static final String OUTSOURCINGTYPE = "1";
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build OutSource Work Complete Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        Map outsourcingReportData = (Map)apiRawData.get((Object)"outsourcing_report");
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "FIELD": {
                    Field field = this.buildField(outsourcingReportData, schema, layout.getLabel(), locale);
                    pageData.put((Object)schema, (Object)field);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    this.buildButton(locale, schema, pageData);
                }
            }
        }
        return uiBotModel;
    }

    private Field buildField(Map<String, Object> outsourcingReportData, String schema, String label, String locale) {
        String resourceCode;
        String schemaData;
        String string = schemaData = outsourcingReportData.get(schema) != null ? String.valueOf(outsourcingReportData.get(schema)) : "";
        if ("item_no".equalsIgnoreCase(schema)) {
            schemaData = outsourcingReportData.get("item_no") + " " + outsourcingReportData.get("item_name") + " " + outsourcingReportData.get("item_spec");
        }
        if ("outsourcing_type".equalsIgnoreCase(schema)) {
            schemaData = OUTSOURCINGTYPE.equals(outsourcingReportData.get(schema)) ? this.localeService.getLanguageValue(locale, "\u5382\u5185\u5916\u534f") : this.localeService.getLanguageValue(locale, "\u5382\u5916\u5916\u534f");
        }
        if ("operation_section_name".equalsIgnoreCase(schema)) {
            schemaData = String.valueOf(outsourcingReportData.get("operation_section_name"));
        }
        if (("plan_delivery_date".equalsIgnoreCase(schema) || "report_date".equalsIgnoreCase(schema)) && StringUtils.isNotEmpty((CharSequence)schemaData)) {
            schemaData = schemaData.substring(0, 10);
        }
        if ("overrun_rate".equalsIgnoreCase(schema) && StringUtils.isNotEmpty((CharSequence)schemaData)) {
            schemaData = schemaData + "%";
        }
        String name = this.localeService.getLanguageValue(locale, label);
        Field field = Field.createLabelLeftValueRightField((String)name, (String)schemaData);
        String string2 = resourceCode = outsourcingReportData.get("resource_code") != null ? String.valueOf(outsourcingReportData.get("resource_code")) : "";
        if ("work_procedure_type".equalsIgnoreCase(schema) && StringUtils.isEmpty((CharSequence)resourceCode)) {
            field.setHidden(Boolean.valueOf(true));
        }
        return field;
    }

    private void buildButton(String locale, String schema, UiBotPageData pageData) {
        ArrayList<BottomButtonDigiwinAthena> buttonList = new ArrayList<BottomButtonDigiwinAthena>(1);
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton((String)locale);
        buttonList.add(cancelButton);
        pageData.put((Object)schema, buttonList);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

