/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.mergeworkhour;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildApcMergeWorkHourQuantityConfirmStrategy")
public class TaskDetailBuildApcMergeWorkHourQuantityConfirmStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildApcMergeWorkHourQuantityConfirmStrategy.class);
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Merge Work Hour Quantity Confirm Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        List remainingQtyList = this.getRemainingQty(apiRequest);
        Integer remainingQty = apiRawData.getInteger("remaining_qty");
        Object dataValue = apiRawData.get((Object)"dataValue");
        stopWatch.start("Build taskDetailBuildApcWorkHourQuantityConfirmStrategy Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case "SINGLE_SELECT_LIST": {
                    SingleSelectList singleSelectList = new SingleSelectList();
                    List optionList = remainingQtyList.stream().map(item -> {
                        boolean selected = Objects.equals(item, remainingQty);
                        if (dataValue != null) {
                            Integer dataVal = Double.valueOf((String)dataValue).intValue();
                            selected = dataVal.equals(item);
                        }
                        return SingleSelectListOption.create((int)item, (Boolean)selected, (Boolean)false, (int)0, (String)"", (String)"");
                    }).collect(Collectors.toList());
                    singleSelectList.setTitle(this.localeService.getLanguageValue(locale, "\u8c03\u6574\u62a5\u5de5\u6570\u91cf"));
                    singleSelectList.setStyle(Integer.valueOf(1));
                    singleSelectList.setStyle(SingleSelectListTypeEnum.PROGRESS_REPORT.getValue());
                    singleSelectList.setOptionList(optionList);
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)singleSelectList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    ArrayList<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<BottomButtonDigiwinAthena>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton((String)locale));
                    BottomButtonDigiwinAthena confirmeButton = new BottomButtonDigiwinAthena();
                    confirmeButton.setName(this.localeService.getLanguageValue(locale, "\u786e\u5b9a"));
                    Action buttonAction = new Action();
                    buttonAction.setType(ActionTypeEnum.RETURN_AND_UPDATE.getValue());
                    buttonAction.setDataId(apiRequest.getDataId());
                    confirmeButton.setAction(buttonAction);
                    confirmeButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                    bottomButtonList.add(confirmeButton);
                    uiBotModel.getPageData().put((Object)fieldSchema, bottomButtonList);
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private List<Integer> getRemainingQty(ApiRequest apiRequest) {
        ApiRawData apiRawData = apiRequest.getRawData();
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO = new PcUiBotDataSourceDTO();
        pcUiBotDataSourceDTO.setType("ESP");
        pcUiBotDataSourceDTO.setActionId("esp_wo.op.report.qty.info.get");
        PcUiBotQueryAction pcUiBotQueryAction = new PcUiBotQueryAction();
        pcUiBotQueryAction.setTitle("\u6570\u91cf");
        pcUiBotQueryAction.setActionId("esp_wo.op.report.qty.info.get");
        pcUiBotQueryAction.setCategory("ESP");
        PcUiBotActionServiceId pcUiBotActionServiceId = new PcUiBotActionServiceId();
        pcUiBotActionServiceId.setName("wo.op.report.qty.info.get");
        pcUiBotActionServiceId.setHostAcct("athena");
        pcUiBotQueryAction.setServiceId(pcUiBotActionServiceId);
        HashMap<String, Object> woOpReportDataMap = new HashMap<String, Object>();
        woOpReportDataMap.put("eoc_company_id", apiRawData.get((Object)"eoc_company_id"));
        woOpReportDataMap.put("eoc_site_id", apiRawData.get((Object)"eoc_site_id"));
        woOpReportDataMap.put("eoc_region_id", apiRawData.get((Object)"eoc_region_id"));
        woOpReportDataMap.put("wo_no", apiRawData.get((Object)"wo_no"));
        woOpReportDataMap.put("plot_no", apiRawData.get((Object)"plot_no"));
        woOpReportDataMap.put("op_seq", apiRawData.get((Object)"op_seq"));
        woOpReportDataMap.put("remaining_qty", apiRawData.get((Object)"remaining_qty"));
        woOpReportDataMap.put("plan_source", apiRawData.get((Object)"plan_source"));
        woOpReportDataMap.put("report_qty", apiRawData.get((Object)"report_qty"));
        woOpReportDataMap.put("category", "5");
        HashMap<String, Object> paras = new HashMap<String, Object>(2);
        paras.put("report_order_control", true);
        paras.put("wo_op_report_data", Collections.singletonList(woOpReportDataMap));
        pcUiBotQueryAction.setParas(paras);
        HashMap<String, String> businessUnitMap = new HashMap<String, String>(1);
        businessUnitMap.put("eoc_company_id", apiRawData.getString("eoc_company_id"));
        businessUnitMap.put("eoc_site_id", apiRawData.getString("eoc_site_id"));
        pcUiBotQueryAction.setBusinessUnit(businessUnitMap);
        pcUiBotDataSourceDTO.setAction(pcUiBotQueryAction);
        ArrayList<PcUiBotDataSourceDTO> dataSourceList = new ArrayList<PcUiBotDataSourceDTO>();
        dataSourceList.add(pcUiBotDataSourceDTO);
        HashMap<String, ArrayList<PcUiBotDataSourceDTO>> dataSourceListMap = new HashMap<String, ArrayList<PcUiBotDataSourceDTO>>(1);
        dataSourceListMap.put("dataSourceList", dataSourceList);
        HashMap paramMap = new HashMap(2);
        paramMap.put("dataSourceSet", dataSourceListMap);
        paramMap.put("executeContext", Collections.emptyMap());
        paramMap.put("parameter", paras);
        UiBotModel uiBotModel = this.digiwinPcUiBotProxyService.actionShow(apiRequest.getLocale(), apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString(paramMap));
        if (CollectionUtils.isEmpty((Collection)uiBotModel.getLayout()) || CollectionUtils.isEmpty((Map)uiBotModel.getPageData())) {
            return Collections.emptyList();
        }
        List woOpReportDataList = (List)MapUtil.getOrDefault((Map)uiBotModel.getPageData(), (String)((UiBotLayout)uiBotModel.getLayout().get(0)).getSchema(), Collections.emptyList());
        if (CollectionUtils.isEmpty((Collection)woOpReportDataList)) {
            return Collections.emptyList();
        }
        return woOpReportDataList.stream().map(item -> MapUtils.getInteger((Map)item, (Object)"report_qty")).collect(Collectors.toList());
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

