/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.snm;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkBarcodeData;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkBarcodeDataResponse;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailCustom;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildBizProcessStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="taskDetailBuildSnmCheckoutStrategy")
public class TaskDetailBuildSnmCheckoutStrategy
implements TaskDetailBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(TaskDetailBuildSnmCheckoutStrategy.class);
    @Autowired
    private TaskDetailBuildBizProcessStrategy taskDetailBuildBizProcessStrategy;
    @Autowired
    private ZhilinkService zhilinkService;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    public String getTaskDetailType() {
        return "factory_task_userProject_snmFactoryTask";
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetail, Boolean.valueOf(true));
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        String bizDataSchema;
        UiBotPageData uiBotPageData = pcUiBotModel.getPageData();
        Object bizDataRaw = uiBotPageData.get((Object)(bizDataSchema = pcUiBotModel.searchBizDataSchema()));
        if (bizDataRaw instanceof List) {
            List bizData = (List)bizDataRaw;
            if (bizData.isEmpty()) {
                log.error("bizData is empty, return EMPTY one. Build process stopped...");
                return TaskDetailCustom.createEmpty();
            }
            ZhilinkBarcodeDataResponse barcodeDataResponse = this.zhilinkService.getCheckoutBarcodeTaskDetail(apiRequest, pcUiBotModel, (Map)bizData.get(0));
            if (bizData.size() != barcodeDataResponse.getBarcodeData().size()) {
                log.error("bizData size NOT equals the one of barcodeDataResponse, return EMPTY one. Build process aborted...");
                return TaskDetailCustom.createEmpty();
            }
            List barcodeDataList = barcodeDataResponse.getBarcodeData();
            Map<String, List<ZhilinkBarcodeData>> groupedBarcodeDataList = barcodeDataList.stream().collect(Collectors.groupingBy(e -> this.generateZhilinkBarcodeDataGroupKey(e)));
            Map<String, Long> groupedSumCollect = barcodeDataList.stream().collect(Collectors.groupingBy(e -> this.generateZhilinkBarcodeDataGroupKey(e), Collectors.summingLong(ZhilinkBarcodeData::getQty)));
            ArrayList<Object> finalBarcodeDataList = new ArrayList<Object>();
            for (String groupKey : groupedBarcodeDataList.keySet()) {
                Long qtySum = groupedSumCollect.get(groupKey);
                List<ZhilinkBarcodeData> groupedDataList = groupedBarcodeDataList.get(groupKey);
                if (groupedDataList.isEmpty()) continue;
                ZhilinkBarcodeData tempData = groupedDataList.get(0);
                tempData.setQty(qtySum);
                finalBarcodeDataList.add(JsonUtil.objectToJavaObject((Object)tempData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            }
            String dataSchema = pcUiBotModel.searchBizDataSchema();
            pcUiBotModel.getPageData().put((Object)dataSchema, finalBarcodeDataList);
            return this.taskDetailBuildBizProcessStrategy.build(apiRequest, pageSetting, pcUiBotModel, args);
        }
        log.error("bizData isn't instanceof list, return EMPTY one. Build process aborted...");
        return TaskDetailCustom.createEmpty();
    }

    private String generateZhilinkBarcodeDataGroupKey(ZhilinkBarcodeData zhilinkBarcodeData) {
        return zhilinkBarcodeData.getSnStorageSpacesNo() + "#" + zhilinkBarcodeData.getItemNo();
    }
}

