/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="taskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy")
public class TaskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Tbds production progress record modify material");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        Map data = (Map)rawData.get("data");
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "INPUT_NUMERIC": {
                    if ("total_qty".equalsIgnoreCase(schema)) {
                        Object totalQty = null;
                        if (data.get(schema) instanceof Integer) {
                            totalQty = Integer.parseInt(String.valueOf(MapUtil.getOrDefault((Map)data, (String)schema, (Object)0)));
                        }
                        if (data.get(schema) instanceof Double) {
                            totalQty = MapUtil.getOrDefault((Map)data, (String)schema, (Object)0.0);
                        }
                        String totalQtyStr = ModuleUtils.dealValue((Object)totalQty, (String)locale, (LocaleService)this.localeService);
                        InputNumeric inputNumeric = InputNumeric.create((Integer)99999999, (Integer)2, (String)totalQtyStr, (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)InputNumericTypeEnum.INTEGER.getValue(), (Boolean)true, (String)"");
                        inputNumeric.setRequired(Boolean.valueOf(false));
                        inputNumeric.setEnable(Boolean.valueOf(false));
                        pageData.put((Object)schema, (Object)inputNumeric);
                    }
                    if (!"component_qty".equalsIgnoreCase(schema)) break;
                    Object componentQty = null;
                    if (data.get(schema) instanceof Integer) {
                        componentQty = Integer.parseInt(String.valueOf(MapUtil.getOrDefault((Map)data, (String)schema, (Object)0)));
                    }
                    if (data.get(schema) instanceof Double) {
                        componentQty = MapUtil.getOrDefault((Map)data, (String)schema, (Object)0.0);
                    }
                    String componentQtyStr = ModuleUtils.dealValue((Object)componentQty, (String)locale, (LocaleService)this.localeService);
                    pageData.put((Object)schema, (Object)InputNumeric.create((Integer)99999999, (Integer)6, (String)componentQtyStr, (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)InputNumericTypeEnum.INTEGER.getValue(), (Boolean)true, (String)""));
                    break;
                }
                case "WINDOW_SINGLE_SELECT": {
                    HashMap<String, Object> selectRawData = new HashMap<String, Object>(2);
                    selectRawData.put("isTbds", true);
                    selectRawData.put("type", layout.getSchema());
                    pageData.put((Object)schema, (Object)InputWindowSingleSelect.create((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)schema, (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list"), (String)locale, selectRawData, (String)((String)data.get("unit_no")), (String)((String)data.get(schema)), (RelationRule)new RelationRule(), new HashMap(0)));
                    break;
                }
                case "INPUT_MULTI": {
                    String lotNo = (String)MapUtil.getOrDefault((Map)data, (String)"lot_no", (Object)"");
                    InputMultiText inputMultiText = InputMultiText.create((String)layout.getSchema(), (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)lotNo, (Boolean)true, (Boolean)false, (Boolean)false, (String)locale, (Integer)100);
                    pageData.put((Object)schema, (Object)inputMultiText);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomGroup.class);
                    customGroup.setName(this.localeService.getLanguageValue(locale, customGroup.getName()));
                    List parameterDatas = (List)data.get(schema);
                    if (CollectionUtils.isEmpty((Collection)parameterDatas)) {
                        pageData.remove((Object)schema);
                        break;
                    }
                    pageData.put((Object)schema, (Object)customGroup.buildTbdsParams(customGroup, parameterDatas, locale));
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), Card.class);
                    if ("trial_op_report_item".equalsIgnoreCase(schema)) {
                        Card.create((Card)card, (Map)data, (String)locale, (LocaleService)this.localeService, (Boolean)true);
                    }
                    pageData.put((Object)schema, (Object)card);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(arg_0 -> this.lambda$doActually$0(locale, (Map)rawData, apiRequest, arg_0));
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        uiBotModel.setCustomGroup();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    private /* synthetic */ void lambda$doActually$0(String locale, Map rawData, ApiRequest apiRequest, BottomButtonDigiwinAthena bottomButtonDigiwinAthena) {
        String buttonName = bottomButtonDigiwinAthena.getName();
        if (StringUtils.hasLength((String)buttonName)) {
            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(locale, buttonName));
        }
        if (bottomButtonDigiwinAthena.getIsCheckButton().booleanValue()) {
            Action action = bottomButtonDigiwinAthena.getAction();
            rawData.put("biz_id", "TBDS");
            rawData.put("pageId", apiRequest.getPageId());
            rawData.put("refreshPageId", apiRequest.getRefreshPageId());
            action.setRawData((Object)rawData);
        }
    }
}

