/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.user;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.BaseRequest;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAccountRegisterResponse;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.user.enums.IdentityCodeAcceptTypeEnum;
import com.digiwin.mobile.mobileuibot.user.enums.VerificationTypeEnum;
import com.digiwin.mobile.mobileuibot.user.request.AccountExistCheckReq;
import com.digiwin.mobile.mobileuibot.user.request.CheckVerificationCodeReq;
import com.digiwin.mobile.mobileuibot.user.request.DoubleCheckUpdateReq;
import com.digiwin.mobile.mobileuibot.user.request.PasswordUpdateReq;
import com.digiwin.mobile.mobileuibot.user.request.VerificationCodeReq;
import com.digiwin.mobile.mobileuibot.user.service.UserService;
import com.digiwin.mobile.mobileuibot.user.utils.EmailValidator;
import com.digiwin.mobile.mobileuibot.user.utils.PhoneValidator;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value={"/info"})
    public ApiResponse<DigiwinIamUserInfo> queryUserInfo(@RequestBody BaseRequest request) {
        return ApiResponse.buildOK((Object)this.digiwinIamProxyService.queryUserInfo(request.getIamUserToken(), request.getUserId()));
    }

    @PostMapping(value={"/doubleCheck/update"})
    public ApiResponse<Boolean> doubleCheckUpdate(@RequestBody DoubleCheckUpdateReq request) {
        if (BooleanUtils.isTrue((Boolean)request.getDoubleCheck()) && IdentityCodeAcceptTypeEnum.notExist((String)request.getIdentityCodeAcceptType())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "identityCodeAcceptType\u5b57\u6bb5\u503c\u4e0d\u5408\u6cd5"));
        }
        DigiwinIamUserInfo user = this.digiwinIamProxyService.queryUserInfo(request.getIamUserToken(), request.getUserId());
        if (user == null) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        if (BooleanUtils.isTrue((Boolean)request.getDoubleCheck())) {
            if (IdentityCodeAcceptTypeEnum.EMAIL.getValue().equals(request.getIdentityCodeAcceptType())) {
                if (StringUtils.isBlank((CharSequence)user.getEmail())) {
                    return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u5f53\u524d\u8d26\u53f7\u5c1a\u672a\u7ed1\u5b9a\u90ae\u7bb1\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9a8c\u8bc1\u65b9\u5f0f"));
                }
            } else if (IdentityCodeAcceptTypeEnum.MOBILE.getValue().equals(request.getIdentityCodeAcceptType())) {
                if (StringUtils.isBlank((CharSequence)user.getTelephone())) {
                    return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u5f53\u524d\u8d26\u53f7\u5c1a\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9a8c\u8bc1\u65b9\u5f0f"));
                }
            } else {
                return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "identityCodeAcceptType\u5b57\u6bb5\u503c\u4e0d\u5408\u6cd5"));
            }
        }
        this.userService.doubleCheckUpdate(request, user);
        return ApiResponse.buildOK();
    }

    @PostMapping(value={"/account/exist"})
    public ApiResponse<DigiwinIamAccountRegisterResponse> accountExistCheck(@Valid @RequestBody AccountExistCheckReq request) {
        if (VerificationTypeEnum.EMAIL.getValue().equals(request.getType())) {
            if (!EmailValidator.isValidBasic((String)request.getAccount())) {
                return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
        } else if (VerificationTypeEnum.MOBILEPHONE.getValue().equals(request.getType()) && !PhoneValidator.validatePhoneByRegion((String)request.getAccount())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        return ApiResponse.buildOK((Object)this.userService.accountExistCheck(request));
    }

    @PostMapping(value={"/verificationCode"})
    public ApiResponse<Boolean> verificationCode(@Valid @RequestBody VerificationCodeReq request) {
        if (VerificationTypeEnum.EMAIL.getValue().equals(request.getType())) {
            if (!EmailValidator.isValidBasic((String)request.getAccount())) {
                return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
        } else if (VerificationTypeEnum.MOBILEPHONE.getValue().equals(request.getType()) && !PhoneValidator.validatePhoneByRegion((String)request.getAccount())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        this.userService.verificationCode(request);
        return ApiResponse.buildOK();
    }

    @PostMapping(value={"/checkVerificationCode/renew"})
    public ApiResponse<Map<String, Object>> checkVerificationCodeAndRenew(@Valid @RequestBody CheckVerificationCodeReq request) {
        if (!EmailValidator.isValidBasic((String)request.getAccount()) && !PhoneValidator.validatePhoneByRegion((String)request.getAccount())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u624b\u673a\u53f7\u6216\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", this.userService.checkVerificationCodeAndRenew(request));
        return ApiResponse.buildOK(map);
    }

    @PostMapping(value={"/password/update"})
    public ApiResponse<Boolean> passwordUpdate(@Valid @RequestBody PasswordUpdateReq request) {
        if (!EmailValidator.isValidBasic((String)request.getAccount()) && !PhoneValidator.validatePhoneByRegion((String)request.getAccount())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u624b\u673a\u53f7\u6216\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        this.userService.passwordUpdate(request);
        return ApiResponse.buildOK();
    }
}

