/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.user.utils;

import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmailValidator {
    private static final String BASIC_EMAIL_REGEX = "^[a-zA-Z0-9_!#$%&'*+/=?`{|}~^-]+(?:\\.[a-zA-Z0-9_!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,}$";
    private static final String STRICT_EMAIL_REGEX = "^(?!.*\\.{2})[a-zA-Z0-9]+[a-zA-Z0-9._!#$%&'*+/=?`{|}~^-]*[a-zA-Z0-9]+@(?!.*\\.{2})[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z]{2,}$";

    private EmailValidator() {
        throw new IllegalStateException("\u5de5\u5177\u7c7b\u65e0\u9700\u5b9e\u4f8b\u5316");
    }

    public static boolean isValidBasic(String email) {
        if (email == null || email.trim().isEmpty()) {
            return false;
        }
        return Pattern.matches("^[a-zA-Z0-9_!#$%&'*+/=?`{|}~^-]+(?:\\.[a-zA-Z0-9_!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,}$", email);
    }

    public static boolean isValidStrict(String email) {
        if (email == null || email.trim().isEmpty()) {
            return false;
        }
        return Pattern.matches("^(?!.*\\.{2})[a-zA-Z0-9]+[a-zA-Z0-9._!#$%&'*+/=?`{|}~^-]*[a-zA-Z0-9]+@(?!.*\\.{2})[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z]{2,}$", email);
    }

    public static void main(String[] args) {
        String[] testEmails = new String[]{"user@example.com", "first.last@sub.domain.co.uk", "john.doe123@mail-server.com", "user+tag@example.com", "invalid.email@", "no@tld.", "@domain.com", "user@.com", "user@inval..com", "spaces are@invalid.com", "john.doe@gmail.com", "test@mycompany.com"};
        System.out.println("=== \u57fa\u672c\u90ae\u7bb1\u9a8c\u8bc1 ===");
        for (String email : testEmails) {
            System.out.printf("%-30s -> %s%n", email, EmailValidator.isValidBasic((String)email) ? "\u6709\u6548" : "\u65e0\u6548");
        }
        System.out.println("\n=== \u4e25\u683c\u90ae\u7bb1\u9a8c\u8bc1 ===");
        for (String email : testEmails) {
            System.out.printf("%-30s -> %s%n", email, EmailValidator.isValidStrict((String)email) ? "\u6709\u6548" : "\u65e0\u6548");
        }
    }
}

