/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db2.AppConfig;
import com.digiwin.mobile.mobileuibot.versionManage.VersionManageApplicationService;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigUpdateRequest;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v2/version/manage/application"})
public class VersionManageApplicationController {
    private static final Logger log = LoggerFactory.getLogger(VersionManageApplicationController.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private VersionManageApplicationService versionManageApplicationService;

    @PostMapping(value={"/list"})
    public ApiResponse<List<AppConfig>> list(@RequestBody AppConfigPageRequest request) {
        return ApiResponse.buildOK((Object)this.versionManageApplicationService.list(request));
    }

    @PostMapping(value={"/list/page"})
    public ApiResponse<PageResult<AppConfig>> listPage(@RequestBody AppConfigPageRequest pageRequest) {
        return ApiResponse.buildOK((Object)this.versionManageApplicationService.listPage(pageRequest));
    }

    @GetMapping(value={"/select/{id}"})
    public ApiResponse<AppConfig> selectById(@PathVariable(value="id") Long id) {
        if (null == id) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        AppConfig appConfig = this.versionManageApplicationService.selectById(id);
        if (null == appConfig) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return ApiResponse.buildOK((Object)appConfig);
    }

    @PostMapping(value={"/add"})
    public ApiResponse<Boolean> add(@Valid @RequestBody AppConfigAddRequest addRequest) {
        return this.versionManageApplicationService.add(addRequest);
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Boolean> update(@Valid @RequestBody AppConfigUpdateRequest updateRequest) {
        return this.versionManageApplicationService.update(updateRequest);
    }

    @GetMapping(value={"/delete/{id}"})
    public ApiResponse<AppConfig> deleteById(@PathVariable(value="id") Long id) {
        if (null == id) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        AppConfig appConfig = this.versionManageApplicationService.selectById(id);
        if (null == appConfig) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        this.versionManageApplicationService.deleteById(id);
        return ApiResponse.buildOK((Object)appConfig);
    }

    @GetMapping(value={"/update/{appId}/{id}"})
    public ApiResponse<Boolean> updateAppId(@PathVariable(value="id") Long id, @PathVariable(value="appId") String appId, @RequestParam(value="wordOfCommand") String wordOfCommand) {
        if (!"\u771f\u561f\u5047\u561f".equals(wordOfCommand)) {
            return ApiResponse.buildError((String)"\u53e3\u4ee4\u9519\u8bef");
        }
        if (null == id) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("appid\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        AppConfig appConfig = this.versionManageApplicationService.selectById(id);
        if (null == appConfig) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        this.versionManageApplicationService.updateAppId(id, appId);
        return ApiResponse.buildOK();
    }
}

