/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.config.mysql.Db2Transactional;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db2.AppConfig;
import com.digiwin.mobile.mobileuibot.versionManage.VersionManageApplicationService;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConfigService;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionManageApplicationServiceImpl
implements VersionManageApplicationService {
    @Autowired
    private AppConfigService appConfigService;
    @Autowired
    private LocaleService localeService;

    public List<AppConfig> list(AppConfigPageRequest request) {
        return this.appConfigService.list(request);
    }

    public PageResult<AppConfig> listPage(AppConfigPageRequest pageRequest) {
        return PageResult.createPageResult((Page)this.appConfigService.listPage(pageRequest));
    }

    public AppConfig selectById(Long id) {
        return this.appConfigService.selectById(id);
    }

    private String generateAppId() {
        String appId = null;
        for (int i = 0; i < 50 && this.appConfigService.getByCode(appId = "appid_" + UUID.randomUUID().toString().replace("-", "")) != null; ++i) {
            appId = null;
        }
        return appId;
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> add(AppConfigAddRequest addRequest) {
        String appId = this.generateAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u751f\u6210appId\u5931\u8d25"));
        }
        this.appConfigService.add(appId, addRequest);
        return ApiResponse.buildOK();
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> update(AppConfigUpdateRequest updateRequest) {
        AppConfig appConfig = this.appConfigService.selectByIdAndCode(updateRequest.getId(), updateRequest.getCode());
        if (appConfig == null) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5e94\u7528\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        this.appConfigService.update(appConfig, updateRequest);
        return ApiResponse.buildOK();
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public void deleteById(Long id) {
        this.appConfigService.deleteById(id);
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public void updateAppId(Long id, String appId) {
        this.appConfigService.updateAppId(id, appId);
    }
}

