/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.dto.AppClientPageDto;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.versionManage.VersionManageClientService;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppClientResponse;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppUpdateResponse;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v2/version/manage/client"})
public class VersionManageClientController {
    private static final Logger log = LoggerFactory.getLogger(VersionManageClientController.class);
    @Autowired
    private VersionManageClientService versionManageClientService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value={"/list/page"})
    public ApiResponse<PageResult<AppClientResponse>> listPage(@RequestBody AppClientPageDto pageRequest) {
        return ApiResponse.buildOK((Object)this.versionManageClientService.listPage(pageRequest));
    }

    @GetMapping(value={"/select/{id}"})
    public ApiResponse<AppClientResponse> selectById(@PathVariable(value="id") Long id) {
        if (null == id) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        AppClientResponse appClientResponse = this.versionManageClientService.queryById(id);
        if (null == appClientResponse) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return ApiResponse.buildOK((Object)appClientResponse);
    }

    @PostMapping(value={"/add"})
    public ApiResponse<Boolean> add(@RequestBody AppClientAddRequest addRequest) {
        if (null == addRequest.getAppId() || StringUtils.isBlank((CharSequence)addRequest.getVersion())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5e94\u7528\u3001\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return this.versionManageClientService.add(addRequest);
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Boolean> update(@RequestBody AppClientUpdateRequest updateRequest) {
        if (null == updateRequest.getId()) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        if (null == updateRequest.getAppId() || StringUtils.isBlank((CharSequence)updateRequest.getVersion())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5e94\u7528\u3001\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return this.versionManageClientService.update(updateRequest);
    }

    @PostMapping(value={"/release"})
    public ApiResponse<Boolean> release(@Valid @RequestBody AppClientUpdateRequest releaseRequest) {
        return this.versionManageClientService.release(releaseRequest);
    }

    @GetMapping(value={"/unrelease/{id}"})
    public ApiResponse<Boolean> unrelease(@PathVariable(value="id") Long id) {
        if (null == id) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return this.versionManageClientService.unrelease(id);
    }

    @GetMapping(value={"/delete/{id}"})
    public ApiResponse<Boolean> deleteById(@PathVariable(value="id") Long id) {
        if (null == id) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return this.versionManageClientService.deleteById(id);
    }

    @GetMapping(value={"/update/history/{id}"})
    public ApiResponse<List<AppUpdateResponse>> updateHistoryById(@PathVariable(value="id") Long id) {
        if (null == id) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return this.versionManageClientService.updateHistoryById(id);
    }
}

