/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.config.mysql.Db2Transactional;
import com.digiwin.mobile.mobileuibot.dto.AppClientPageDto;
import com.digiwin.mobile.mobileuibot.dto.AppClientVo;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db2.AppClient;
import com.digiwin.mobile.mobileuibot.model.db2.AppConfig;
import com.digiwin.mobile.mobileuibot.versionManage.VersionManageClientService;
import com.digiwin.mobile.mobileuibot.versionManage.enums.BrandEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.PublishEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.ReleaseTypeEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.StrongUpdateEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateRangeEnum;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppClientResponse;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppUpdateResponse;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppClientService;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConfigService;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppUpdateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionManageClientServiceImpl
implements VersionManageClientService {
    @Autowired
    private AppConfigService appConfigService;
    @Autowired
    private AppClientService appClientService;
    @Autowired
    private AppUpdateService appUpdateService;
    @Autowired
    private LocaleService localeService;

    public PageResult<AppClientResponse> listPage(AppClientPageDto pageRequest) {
        Page page = this.appClientService.listPage(pageRequest);
        PageResult pageResult = new PageResult();
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            pageResult.setData(new ArrayList());
        } else {
            pageResult.setData(page.getRecords().stream().map(AppClientResponse::convert).collect(Collectors.toList()));
        }
        pageResult.setTotal(Long.valueOf(page.getTotal()));
        pageResult.setPageNum(Long.valueOf(page.getCurrent()));
        pageResult.setPageSize(Long.valueOf(page.getSize()));
        pageResult.setTotalPage(Long.valueOf(page.getPages()));
        return pageResult;
    }

    public AppClientResponse queryById(Long id) {
        AppClientVo appClientVo = this.appClientService.queryById(id);
        if (appClientVo == null) {
            return null;
        }
        return AppClientResponse.convert((AppClientVo)appClientVo);
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> add(AppClientAddRequest addRequest) {
        AppConfig appConfig = this.appConfigService.selectById(addRequest.getAppId());
        if (appConfig == null) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5e94\u7528\u4e0d\u5b58\u5728"));
        }
        AppClient appClient = this.appClientService.add(addRequest);
        this.appUpdateService.add(appClient.getId(), addRequest);
        return ApiResponse.buildOK((Object)true);
    }

    private ApiResponse<Boolean> verifyAddParam(AppClientAddRequest request) {
        AppConfig appConfig = this.appConfigService.selectById(request.getAppId());
        if (appConfig == null) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5e94\u7528\u4e0d\u5b58\u5728"));
        }
        if ("ios".equalsIgnoreCase(appConfig.getOsType())) {
            if (StringUtils.isBlank((CharSequence)request.getUrl32())) {
                return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        } else if (StringUtils.isBlank((CharSequence)request.getUrl32()) || StringUtils.isBlank((CharSequence)request.getMd532()) || StringUtils.isBlank((CharSequence)request.getUrl64()) || StringUtils.isBlank((CharSequence)request.getMd564())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("32\u4f4d\u4e0b\u8f7d\u5730\u5740\u300164\u4f4d\u4e0b\u8f7d\u5730\u5740\u300132\u4f4dMD5\u300164\u4f4dMD5\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getBrand())) {
            for (String brand : request.getBrand()) {
                if (BrandEnum.exist((String)brand) != null) continue;
                return ApiResponse.buildError((String)(brand + this.localeService.getLanguageValue(" \u5546\u5e97\u4e0d\u5728\u9009\u62e9\u8303\u56f4\u5185")));
            }
        }
        if (ReleaseTypeEnum.FULL.getValue().equals(request.getReleaseType()) && StrongUpdateEnum.YES.getValue().equals(request.getStrongUpdate()) && UpdateRangeEnum.getByValue((Integer)request.getUpdateRange()) == null) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5f3a\u5236\u7248\u66f4\u8303\u56f4\u503c\u4e0d\u5408\u6cd5"));
        }
        if (ReleaseTypeEnum.PARTIAL.getValue().equals(request.getReleaseType()) && CollectionUtils.isEmpty((Collection)request.getConditions())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5c40\u90e8\u53d1\u5e03\u4e0b\uff0c\u4e0b\u53d1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (ReleaseTypeEnum.FULL.getValue().equals(request.getReleaseType()) && StrongUpdateEnum.YES.getValue().equals(request.getStrongUpdate()) && UpdateRangeEnum.PARTIAL.getValue().equals(request.getUpdateRange()) && CollectionUtils.isEmpty((Collection)request.getConditions())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5168\u91cf\u53d1\u5e03\u4e0b\u5f3a\u5236\u66f4\u65b0\u5c40\u90e8\u8303\u56f4\u4e0b\uff0c\u4e0b\u53d1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return ApiResponse.buildOK((Object)true);
    }

    private ApiResponse<Boolean> verifyUpdateParam(AppClient appClient, AppClientUpdateRequest updateRequest) {
        if (null == appClient) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        if (PublishEnum.PUBLISH.getValue().equals(appClient.getPublish()) || PublishEnum.CANCELPUBLISH.getValue().equals(appClient.getPublish())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u7248\u672c\u5df2\u53d1\u5e03\u6216\u53d6\u6d88\u53d1\u5e03\uff0c\u4e0d\u80fd\u4fee\u6539"));
        }
        if (!appClient.getAppId().equals(updateRequest.getAppId()) || !appClient.getVersion().equals(updateRequest.getVersion())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5e94\u7528\u4e0e\u7248\u672c\u53f7\u4e0d\u80fd\u4fee\u6539"));
        }
        return ApiResponse.buildOK((Object)true);
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> update(AppClientUpdateRequest updateRequest) {
        AppClient appClient = this.appClientService.selectById(updateRequest.getId());
        ApiResponse checkResult = this.verifyUpdateParam(appClient, updateRequest);
        if (checkResult.isError()) {
            return checkResult;
        }
        this.appClientService.update(appClient, updateRequest);
        this.appUpdateService.update(appClient.getId(), updateRequest);
        return ApiResponse.buildOK((Object)true);
    }

    private ApiResponse<Boolean> verifyReleaseParam(AppClient appClient, AppClientUpdateRequest releaseRequest) {
        if (null == appClient) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        if (PublishEnum.CANCELPUBLISH.getValue().equals(appClient.getPublish())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u53d6\u6d88\u53d1\u5e03\u4e0b\uff0c\u4e0d\u53ef\u518d\u6b21\u53d1\u5e03"));
        }
        if (!appClient.getAppId().equals(releaseRequest.getAppId()) || !appClient.getVersion().equals(releaseRequest.getVersion())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u5e94\u7528\u4e0e\u7248\u672c\u53f7\u4e0d\u80fd\u4fee\u6539"));
        }
        return this.verifyAddParam((AppClientAddRequest)releaseRequest);
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> release(AppClientUpdateRequest releaseRequest) {
        AppClient appClient = this.appClientService.selectById(releaseRequest.getId());
        ApiResponse checkResult = this.verifyReleaseParam(appClient, releaseRequest);
        if (checkResult.isError()) {
            return checkResult;
        }
        Integer publish = appClient.getPublish();
        this.appClientService.release(appClient, releaseRequest);
        this.appUpdateService.release(appClient.getId(), publish, releaseRequest);
        return ApiResponse.buildOK((Object)true);
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> unrelease(Long id) {
        AppClient appClient = this.appClientService.selectById(id);
        if (null == appClient) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        if (!PublishEnum.PUBLISH.getValue().equals(appClient.getPublish())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u53d1\u5e03\u72b6\u6001\u624d\u53ef\u4ee5\u53d6\u6d88\u53d1\u5e03"));
        }
        this.appClientService.unrelease(appClient);
        return ApiResponse.buildOK((Object)true);
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteById(Long id) {
        AppClient appClient = this.appClientService.selectById(id);
        if (null == appClient) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        if (PublishEnum.PUBLISH.getValue().equals(appClient.getPublish())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u53d1\u5e03\u72b6\u6001\u4e0b\uff0c\u4e0d\u53ef\u5220\u9664"));
        }
        this.appClientService.deleteById(id);
        this.appUpdateService.deleteByAppClientId(id);
        return ApiResponse.buildOK((Object)true);
    }

    public ApiResponse<List<AppUpdateResponse>> updateHistoryById(Long id) {
        AppClient appClient = this.appClientService.selectById(id);
        if (null == appClient) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return ApiResponse.buildOK(this.appUpdateService.getBakByAppClientId(appClient.getId()).stream().map(AppUpdateResponse::convert).collect(Collectors.toList()));
    }
}

