/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.model.db2.AppClient;
import com.digiwin.mobile.mobileuibot.model.db2.AppConfig;
import com.digiwin.mobile.mobileuibot.model.db2.AppUpdate;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.versionManage.VersionUpgradeService;
import com.digiwin.mobile.mobileuibot.versionManage.VersionUpgradeServiceImpl;
import com.digiwin.mobile.mobileuibot.versionManage.enums.BrandEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.ComponentEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.OperatorEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.ReleaseTypeEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.StrongUpdateEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateRangeEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateStrategyEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.ValidEnum;
import com.digiwin.mobile.mobileuibot.versionManage.model.UpdateCondition;
import com.digiwin.mobile.mobileuibot.versionManage.model.UpdateConditionItem;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppUpgradeReq;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppCheckResp;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppUpgradeResp;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppClientService;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConditionItemService;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConditionService;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConfigService;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppUpdateService;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppUserClientRecordService;
import com.digiwin.mobile.mobileuibot.versionManage.utils.BrandIdentifier;
import com.digiwin.mobile.mobileuibot.versionManage.utils.VersionComparator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionUpgradeServiceImpl
implements VersionUpgradeService {
    private static final Logger log = LoggerFactory.getLogger(VersionUpgradeServiceImpl.class);
    private static final List<String> ARCH_32 = Lists.newArrayList((Object[])new String[]{"armeabi-v7a"});
    private static final List<String> ARCH_64 = Lists.newArrayList((Object[])new String[]{"arm64-v8a"});
    @Autowired
    private AppConfigService appConfigService;
    @Autowired
    private AppClientService appClientService;
    @Autowired
    private AppUpdateService appUpdateService;
    @Autowired
    private AppConditionService appConditionService;
    @Autowired
    private AppConditionItemService appConditionItemService;
    @Autowired
    private AppUserClientRecordService appUserClientRecordService;
    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;
    @Autowired
    private DigiwinAimProxyService digiwinAimProxyService;

    public AppUpgradeResp upgrade(AppUpgradeReq vo) {
        this.appUserClientRecordService.asyncStorage(vo);
        AppUpgradeResp result = new AppUpgradeResp().setUpdateStrategy(UpdateStrategyEnum.NONE.getValue());
        AppConfig appConfig = this.appConfigService.getByCode(vo.getAppId());
        if (appConfig == null) {
            log.error("appConfig is null, code: {}", (Object)vo.getAppId());
            return result;
        }
        if (!ValidEnum.VALID.getValue().equals(appConfig.getValid())) {
            log.error("appConfig is invalid, code: {}", (Object)vo.getAppId());
            return result;
        }
        AppClient latestAppClient = this.appClientService.getPublishByAppId(appConfig.getId());
        if (latestAppClient == null) {
            log.error("appClient is null, code: {}, appId: {}", (Object)vo.getAppId(), (Object)appConfig.getId());
            return result;
        }
        UpdateStrategyEnum updateStrategy = this.getCurrentVersionUpdateStrategy(vo, appConfig, latestAppClient);
        return this.buildAppUpgradeResp(vo, result, appConfig, latestAppClient, updateStrategy);
    }

    private UpdateStrategyEnum getCurrentVersionUpdateStrategy(AppUpgradeReq vo, AppConfig appConfig, AppClient latestAppClient) {
        UpdateStrategyEnum strategy;
        AppClient appClient;
        if (VersionComparator.compareVersions((String)vo.getVersion(), (String)latestAppClient.getVersion()) >= 0) {
            log.error("client version is latest, code: {}, appId: {}, version: {}", new Object[]{vo.getAppId(), appConfig.getId(), vo.getVersion()});
            return UpdateStrategyEnum.NONE;
        }
        AppClient cAppClient = this.appClientService.getValidByAppIdAndVersion(appConfig.getId(), vo.getVersion());
        if (cAppClient == null) {
            log.error("client version is not exist, code: {}, appId: {}, version: {}", new Object[]{vo.getAppId(), appConfig.getId(), vo.getVersion()});
            AppUpdate latestAppUpdate = this.appUpdateService.getNotBakByAppClientId(latestAppClient.getId());
            Integer strongUpdate = Optional.ofNullable(latestAppUpdate).map(AppUpdate::getStrongUpdate).orElse(StrongUpdateEnum.NO.getValue());
            if (StrongUpdateEnum.YES.getValue().equals(strongUpdate)) {
                return UpdateStrategyEnum.FORCE;
            }
            return UpdateStrategyEnum.RECOMMEND;
        }
        List middleAppClients = this.appClientService.getValidMiddleVersion(appConfig.getId(), latestAppClient.getSequence(), cAppClient.getSequence());
        if (CollectionUtils.isEmpty((Collection)middleAppClients)) {
            log.error("middle app clients is empty, code: {}, appId: {}, latestSequence: {}, sequence: {}", new Object[]{vo.getAppId(), appConfig.getId(), latestAppClient.getSequence(), cAppClient.getSequence()});
            return UpdateStrategyEnum.NONE;
        }
        Map<Long, AppClient> appClientMap = middleAppClients.stream().collect(Collectors.toMap(AppClient::getId, c -> c, (c1, c2) -> c1));
        List appUpdates = this.appUpdateService.getNotBakByAppClientIds(appClientMap.keySet());
        if (CollectionUtils.isEmpty((Collection)appUpdates)) {
            log.error("middle app updates is empty, code: {}, appId: {}, latestSequence: {}, sequence: {}, appClientIds: {}", new Object[]{vo.getAppId(), appConfig.getId(), latestAppClient.getSequence(), cAppClient.getSequence(), JsonUtil.javaObjectToJsonString(appClientMap.keySet())});
            return UpdateStrategyEnum.NONE;
        }
        UpdateStrategyEnum updateStrategy = UpdateStrategyEnum.NONE;
        List strongAppUpdates = appUpdates.stream().filter(appUpdate -> StrongUpdateEnum.YES.getValue().equals(appUpdate.getStrongUpdate())).collect(Collectors.toList());
        for (AppUpdate appUpdate2 : strongAppUpdates) {
            appClient = appClientMap.get(appUpdate2.getAppClientId());
            strategy = this.checkUpdateStrategy(vo, appClient, appUpdate2);
            if (UpdateStrategyEnum.FORCE == strategy) {
                log.error("exist force client version is force update, appClientId: {}, version: {}", (Object)appUpdate2.getAppClientId(), Optional.ofNullable(appClient).map(AppClient::getVersion).orElse(null));
                return strategy;
            }
            if (UpdateStrategyEnum.RECOMMEND != strategy) continue;
            log.error("exist force client version is recommend update, appClientId: {}, version: {}", (Object)appUpdate2.getAppClientId(), Optional.ofNullable(appClient).map(AppClient::getVersion).orElse(null));
            updateStrategy = strategy;
        }
        if (UpdateStrategyEnum.NONE != updateStrategy) {
            return updateStrategy;
        }
        appUpdates.removeAll(strongAppUpdates);
        for (AppUpdate appUpdate2 : appUpdates) {
            appClient = appClientMap.get(appUpdate2.getAppClientId());
            strategy = this.checkUpdateStrategy(vo, appClient, appUpdate2);
            if (UpdateStrategyEnum.RECOMMEND != strategy) continue;
            log.error("exist recommend client version is recommend update, appClientId: {}, version: {}", (Object)appUpdate2.getAppClientId(), Optional.ofNullable(appClient).map(AppClient::getVersion).orElse(null));
            return strategy;
        }
        return updateStrategy;
    }

    private UpdateStrategyEnum checkUpdateStrategy(AppUpgradeReq vo, AppClient appClient, AppUpdate appUpdate) {
        if (appClient == null || appUpdate == null) {
            return UpdateStrategyEnum.NONE;
        }
        if (ReleaseTypeEnum.FULL.getValue().equals(appUpdate.getReleaseType())) {
            if (StrongUpdateEnum.YES.getValue().equals(appUpdate.getStrongUpdate())) {
                if (UpdateRangeEnum.PARTIAL.getValue().equals(appUpdate.getUpdateRange())) {
                    if (StringUtils.isBlank((CharSequence)appUpdate.getConditions())) {
                        return UpdateStrategyEnum.RECOMMEND;
                    }
                    if (this.checkConditionGroup(vo, appUpdate)) {
                        return UpdateStrategyEnum.FORCE;
                    }
                    return UpdateStrategyEnum.RECOMMEND;
                }
                return UpdateStrategyEnum.FORCE;
            }
            return UpdateStrategyEnum.RECOMMEND;
        }
        if (StringUtils.isBlank((CharSequence)appUpdate.getConditions())) {
            return UpdateStrategyEnum.NONE;
        }
        if (StrongUpdateEnum.YES.getValue().equals(appUpdate.getStrongUpdate())) {
            if (this.checkConditionGroup(vo, appUpdate)) {
                return UpdateStrategyEnum.FORCE;
            }
            return UpdateStrategyEnum.NONE;
        }
        if (this.checkConditionGroup(vo, appUpdate)) {
            return UpdateStrategyEnum.RECOMMEND;
        }
        return UpdateStrategyEnum.NONE;
    }

    private boolean checkConditionGroup(AppUpgradeReq vo, AppUpdate appUpdate) {
        List conditionList;
        String conditionStr = appUpdate.getConditions();
        if (StringUtils.isBlank((CharSequence)conditionStr)) {
            return false;
        }
        try {
            conditionList = (List)JsonUtil.jsonStringToObject((String)conditionStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.error("checkConditionGroup error, condition: {}", (Object)conditionStr, (Object)e);
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < conditionList.size(); ++i) {
            UpdateCondition curr = (UpdateCondition)conditionList.get(i);
            if (i == 0) {
                result = this.checkCondition(vo, curr);
            } else {
                UpdateCondition prev = (UpdateCondition)conditionList.get(i - 1);
                if ("OR".equalsIgnoreCase(prev.getLogic())) {
                    result = this.checkCondition(vo, curr);
                } else {
                    boolean bl = result = result ? this.checkCondition(vo, curr) : result;
                }
            }
            if (!"OR".equalsIgnoreCase(curr.getLogic()) || !result) continue;
            return true;
        }
        return result;
    }

    private boolean checkCondition(AppUpgradeReq vo, UpdateCondition condition) {
        if (condition == null) {
            return false;
        }
        List item = condition.getItem();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < item.size(); ++i) {
            UpdateConditionItem curr = (UpdateConditionItem)item.get(i);
            if (i == 0) {
                result = this.checkConditionItem(vo, curr);
            } else {
                UpdateConditionItem prev = (UpdateConditionItem)item.get(i - 1);
                if ("OR".equalsIgnoreCase(prev.getLogic())) {
                    result = this.checkConditionItem(vo, curr);
                } else {
                    boolean bl = result = result ? this.checkConditionItem(vo, curr) : result;
                }
            }
            if (!"OR".equalsIgnoreCase(curr.getLogic()) || !result) continue;
            return true;
        }
        return result;
    }

    private boolean checkConditionItem(AppUpgradeReq vo, UpdateConditionItem curr) {
        boolean result;
        if (curr == null) {
            return false;
        }
        ComponentEnum componentEnum = ComponentEnum.exist((Integer)curr.getComponent());
        if (componentEnum == null) {
            return false;
        }
        switch (4.$SwitchMap$com$digiwin$mobile$mobileuibot$versionManage$enums$ComponentEnum[componentEnum.ordinal()]) {
            case 1: 
            case 2: {
                result = this.checkText(vo, curr);
                break;
            }
            case 3: 
            case 4: {
                result = this.checkSelect(vo, curr);
                break;
            }
            case 5: {
                result = this.checkSelectTenant(vo, curr);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown component");
            }
        }
        return result;
    }

    private boolean checkText(AppUpgradeReq vo, UpdateConditionItem curr) {
        if (curr == null) {
            return false;
        }
        if ("goods_code".equalsIgnoreCase(curr.getSchema())) {
            return this.checkGoodsCode(vo, curr);
        }
        return this.checkCommonText(vo, curr);
    }

    private boolean checkCommonText(AppUpgradeReq vo, UpdateConditionItem curr) {
        if (curr == null) {
            return false;
        }
        List serverValue = curr.getValue();
        if (CollectionUtils.isEmpty((Collection)serverValue)) {
            return false;
        }
        Map rawMap = (Map)JsonUtil.objectToJavaObject((Object)vo, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        String clientValue = StringUtil.valueOf(rawMap.get(curr.getSchema())).toLowerCase();
        if (StringUtils.isBlank((CharSequence)clientValue)) {
            return false;
        }
        String serverValueStr = ((String)serverValue.get(0)).toLowerCase();
        if (serverValueStr.contains(",")) {
            String[] serverValueArr = serverValueStr.split(",");
            return Arrays.asList(serverValueArr).contains(clientValue);
        }
        OperatorEnum operatorEnum = OperatorEnum.exist((String)curr.getOperator());
        if (operatorEnum == null) {
            return serverValueStr.equalsIgnoreCase(clientValue);
        }
        switch (4.$SwitchMap$com$digiwin$mobile$mobileuibot$versionManage$enums$OperatorEnum[operatorEnum.ordinal()]) {
            case 1: {
                return serverValueStr.equalsIgnoreCase(clientValue);
            }
            case 2: {
                return Integer.parseInt(clientValue) < Integer.parseInt(serverValueStr);
            }
            case 3: {
                return Integer.parseInt(clientValue) <= Integer.parseInt(serverValueStr);
            }
            case 4: {
                return Integer.parseInt(clientValue) > Integer.parseInt(serverValueStr);
            }
            case 5: {
                return Integer.parseInt(clientValue) >= Integer.parseInt(serverValueStr);
            }
        }
        return serverValueStr.equalsIgnoreCase(clientValue);
    }

    private boolean checkGoodsCode(AppUpgradeReq vo, UpdateConditionItem curr) {
        String[] stringArray;
        if (curr == null) {
            return false;
        }
        List serverValue = curr.getValue();
        if (CollectionUtils.isEmpty((Collection)serverValue)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)vo.getUserId()) || StringUtils.isBlank((CharSequence)vo.getIamUserToken())) {
            return false;
        }
        String serverValueStr = (String)serverValue.get(0);
        if (serverValueStr.contains(",")) {
            stringArray = serverValueStr.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = serverValueStr;
        }
        List serverValueList = Arrays.stream(stringArray).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List authApps = this.digiwinCacProxyService.findAuthorizationsCurrentUserApp(vo.getUserId(), vo.getIamUserToken());
        if (CollectionUtils.isEmpty((Collection)authApps)) {
            return false;
        }
        return authApps.stream().anyMatch(app -> serverValueList.contains(app.getId()) && BooleanUtils.isTrue((Boolean)DateTimeUtil.isAfterNowDatetime((String)app.getExpiredTime())));
    }

    private boolean checkSelect(AppUpgradeReq vo, UpdateConditionItem curr) {
        if (curr == null) {
            return false;
        }
        List serverValue = curr.getValue();
        if (CollectionUtils.isEmpty((Collection)serverValue)) {
            return false;
        }
        serverValue = serverValue.stream().map(String::toLowerCase).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Map rawMap = (Map)JsonUtil.objectToJavaObject((Object)vo, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        String clientValue = StringUtil.valueOf(rawMap.get(curr.getSchema())).toLowerCase();
        if (StringUtils.isBlank((CharSequence)clientValue)) {
            return false;
        }
        return serverValue.contains(clientValue);
    }

    private boolean checkSelectTenant(AppUpgradeReq vo, UpdateConditionItem curr) {
        if (curr == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)vo.getUserId()) || StringUtils.isBlank((CharSequence)vo.getIamUserToken()) || StringUtils.isBlank((CharSequence)vo.getTenantId())) {
            return false;
        }
        boolean result = false;
        List serverValue = curr.getValue();
        if (CollectionUtils.isNotEmpty((Collection)serverValue)) {
            result = serverValue.contains(vo.getTenantId());
        }
        if (result) {
            return result;
        }
        if (BooleanUtils.isNotTrue((Boolean)curr.getOpsTenant())) {
            return result;
        }
        String tenantRouteType = this.digiwinAimProxyService.getTenantRouteType(vo.getIamUserToken());
        return "PRE".equalsIgnoreCase(tenantRouteType);
    }

    private AppUpgradeResp buildAppUpgradeResp(AppUpgradeReq vo, AppUpgradeResp result, AppConfig appConfig, AppClient latestAppClient, UpdateStrategyEnum updateStrategy) {
        if (UpdateStrategyEnum.NONE == updateStrategy) {
            return result;
        }
        result.setLatestVersion(latestAppClient.getVersion()).setUpdateStrategy(updateStrategy.getValue()).setMd5(this.getMd5(vo.getArch(), appConfig.getOsType(), latestAppClient)).setStore(this.isStore(vo.getBrand(), appConfig.getOsType(), latestAppClient)).setUrl(this.getUrl(vo.getArch(), appConfig.getOsType(), latestAppClient)).setTitle(latestAppClient.getTipsTitle(vo.getLocale())).setTips(latestAppClient.getTips(vo.getLocale()));
        return result;
    }

    private String getMd5(String arch, String osType, AppClient latestAppClient) {
        if ("ios".equalsIgnoreCase(osType)) {
            return null;
        }
        String md5 = latestAppClient.getMd532();
        if (ARCH_64.contains(arch)) {
            md5 = latestAppClient.getMd564();
        }
        return md5;
    }

    private String getUrl(String arch, String osType, AppClient latestAppClient) {
        String url = latestAppClient.getUrl32();
        if ("ios".equalsIgnoreCase(osType)) {
            return url;
        }
        if (ARCH_64.contains(arch)) {
            url = latestAppClient.getUrl64();
        }
        return url;
    }

    private Boolean isStore(String inputBrand, String osType, AppClient latestAppClient) {
        if ("ios".equalsIgnoreCase(osType)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)inputBrand) || StringUtils.isBlank((CharSequence)latestAppClient.getBrand())) {
            return false;
        }
        BrandEnum brandEnum = BrandEnum.exist((String)BrandIdentifier.identifyBrand((String)inputBrand));
        if (brandEnum == null) {
            return false;
        }
        return Arrays.stream(latestAppClient.getBrand().split(",")).map(String::trim).filter(StringUtils::isNotBlank).anyMatch(r -> r.equalsIgnoreCase(brandEnum.getValue()));
    }

    public AppCheckResp checkUpdate(AppUpgradeReq vo) {
        AppCheckResp result = (AppCheckResp)new AppCheckResp().setIsLatest(Boolean.valueOf(true)).setUpdateStrategy(UpdateStrategyEnum.NONE.getValue());
        AppConfig appConfig = this.appConfigService.getByCode(vo.getAppId());
        if (appConfig == null) {
            log.error("appConfig is null, code: {}", (Object)vo.getAppId());
            return result;
        }
        if (!ValidEnum.VALID.getValue().equals(appConfig.getValid())) {
            log.error("appConfig is invalid, code: {}", (Object)vo.getAppId());
            return result;
        }
        AppClient latestAppClient = this.appClientService.getPublishByAppId(appConfig.getId());
        if (latestAppClient == null) {
            log.error("appClient is null, code: {}, appId: {}", (Object)vo.getAppId(), (Object)appConfig.getId());
            return result;
        }
        AppUpdate latestAppUpdate = this.appUpdateService.getNotBakByAppClientId(latestAppClient.getId());
        if (latestAppUpdate == null) {
            log.error("appUpdate is null, code: {}, appId: {}, appClientId: {}", new Object[]{vo.getAppId(), appConfig.getId(), latestAppClient.getId()});
            return result;
        }
        result.setIsLatest(Boolean.valueOf(VersionComparator.compareVersions((String)vo.getVersion(), (String)latestAppClient.getVersion()) >= 0));
        if (result.getIsLatest().booleanValue()) {
            return (AppCheckResp)result.setLatestVersion(latestAppClient.getVersion());
        }
        return (AppCheckResp)this.buildAppUpgradeResp(vo, (AppUpgradeResp)result, appConfig, latestAppClient, UpdateStrategyEnum.RECOMMEND);
    }
}

