/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppConditionMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.BaseModel;
import com.digiwin.mobile.mobileuibot.model.db2.AppCondition;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConditionService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppConditionServiceImpl
implements AppConditionService {
    @Autowired
    private AppConditionMapper appConditionMapper;

    public List<AppCondition> list(AppConditionPageRequest request) {
        if (request == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = this.buildWrapper(request);
        wrapper.orderByDesc(AppCondition::getId);
        return this.appConditionMapper.selectList((Wrapper)wrapper);
    }

    private LambdaQueryWrapper<AppCondition> buildWrapper(AppConditionPageRequest pageRequest) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(StringUtils.isNotBlank((CharSequence)pageRequest.getName()), AppCondition::getName, (Object)pageRequest.getName());
        wrapper.like(StringUtils.isNotBlank((CharSequence)pageRequest.getDescr()), AppCondition::getDescr, (Object)pageRequest.getDescr());
        wrapper.eq(AppCondition::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.ge(StringUtils.isNotBlank((CharSequence)pageRequest.getCreateTimeStart()), BaseModel::getCreateTime, (Object)pageRequest.getCreateTimeStart());
        wrapper.le(StringUtils.isNotBlank((CharSequence)pageRequest.getCreateTimeEnd()), BaseModel::getCreateTime, (Object)pageRequest.getCreateTimeEnd());
        wrapper.ge(StringUtils.isNotBlank((CharSequence)pageRequest.getUpdateTimeStart()), BaseModel::getUpdateTime, (Object)pageRequest.getUpdateTimeStart());
        wrapper.le(StringUtils.isNotBlank((CharSequence)pageRequest.getUpdateTimeEnd()), BaseModel::getUpdateTime, (Object)pageRequest.getUpdateTimeEnd());
        return wrapper;
    }

    public Page<AppCondition> listPage(AppConditionPageRequest pageRequest) {
        if (pageRequest == null) {
            return new Page();
        }
        Page page = new Page((long)pageRequest.getPageNum().intValue(), (long)pageRequest.getPageSize().intValue());
        LambdaQueryWrapper wrapper = this.buildWrapper(pageRequest);
        wrapper.orderByDesc(AppCondition::getId);
        return (Page)this.appConditionMapper.selectPage((IPage)page, (Wrapper)wrapper);
    }

    public AppCondition selectById(Long id) {
        if (id == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppCondition::getId, (Object)id);
        wrapper.eq(AppCondition::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        return (AppCondition)this.appConditionMapper.selectOne((Wrapper)wrapper, false);
    }

    public AppCondition add(AppConditionAddRequest addRequest) {
        if (addRequest == null) {
            return null;
        }
        AppCondition appCondition = new AppCondition().setId(null).setName(addRequest.getName()).setDescr(addRequest.getDescr()).setDelFlag(DelFlagEnum.UNDELETE.getValue());
        this.appConditionMapper.insert((Object)appCondition);
        return appCondition;
    }

    public void update(AppCondition appCondition, AppConditionUpdateRequest updateRequest) {
        if (appCondition == null || updateRequest == null) {
            return;
        }
        appCondition.setName(updateRequest.getName()).setDescr(updateRequest.getDescr()).clearTime();
        this.appConditionMapper.updateById((Object)appCondition);
    }

    public void deleteById(Long id) {
        if (id == null) {
            return;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(AppCondition::getId, (Object)id);
        wrapper.eq(AppCondition::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.set(AppCondition::getDelFlag, (Object)DelFlagEnum.DELETE.getValue());
        this.appConditionMapper.update(null, (Wrapper)wrapper);
    }
}

