/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppConfigMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.BaseModel;
import com.digiwin.mobile.mobileuibot.model.db2.AppConfig;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConfigService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppConfigServiceImpl
implements AppConfigService {
    @Autowired
    private AppConfigMapper appConfigMapper;

    public AppConfig getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppConfig::getCode, (Object)code);
        wrapper.eq(AppConfig::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        return (AppConfig)this.appConfigMapper.selectOne((Wrapper)wrapper, false);
    }

    public List<AppConfig> list(AppConfigPageRequest request) {
        if (request == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = this.buildWrapper(request);
        wrapper.orderByDesc(AppConfig::getId);
        return this.appConfigMapper.selectList((Wrapper)wrapper);
    }

    private LambdaQueryWrapper<AppConfig> buildWrapper(AppConfigPageRequest pageRequest) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(StringUtils.isNotBlank((CharSequence)pageRequest.getCode()), AppConfig::getCode, (Object)pageRequest.getCode());
        wrapper.like(StringUtils.isNotBlank((CharSequence)pageRequest.getName()), AppConfig::getName, (Object)pageRequest.getName());
        wrapper.like(StringUtils.isNotBlank((CharSequence)pageRequest.getOsType()), AppConfig::getOsType, (Object)pageRequest.getOsType());
        wrapper.like(StringUtils.isNotBlank((CharSequence)pageRequest.getEnv()), AppConfig::getEnv, (Object)pageRequest.getEnv());
        wrapper.like(StringUtils.isNotBlank((CharSequence)pageRequest.getDescr()), AppConfig::getDescr, (Object)pageRequest.getDescr());
        wrapper.eq(pageRequest.getValid() != null, AppConfig::getValid, (Object)pageRequest.getValid());
        wrapper.eq(AppConfig::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.ge(StringUtils.isNotBlank((CharSequence)pageRequest.getCreateTimeStart()), BaseModel::getCreateTime, (Object)pageRequest.getCreateTimeStart());
        wrapper.le(StringUtils.isNotBlank((CharSequence)pageRequest.getCreateTimeEnd()), BaseModel::getCreateTime, (Object)pageRequest.getCreateTimeEnd());
        wrapper.ge(StringUtils.isNotBlank((CharSequence)pageRequest.getUpdateTimeStart()), BaseModel::getUpdateTime, (Object)pageRequest.getUpdateTimeStart());
        wrapper.le(StringUtils.isNotBlank((CharSequence)pageRequest.getUpdateTimeEnd()), BaseModel::getUpdateTime, (Object)pageRequest.getUpdateTimeEnd());
        return wrapper;
    }

    public Page<AppConfig> listPage(AppConfigPageRequest pageRequest) {
        if (pageRequest == null) {
            return new Page();
        }
        Page page = new Page((long)pageRequest.getPageNum().intValue(), (long)pageRequest.getPageSize().intValue());
        LambdaQueryWrapper wrapper = this.buildWrapper(pageRequest);
        wrapper.orderByDesc(AppConfig::getId);
        return (Page)this.appConfigMapper.selectPage((IPage)page, (Wrapper)wrapper);
    }

    public AppConfig selectById(Long id) {
        if (id == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppConfig::getId, (Object)id);
        wrapper.eq(AppConfig::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        return (AppConfig)this.appConfigMapper.selectOne((Wrapper)wrapper, false);
    }

    public void add(String appId, AppConfigAddRequest addRequest) {
        if (addRequest == null || StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        AppConfig appConfig = new AppConfig().setId(null).setCode(appId).setName(addRequest.getName()).setOsType(addRequest.getOsType()).setEnv(addRequest.getEnv()).setDescr(addRequest.getDescr()).setValid(addRequest.getValid()).setDelFlag(DelFlagEnum.UNDELETE.getValue());
        this.appConfigMapper.insert((Object)appConfig);
    }

    public AppConfig selectByIdAndCode(Long id, String code) {
        if (id == null || StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppConfig::getId, (Object)id);
        wrapper.eq(AppConfig::getCode, (Object)code);
        wrapper.eq(AppConfig::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        return (AppConfig)this.appConfigMapper.selectOne((Wrapper)wrapper, false);
    }

    public void update(AppConfig appConfig, AppConfigUpdateRequest updateRequest) {
        if (appConfig == null || updateRequest == null) {
            return;
        }
        appConfig.setName(updateRequest.getName()).setOsType(updateRequest.getOsType()).setEnv(updateRequest.getEnv()).setDescr(updateRequest.getDescr()).setValid(updateRequest.getValid()).clearTime();
        this.appConfigMapper.updateById((Object)appConfig);
    }

    public void deleteById(Long id) {
        if (id == null) {
            return;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(AppConfig::getId, (Object)id);
        wrapper.eq(AppConfig::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.set(AppConfig::getDelFlag, (Object)DelFlagEnum.DELETE.getValue());
        this.appConfigMapper.update(null, (Wrapper)wrapper);
    }

    public void updateAppId(Long id, String appId) {
        if (id == null || StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(AppConfig::getId, (Object)id);
        wrapper.eq(AppConfig::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.set(AppConfig::getCode, (Object)appId);
        this.appConfigMapper.update(null, (Wrapper)wrapper);
    }
}

