/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppUpdateMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.db2.AppUpdate;
import com.digiwin.mobile.mobileuibot.versionManage.enums.BakFlagEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.PublishEnum;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppUpdateService;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppUpdateServiceImpl
implements AppUpdateService {
    @Autowired
    private AppUpdateMapper appUpdateMapper;

    public AppUpdate getNotBakByAppClientId(Long appClientId) {
        if (appClientId == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppUpdate::getAppClientId, (Object)appClientId);
        wrapper.eq(AppUpdate::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, (Object)BakFlagEnum.UNBAK.getValue());
        return (AppUpdate)this.appUpdateMapper.selectOne((Wrapper)wrapper, false);
    }

    public List<AppUpdate> getNotBakByAppClientIds(Set<Long> appClientIds) {
        if (CollectionUtils.isEmpty(appClientIds)) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(AppUpdate::getAppClientId, appClientIds);
        wrapper.eq(AppUpdate::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, (Object)BakFlagEnum.UNBAK.getValue());
        wrapper.orderByDesc(AppUpdate::getId);
        return this.appUpdateMapper.selectList((Wrapper)wrapper);
    }

    public void add(Long appClientId, AppClientAddRequest addRequest) {
        if (appClientId == null || addRequest == null) {
            return;
        }
        AppUpdate appUpdate = new AppUpdate().setId(null).setAppClientId(appClientId).setReleaseType(addRequest.getReleaseType()).setStrongUpdate(addRequest.getStrongUpdate()).setUpdateRange(addRequest.getUpdateRange()).setConditions(addRequest.convertConditions()).setBakFlag(BakFlagEnum.UNBAK.getValue()).setDelFlag(DelFlagEnum.UNDELETE.getValue());
        this.appUpdateMapper.insert((Object)appUpdate);
    }

    public void update(Long appClientId, AppClientUpdateRequest updateRequest) {
        if (appClientId == null || updateRequest == null) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppUpdate::getAppClientId, (Object)appClientId);
        wrapper.eq(AppUpdate::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, (Object)BakFlagEnum.UNBAK.getValue());
        AppUpdate appUpdate = (AppUpdate)this.appUpdateMapper.selectOne((Wrapper)wrapper, false);
        if (appUpdate == null) {
            return;
        }
        appUpdate.setReleaseType(updateRequest.getReleaseType()).setStrongUpdate(updateRequest.getStrongUpdate()).setUpdateRange(updateRequest.getUpdateRange()).setConditions(updateRequest.convertConditions()).clearTime();
        this.appUpdateMapper.updateById((Object)appUpdate);
    }

    public void release(Long appClientId, Integer publish, AppClientUpdateRequest releaseRequest) {
        if (appClientId == null || releaseRequest == null) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppUpdate::getAppClientId, (Object)appClientId);
        wrapper.eq(AppUpdate::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, (Object)BakFlagEnum.UNBAK.getValue());
        AppUpdate appUpdate = (AppUpdate)this.appUpdateMapper.selectOne((Wrapper)wrapper, false);
        if (appUpdate == null) {
            return;
        }
        if (!PublishEnum.PUBLISH.getValue().equals(publish)) {
            appUpdate.setReleaseType(releaseRequest.getReleaseType()).setStrongUpdate(releaseRequest.getStrongUpdate()).setUpdateRange(releaseRequest.getUpdateRange()).setConditions(releaseRequest.convertConditions()).clearTime();
            appUpdate.setUpdateTime(new Date());
            this.appUpdateMapper.updateById((Object)appUpdate);
            return;
        }
        appUpdate.setBakFlag(BakFlagEnum.BAK.getValue());
        this.appUpdateMapper.updateById((Object)appUpdate);
        AppUpdate addAppUpdate = new AppUpdate().setId(null).setAppClientId(appClientId).setReleaseType(releaseRequest.getReleaseType()).setStrongUpdate(releaseRequest.getStrongUpdate()).setUpdateRange(releaseRequest.getUpdateRange()).setConditions(releaseRequest.convertConditions()).setBakFlag(BakFlagEnum.UNBAK.getValue()).setDelFlag(DelFlagEnum.UNDELETE.getValue());
        addAppUpdate.setCreateTime(new Date());
        addAppUpdate.setUpdateTime(new Date());
        this.appUpdateMapper.insert((Object)addAppUpdate);
    }

    public void deleteByAppClientId(Long appClientId) {
        if (appClientId == null) {
            return;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(AppUpdate::getAppClientId, (Object)appClientId);
        wrapper.eq(AppUpdate::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.set(AppUpdate::getDelFlag, (Object)DelFlagEnum.DELETE.getValue());
        this.appUpdateMapper.update(null, (Wrapper)wrapper);
    }

    public List<AppUpdate> getBakByAppClientId(Long appClientId) {
        if (appClientId == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppUpdate::getAppClientId, (Object)appClientId);
        wrapper.eq(AppUpdate::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, (Object)BakFlagEnum.BAK.getValue());
        wrapper.orderByDesc(AppUpdate::getId);
        return this.appUpdateMapper.selectList((Wrapper)wrapper);
    }
}

