/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage.utils;

import com.digiwin.mobile.mobileuibot.versionManage.enums.BrandEnum;
import com.digiwin.mobile.mobileuibot.versionManage.utils.BrandIdentifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class BrandIdentifier {
    private static final Map<BrandEnum, Set<String>> BRAND_MAPPING = new HashMap();
    private static final Map<Pattern, BrandEnum> SPECIAL_PATTERNS = new HashMap();
    private static final Map<Pattern, BrandEnum> MODEL_KEYWORDS = new HashMap();
    private static final Trie PREFIX_TRIE = new Trie();

    public static String identifyBrand(String inputBrand) {
        if (inputBrand == null || inputBrand.trim().isEmpty()) {
            return null;
        }
        String cleaned = BrandIdentifier.cleanInput((String)inputBrand);
        for (Map.Entry entry : SPECIAL_PATTERNS.entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(cleaned).find()) continue;
            return ((BrandEnum)entry.getValue()).getValue();
        }
        for (Map.Entry entry : BRAND_MAPPING.entrySet()) {
            if (!((Set)entry.getValue()).contains(cleaned)) continue;
            return ((BrandEnum)entry.getKey()).getValue();
        }
        BrandEnum matchedBrand = PREFIX_TRIE.searchPrefix(cleaned);
        if (matchedBrand != null) {
            return matchedBrand.getValue();
        }
        for (Map.Entry entry : MODEL_KEYWORDS.entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(cleaned).find()) continue;
            return ((BrandEnum)entry.getValue()).getValue();
        }
        if (cleaned.matches(".*[0-9]{2,}.*")) {
            if (cleaned.contains("huawei") || cleaned.contains("honor")) {
                return BrandEnum.HUAWEI.getValue();
            }
            if (cleaned.contains("redmi") || cleaned.contains("mi")) {
                return BrandEnum.XIAOMI.getValue();
            }
        }
        return null;
    }

    private static String cleanInput(String input) {
        return input.toLowerCase().replaceAll("\\s+", "").replace("-", "").replace("_", "").replace(".", "").replace("\u7cfb\u5217", "").replace("\u624b\u673a", "");
    }

    public static void main(String[] args) {
        String[] testCases;
        for (String brand : testCases = new String[]{"XIAOMI", "Redmi Note 12", "POCO F5", "OnePlus 11", "realme GT", "HONOR Magic", "Galaxy S23", "iPhone 15", "Pixel 8", "motorola edge", "nokia 8.3", "unknown-brand"}) {
            System.out.printf("%-15s -> %s%n", brand, BrandIdentifier.identifyBrand((String)brand));
        }
    }

    static {
        SPECIAL_PATTERNS.put(Pattern.compile("^(redmi|red\\s?mi|\u7ea2\u7c73)"), BrandEnum.XIAOMI);
        SPECIAL_PATTERNS.put(Pattern.compile("^(oneplus|one\\s?plus|\u4e00\u52a0)"), BrandEnum.OPPO);
        HashSet<String> xiaomiGroup = new HashSet<String>(Arrays.asList("xiaomi", "mi", "redmi", "poco", "blackshark", "hmd"));
        BRAND_MAPPING.put(BrandEnum.XIAOMI, xiaomiGroup);
        HashSet<String> oppoGroup = new HashSet<String>(Arrays.asList("oppo", "realme", "oneplus", "one plus"));
        BRAND_MAPPING.put(BrandEnum.OPPO, oppoGroup);
        HashSet<String> huaweiGroup = new HashSet<String>(Arrays.asList("huawei", "honor", "hua wei"));
        BRAND_MAPPING.put(BrandEnum.HUAWEI, huaweiGroup);
        HashSet<String> vivoGroup = new HashSet<String>(Arrays.asList("vivo"));
        BRAND_MAPPING.put(BrandEnum.VIVO, vivoGroup);
        for (Map.Entry entry : BRAND_MAPPING.entrySet()) {
            for (String alias : (Set)entry.getValue()) {
                PREFIX_TRIE.insert(alias, (BrandEnum)entry.getKey());
            }
        }
        MODEL_KEYWORDS.put(Pattern.compile(".*(redmi|mi\\s?\\d+|poco).*"), BrandEnum.XIAOMI);
        MODEL_KEYWORDS.put(Pattern.compile(".*(realme|oneplus|oppo\\s?reno).*"), BrandEnum.OPPO);
        MODEL_KEYWORDS.put(Pattern.compile(".*(honor|huawei\\s?mate|huawei\\s?p\\d+).*"), BrandEnum.HUAWEI);
    }
}

