package com.digiwin.mobile.mobileuibot.push.fcm.util;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 谷歌推送
 *
 * @author wuyang
 * @date 20230625
 */
public class FcmClientUtil {

    private static Logger logger = LoggerFactory.getLogger(FcmClientUtil.class);

    /**
     * 存放多个实例的Map
     */
    private static volatile Map<String, FirebaseApp> firebaseAppMap = new ConcurrentHashMap<>();

    private static final String KEY_PATH = "serviceAccountKey.json";
    private static final String DATA_URL = "";
    public static final String APP_NAME = "com.digiwin.enterprise.athena.atn";
    public static final String TEST_TOKEN = "ea51s4s3SFCIwD7mZEAi-c:APA91bF0uRhHqJzhpqFsQJPkjBaoqN7nYvju6mRXAoZlXdOvp8VSU-VTmsBX8avNnXBY_9QWzXH_KRXdy9mJ4dG5WVGeTyG1Jpa3GIXkVb2F2maTGR3ACMNRY0WJqMw5hMJ1AD2cvAwS";

    public static Boolean isInit(String appName) {
        return firebaseAppMap.get(appName) != null;
    }

    /**
     * 初始化SDK，当存在更换app文件的时候，能够兼容使用
     *
     * @param appName
     * @throws IOException
     */
    public static void init(String appName) throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(KEY_PATH);

        FirebaseOptions options = new FirebaseOptions.Builder()
                .setCredentials(GoogleCredentials.fromStream(classPathResource.getInputStream()))
                .build();
        FirebaseApp firebaseApp = null;
        try {
            firebaseApp = FirebaseApp.initializeApp(options);
        } catch (Exception e) {
            firebaseApp = FirebaseApp.getInstance(appName);
            if (firebaseApp != null) {
                firebaseApp.delete();
                firebaseApp = FirebaseApp.initializeApp(options);
            }
        }
        firebaseAppMap.put(APP_NAME, firebaseApp);
    }

    /**
     * 单设备推送
     *
     * @param appName 应用的名字
     * @param token   注册token
     * @param title   推送题目
     * @param body    推送内容
     * @return
     * @throws FirebaseMessagingException
     */
    public static void pushSingle(String appName, String token, String title, String body) throws FirebaseMessagingException, IOException {
        if (!isInit(appName)) {
            init(appName);
        }
        //获取实例
        FirebaseApp firebaseApp = firebaseAppMap.get(appName);
        //实例为空的情况
        if (firebaseApp == null) {
            return;
        }
        //构建消息内容
        Message message = Message.builder().setNotification(
                        Notification.builder().setTitle(title).setBody(body).build())
                .setToken(token)
                .build();
        //发送后，返回messageID
        String response = FirebaseMessaging.getInstance(firebaseApp).send(message);
        logger.debug("firebase发送消息成功,FirebaseID:" + response + ",设备:" + token + ",于" + DateTimeUtil.getTodayTimeUseDefaultPattern() + "推送消息title:" + title + ",消息内容:" + body);
    }

    /**
     * 给设备订阅主题
     *
     * @param appName 应用的名字
     * @param tokens  设备的token,最大1000个
     * @param topic   要添加的主题
     * @return
     * @throws FirebaseMessagingException
     * @throws IOException
     */
    public static void registrationTopic(String appName, List<String> tokens, String topic) throws FirebaseMessagingException, IOException {
        if (!isInit(appName)) {
            init(appName);
        }
        //获取实例
        FirebaseApp firebaseApp = firebaseAppMap.get(appName);
        //实例不存在的情况
        if (firebaseApp == null) {
            return;
        }
        //订阅，返回主题管理结果对象。
        TopicManagementResponse response = FirebaseMessaging.getInstance(firebaseApp).subscribeToTopic(tokens, topic);
        logger.error("添加设备主题，成功：" + response.getSuccessCount() + ",失败：" + response.getFailureCount());
    }

    /**
     * 取消设备的订阅主题
     *
     * @param appName 应用的名字
     * @param tokens  设备的token,最大1000个
     * @param topic   取消的主题
     * @return
     * @throws FirebaseMessagingException
     * @throws IOException
     */
    public static void cancelTopic(String appName, List<String> tokens, String topic) throws FirebaseMessagingException, IOException {
        if (!isInit(appName)) {
            init(appName);
        }
        //获取实例
        FirebaseApp firebaseApp = firebaseAppMap.get(appName);
        //实例不存在的情况
        if (firebaseApp == null) {
            return;
        }
        //取消订阅，返回主题管理结果对象。
        TopicManagementResponse response = FirebaseMessaging.getInstance(firebaseApp).unsubscribeFromTopic(tokens, topic);
        logger.error("取消设备主题，成功：" + response.getSuccessCount() + ",失败：" + response.getFailureCount());
    }

    /**
     * 按主题推送
     *
     * @param appName 应用的名字
     * @param topic   主题的名字
     * @param title   消息题目
     * @param body    消息体
     * @return
     * @throws FirebaseMessagingException
     * @throws IOException
     */
    public static void sendTopicMes(String appName, String topic, String title, String body) throws FirebaseMessagingException, IOException {
        if (!isInit(appName)) {
            init(appName);
        }
        //获取实例
        FirebaseApp firebaseApp = firebaseAppMap.get(appName);
        //实例不存在的情况
        if (firebaseApp == null) {
            return;
        }
        //构建消息
        Message message = Message.builder()
                .setNotification(Notification.builder().setTitle(title).setBody(body).build())
                .setTopic(topic)
                .build();
        //发送后，返回messageID
        String response = FirebaseMessaging.getInstance(firebaseApp).send(message);
        logger.error("主题推送成功: " + response);
    }

    /**
     * 测试使用
     *
     * @param args
     * @throws Exception
     */
    public static void main(String[] args) throws Exception {
        initProxy("127.0.0.1", 33210, "", "");
        pushSingle(APP_NAME, TEST_TOKEN, "测试FCM", "您好，鼎捷移动正在测试FCM，收到请忽略~");
    }

    private static void initProxy(String host, int port, final String username, final String password) {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "33210");
        //HTTP代理
        System.setProperty("http.proxyHost", host);
        System.setProperty("http.proxyPort", Integer.toString(port));
        //HTTPS代理
        System.setProperty("https.proxyHost", host);
        System.setProperty("https.proxyPort", Integer.toString(port));

//        if (username != null && password != null) {
//            Authenticator.setDefault(new BasicAuthenticator(username, password));
//        }

    }
}
