package com.digiwin.mobile.mobileuibot.push.jpush;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 应用的推送信息（极光）
 *
 * @author wuyang
 * @date 2022/10/10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PushConfig implements Serializable {
    private static final long serialVersionUID = -6263122548388556986L;
    /**
     * 应用key
     */
    private String type;
    /**
     * 应用key
     */
    private String appkey;
    /**
     * 应用 主秘钥
     */
    private String masterSecret;

    /**
     * 极光推送到安卓的通知，当需要支持从通知跳转app画面时，需要提供的intent信息。
     * 值内容为安卓包名
     */
    private String jpushAndroidIntentComponent;
}
