package com.digiwin.mobile.mobileuibot.push.jpush.service;

import com.digiwin.mobile.mobileuibot.push.jpush.PushConfig;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;

/**
 * @author wuyangz
 * @date 2022/10/10
 */
public interface PushSupplierEnable {

    /**
     * 通知推送
     *
     * @param notification
     * @param app
     * @return
     */
    public boolean pushAlert(Notification notification, PushConfig app);

    /**
     * 通知推送
     *
     * @param notification
     * @param app
     * @param deviceType
     * @return
     */
    public boolean pushAlert(Notification notification, PushConfig app, Integer deviceType);

    /**
     * 消息推送
     *
     * @param notification
     * @param app
     * @return
     */
    public boolean pushMessage(Notification notification, PushConfig app);

    /**
     * 消息推送
     *
     * @param notification
     * @param app
     * @param deviceType
     * @return
     */
    public boolean pushMessage(Notification notification, PushConfig app, Integer deviceType);

}
