package com.digiwin.mobile.mobileuibot.push.jpush.util;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.connection.HttpProxy;
import cn.jpush.api.JPushClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author wuyang
 * @date 2022/10/10
 * 单例化实现JpushClinet
 */
public class JPushClientUtil {
    private static Logger logger = LoggerFactory.getLogger(JPushClientUtil.class);

    /**
     * 以极光推送AppKey作为key，推送客户端实例作为value存储，支持多个不同key发送时仍是单例
     */
    private static volatile Map<String, JPushClient> _clientsPool = new HashMap<>();

    /**
     * 修改：getInstance必须给定appKey
     */
    public static JPushClient getInstance(String appKey, String masterSecret) {
        if (!_clientsPool.containsKey(appKey)) {
            synchronized (JPushClientUtil.class) {
                if (!_clientsPool.containsKey(appKey)) {
                    JPushClient client = new JPushClient(masterSecret, appKey, getProxy(), getConfig());
                    _clientsPool.put(appKey, client);
                    return client;
                } else {
                    return _clientsPool.get(appKey);
                }
            }
        } else {
            return _clientsPool.get(appKey);
        }
    }

    private static HttpProxy getProxy() {
        HttpProxy proxy = null;
        Properties prop = System.getProperties();
        if ("true".equals(prop.getProperty("http.proxySet"))) {
            String proxyHost = null;
            int proxyPort = 80;
            proxyHost = prop.getProperty("http.proxyHost");
            String proxyPortStr = prop.getProperty("http.proxyPort");
            if (proxyPortStr != null) {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            proxy = new HttpProxy(proxyHost, proxyPort);
        }
        return proxy;
    }

    private static ClientConfig getConfig() {
        ClientConfig config = ClientConfig.getInstance();
        /**
         * 默认极光的hostname=https://api.jpush.cn
         * 但如果遇到无法正常访问极光主机地址的情况（无法使用https或无法连通域名），
         * 可考虑在tomcat的启动参数中增加以下内容来自定义推送主机地址：
         * -Djpush.push.hostname=http://1.2.3.4
         */
        String newJpushHost = System.getProperties().getProperty("jpush.push.hostname");
        if (newJpushHost != null) {
            config.setPushHostName(newJpushHost);
        }
        return config;
    }
}
