package com.digiwin.mobile.mobileuibot.rabbitmq.config;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 直流交换机配置
 *
 * @author wuyang
 * @date 20230627
 */
@Configuration
public class DirectRabbitConfig {

    public static final String MOBILE_DIRECT_QUEUE = "mobileDirectQueue";
    public static final String MOBILE_DIRECT_EXCHANGE = "mobileDirectExchange";
    public static final String MOBILE_DIRECT_ROUTING = "mobileDirectRouting";
    public static final String LONELY_DIRECT_EXCHANGE = "lonelyDirectExchange";

    /**
     * 队列 起名：mobileDirectQueue
     *
     * @return
     */
    @Bean
    public Queue mobileDirectQueue() {
        // durable:是否持久化,默认是false,持久化队列：会被存储在磁盘上，当消息代理重启时仍然存在，暂存队列：当前连接有效
        // exclusive:默认也是false，只能被当前创建的连接使用，而且当连接关闭后队列即被删除。此参考优先级高于durable
        // autoDelete:是否自动删除，当没有生产者或者消费者使用此队列，该队列会自动删除。
        //   return new Queue("mobileDirectQueue",true,true,false);

        //一般设置一下队列的持久化就好,其余两个就是默认false
        return new Queue(MOBILE_DIRECT_QUEUE, true);
    }

    /**
     * Direct交换机 起名：mobileDirectExchange
     *
     * @return
     */
    @Bean
    DirectExchange mobileDirectExchange() {
        //  return new DirectExchange("mobileDirectExchange",true,true);
        return new DirectExchange(MOBILE_DIRECT_EXCHANGE, true, false);
    }

    /**
     * 绑定  将队列和交换机绑定, 并设置用于匹配键：mobileDirectRouting
     *
     * @return
     */
    @Bean
    Binding bindingDirect() {
        return BindingBuilder.bind(mobileDirectQueue()).to(mobileDirectExchange()).with(MOBILE_DIRECT_ROUTING);
    }


    @Bean
    DirectExchange lonelyDirectExchange() {
        return new DirectExchange(LONELY_DIRECT_EXCHANGE);
    }


}
