package com.digiwin.mobile.mobileuibot.rabbitmq.config;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author wuyang
 */
@Configuration
public class FanoutRabbitConfig {


    public static final String MOBILE_FANOUT_FCM_TENANT = "fanout.FCM.TENANT";
    public static final String MOBILE_FANOUT_FCM_COMPANY = "fanout.FCM.COMPANY";
    public static final String MOBILE_FANOUT_EXCHANGE = "mobileFanoutExchange";

    /**
     * 创建两个队列 ：fanout.FCM.TENANT   fanout.FCM.COMPANY
     * 将两个队列都绑定在交换机 fanoutExchange 上
     * 因为是扇型交换机, 路由键无需配置,配置也不起作用
     */


    @Bean
    public Queue queueFcmCompany() {
        return new Queue(FanoutRabbitConfig.MOBILE_FANOUT_FCM_COMPANY);
    }

    @Bean
    public Queue queueFcmTenant() {
        return new Queue(FanoutRabbitConfig.MOBILE_FANOUT_FCM_TENANT);
    }

    @Bean
    FanoutExchange fanoutExchange() {
        return new FanoutExchange(FanoutRabbitConfig.MOBILE_FANOUT_EXCHANGE);
    }

    @Bean
    Binding bindingExchangeFcmTenant() {
        return BindingBuilder.bind(queueFcmTenant()).to(fanoutExchange());
    }

    @Bean
    Binding bindingExchangeFcmCompany() {
        return BindingBuilder.bind(queueFcmCompany()).to(fanoutExchange());
    }

}
