package com.digiwin.mobile.mobileuibot.rabbitmq.listener;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.push.fcm.util.FcmClientUtil;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;
import com.digiwin.mobile.mobileuibot.rabbitmq.config.DirectRabbitConfig;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.Objects;

import static com.digiwin.mobile.mobileuibot.push.fcm.util.FcmClientUtil.APP_NAME;

/**
 * 监听单推消息队列
 * 消费者
 *
 * @author wuyang
 * @date 20230627
 */
@Slf4j
@Component
public class DirectReceiver {

    @RabbitHandler
    @RabbitListener(queues = DirectRabbitConfig.MOBILE_DIRECT_QUEUE, ackMode = "MANUAL")
    public void process(Message<Notification> message, Channel channel) throws IOException {
        long deliveryTag = 0;
        try {
            log.debug("DirectReceiver消费者收到消息  : " + JSONObject.toJSON(message.getPayload()));
            deliveryTag = Long.parseLong(Objects.requireNonNull(message.getHeaders().get(AmqpHeaders.DELIVERY_TAG)).toString());
            Notification notification = JsonUtil.objectToJavaObject(message.getPayload(), Notification.class);
            if (!CollectionUtils.isEmpty(notification.getFireBaseTokenList())) {
                notification.getFireBaseTokenList().forEach(token ->
                {
                    try {
                        FcmClientUtil.pushSingle(APP_NAME, token, notification.getTitle(), JSONObject.toJSONString(notification));
                    } catch (Exception e) {
                        log.error("DirectReceiver消费者 failed: " + e.getMessage(), e);
                    }
                });
            }
        } catch (Exception e) {
            log.error("DirectReceiver消费者 failed: " + e.getMessage(), e);
            // 消费失败，消息重返队列
            channel.basicNack(deliveryTag, false, false);
        } finally {
            //手动签收:为false时，只确认当前deliveryTag对应的消息；当为true时，会确认当前deliveryTag及之前所有未确认的消息。
            channel.basicAck((deliveryTag), false);
        }
    }

}
