/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.rabbitmq.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;
import com.digiwin.mobile.mobileuibot.rabbitmq.service.PushService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushService")
public class PushServiceImpl
implements PushService {
    private static final Logger log = LoggerFactory.getLogger(PushServiceImpl.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public Boolean sendMobileDirectMessage(Notification notification) {
        try {
            this.rabbitTemplate.convertAndSend("mobileDirectExchange", "mobileDirectRouting", (Object)notification);
            log.debug("sendMobileDirectMessage\u6d88\u606f\u53d1\u9001\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString((Object)notification));
        }
        catch (Exception e) {
            log.error("sendMobileDirectMessage\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Boolean sendTopicMessage(String messageData) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("messageId", UUIDUtil.getUuid());
        map.put("messageData", messageData);
        map.put("createTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        try {
            this.rabbitTemplate.convertAndSend("mobileTopicExchange", "mobile.topic.tenant", map);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Boolean sendFanoutMessage(String messageData) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("messageId", UUIDUtil.getUuid());
        map.put("messageData", messageData);
        map.put("createTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        try {
            this.rabbitTemplate.convertAndSend("mobileFanoutExchange", null, map);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }
}

