package com.digiwin.monitor.scan.sdk.extension;

import com.digiwin.monitor.scan.sdk.parse.builder.Criterion;

import java.util.List;

/**
 * @description: 创建类型侦测处理默认条件
 * @author: liunansheng
 * @date: 2022/2/18 15:54
 */
public interface ICreatedTypeDefaultParamBuilder {

    /**
     * 创建类型侦测默认条件拼接 :  创建时间在starTime与endTime范围 + 未审核（根据规则配置来）
     * @param createDateColumnList  创建时间字段名称
     * @param approveStatusColumnList  审核状态字段名称
     * @param startTime 开始时间
     * @param endTime  截止时间
     * @param tableName 表名
     * @param alias 别名
     * @return
     */
    List<Criterion> build(List<String> createDateColumnList, List<String> approveStatusColumnList,
                          String startTime, String endTime, String tableName, String alias);

}
