package com.digiwin.monitor.scan.sdk.extension.impl;

import com.digiwin.monitor.scan.sdk.enumerate.ConditionValueType;
import com.digiwin.monitor.scan.sdk.enumerate.OpType;
import com.digiwin.monitor.scan.sdk.extension.IApprovedTypeDefaultParamBuilder;
import com.digiwin.monitor.scan.sdk.parse.builder.Criterion;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 修改类型侦测处理默认条件
 * @author: liunansheng
 * @date: 2022/2/18 15:54
 */
public class ApprovedTypeDefaultParamBuilderImpl extends BaseDefaultTimeParamBuilder implements IApprovedTypeDefaultParamBuilder {


    @Override
    public List<Criterion> build(List<String> approveDateColumnList, List<String> approveStatusColumnList,
                                 String startTime, String endTime, String tableName, String alias) {
        if (CollectionUtil.isEmpty(approveStatusColumnList) && CollectionUtil.isEmpty(approveDateColumnList)) {
            return null;
        }
        List<Criterion> criterionList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(approveStatusColumnList)) {
            for (String statusColumn : approveStatusColumnList) {
                /** 此处拼接已审核条件 */
                criterionList.add(new Criterion(statusColumn, OpType.EQUAL.toString(), "Y", ConditionValueType.STRING.toString(), tableName, alias));
            }
        }
        if (CollectionUtil.isNotEmpty(approveDateColumnList)) {
            /** 此处拼接审核时间条件 */
            criterionList.addAll(super.buildTimeCriterion(approveDateColumnList, startTime, endTime, tableName, alias));
        }
        return  criterionList;
    }
}
