package com.digiwin.monitor.scan.sdk.parse;

import com.digiwin.monitor.scan.sdk.DataChangeGetExtensionContext;
import com.digiwin.monitor.scan.sdk.enumerate.ConditionType;
import com.digiwin.monitor.scan.sdk.parse.builder.GroupCriterion;
import com.digiwin.monitor.scan.sdk.pojo.request.DefaultParam;
import com.digiwin.monitor.scan.sdk.pojo.request.Rule;
import com.digiwin.monitor.scan.sdk.enumerate.MonitorType;
import com.digiwin.monitor.scan.sdk.parse.builder.Criterion;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;

import java.util.*;

/**
 * FIXME 注意，默认参数处理需要各自系统根据自身情况适配
 * @description: 默认参数转换器
 * @author: liunansheng
 * @date: 2021/11/25 14:41
 */
public final class DefaultParamConverter {
    public static final String APPROVE_STATUS = "APPROVE_STATUS";
    public static final String APPROVE_DATE = "APPROVE_DATE";
    public static final String CREATE_DATE = "CREATE_DATE";
    public static final String MODI_DATE = "MODI_DATE";

    /**
     * 处理默认参数
     * @param rule
     * @param startTime
     * @param endTime
     * @return
     */
    public static List<Criterion> buildDefaultCondition(Rule rule, String startTime, String endTime) {
        Map<String, List<String>> defaultParamMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(rule.getDefault_params())) {
            for (DefaultParam defaultParam : rule.getDefault_params()) {
                defaultParamMap.put(defaultParam.getName(), defaultParam.getValues());
            }
        }
        if (MonitorType.APPROVED.toString().equals(rule.getMonitor_type())) {
            return buildApprovedTypeParam(rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
        }
        if (MonitorType.CREATED.toString().equals(rule.getMonitor_type())) {
            return buildCreateTypeParam(rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
        }
        if (MonitorType.MODIFIED.toString().equals(rule.getMonitor_type())) {
            return buildModifyTypeParam( rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
        }
        if (MonitorType.CREATED_OR_MODIFIED.toString().equals(rule.getMonitor_type())) {
            List<Criterion> modifyCriterionList = buildModifyTypeParam( rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
            List<Criterion> createCriterionList = buildCreateTypeParam( rule.getTable(), rule.getAlias(), defaultParamMap, startTime, endTime);
            List<Criterion> orGroupCriterionList = new ArrayList<>();
            Criterion modifyAndGroup = convertToGroup(modifyCriterionList, ConditionType.AND_GROUP);
            Criterion createAndGroup = convertToGroup(createCriterionList, ConditionType.AND_GROUP);
            if (createAndGroup != null) {
                orGroupCriterionList.add(createAndGroup);
            }
            if (modifyAndGroup != null) {
                orGroupCriterionList.add(modifyAndGroup);
            }
            Criterion orGroup = convertToGroup(orGroupCriterionList, ConditionType.OR_GROUP);
            if (orGroup == null) {
                return null;
            } else {
                List<Criterion> defaultCriterion = new ArrayList<>();
                defaultCriterion.add(orGroup);
                return defaultCriterion;
            }
        }
        return null;
    }

    private static Criterion convertToGroup(List<Criterion> criterionList, ConditionType conditionType) {
        if (CollectionUtil.isEmpty(criterionList)) {
            return null;
        }
        if (criterionList.size() == 1) {
            return criterionList.get(0);
        }
        GroupCriterion andGroup = new GroupCriterion(conditionType.toString(), criterionList);
        return new Criterion(andGroup);
    }

    /**
     * 审核类默认参数处理
     * @param defaultParamMap
     * @param startTime
     * @param endTime
     * @return
     */
    public static List<Criterion> buildApprovedTypeParam(String tableName, String alias, Map<String, List<String>> defaultParamMap, String startTime, String endTime) {
        List<String> approveStatusColumnList = defaultParamMap.get(APPROVE_STATUS);
        List<String> approveDateColumnList = defaultParamMap.get(APPROVE_DATE);
        return DataChangeGetExtensionContext.getApprovedTypeDefaultParamBuilder()
                .build(approveDateColumnList, approveStatusColumnList, startTime, endTime, tableName, alias);
    }

    /**
     * 创建类型默认参数处理
     * @param defaultParamMap
     * @param startTime
     * @param endTime
     * @return
     */
    public static List<Criterion> buildCreateTypeParam(String tableName, String alias, Map<String, List<String>> defaultParamMap, String startTime, String endTime) {
        List<String> createDateColumnList = defaultParamMap.get(CREATE_DATE);
        List<String> approveStatusColumnList = defaultParamMap.get(APPROVE_STATUS);
        return DataChangeGetExtensionContext.getCreatedTypeDefaultParamBuilder()
                .build(createDateColumnList, approveStatusColumnList, startTime, endTime, tableName, alias);
    }

    /**
     * 修改类型 默认参数
     * @param defaultParamMap
     * @param startTime
     * @param endTime
     * @return
     */
    public static List<Criterion> buildModifyTypeParam(String tableName, String alias, Map<String, List<String>> defaultParamMap, String startTime, String endTime) {
        List<String> modifyDateColumnList = defaultParamMap.get(MODI_DATE);
        return DataChangeGetExtensionContext.getModifiedTypeDefaultParamBuilder()
                .build(modifyDateColumnList, startTime, endTime, tableName, alias);
    }
}
