package com.digiwin.monitor.scan.sdk.parse.builder;

import com.digiwin.monitor.scan.sdk.enumerate.ConditionType;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;

import java.util.List;

/**
 * @description: 组合条件对象
 * @author: liunansheng
 * @date: 2021/11/24 14:43
 */
public class GroupCriterion {
    /**
     * AND_GROUP 或 OR_GROUP
     */
    private String groupType;
    /**
     * 条件集合
     */
    private List<Criterion> criterionList;

    public GroupCriterion(String groupType, List<Criterion> criterionList) {
        this.groupType = groupType;
        this.criterionList = criterionList;
    }

    public GroupCriterion() {
    }

    @Override
    public String toString() {
        String logical = convertLogical();
        return "(" + CollectionUtil.join(criterionList, logical)  + ")";
    }

    private String convertLogical() {
        if (ConditionType.AND_GROUP.toString().equals( this.groupType)) {
            return " and ";
        }
        if (ConditionType.OR_GROUP.toString().equals( this.groupType)) {
            return " or ";
        }
        throw new RuntimeException("未知的groupType：" + this.groupType);
    }

    public String getGroupType() {
        return groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public List<Criterion> getCriterionList() {
        return criterionList;
    }

    public void setCriterionList(List<Criterion> criterionList) {
        this.criterionList = criterionList;
    }
}
