package com.digiwin.monitor.scan.sdk.parse.builder;

import com.digiwin.monitor.scan.sdk.enumerate.JoinType;
import com.digiwin.monitor.scan.sdk.util.StringUtil;

/**
 * @description: join语句拼接
 * @author: liunansheng
 * @date: 2021/11/25 10:29
 */
public class JoinBuilder {
    /**
     * 表
     */
    private String table;
    /**
     * 别名
     */
    private String alias;
    /**
     * join类型
     */
    private String type;
    /**
     * 连表条件
     */
    private Criterion criterion;

    public JoinBuilder(String table, String alias, String type, Criterion criterion) {
        this.table = table;
        this.alias = alias;
        this.type = type;
        this.criterion = criterion;
    }

    public JoinBuilder() {
    }

    @Override
    public String toString() {
        StringBuffer sql = new StringBuffer();
        sql.append(" ").append(JoinType.getJoinSql(this.type)).append(" ").append(table).append(" ");
        if (StringUtil.isNotBlank(alias)) {
            sql.append(alias).append(" ");
        }
        sql.append(" on ").append(criterion.toString());
        return sql.toString();
    }

    public String getTable() {
        return table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Criterion getCriterion() {
        return criterion;
    }

    public void setCriterion(Criterion criterion) {
        this.criterion = criterion;
    }
}
