package com.digiwin.monitor.scan.sdk.parse.builder;

import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import com.digiwin.monitor.scan.sdk.util.StringUtil;

import java.util.List;

/**
 * @description: sql构建类
 * @author: liunansheng
 * @date: 2021/11/25 10:51
 */
public class SqlBuilder {
    /**
     * 是否去重
     */
    private boolean isDistinct;
    /**
     * 返回字段
     */
    private List<SelectColumn> returnColumnList;
    /**
     * 表名
     */
    private String table;
    /**
     * 别名
     */
    private String alias;
    /**
     * join
     */
    private List<JoinBuilder> joinBuilderList;
    /**
     * where
     */
    private List<Criterion> whereConditionList;

    public SqlBuilder(boolean isDistinct, List<SelectColumn> returnColumnList, String table, String alias, List<JoinBuilder> joinBuilderList, List<Criterion> whereConditionList) {
        this.isDistinct = isDistinct;
        this.returnColumnList = returnColumnList;
        this.table = table;
        this.alias = alias;
        this.joinBuilderList = joinBuilderList;
        this.whereConditionList = whereConditionList;
    }

    public SqlBuilder() {
    }

    @Override
    public String toString() {
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        if (isDistinct) {
            sql.append(" distinct ");
        }
        sql.append(CollectionUtil.join(returnColumnList, ",")).append(" from ").append(table);
        if (StringUtil.isNotBlank(alias)) {
            sql.append(" ").append(alias);
        }
        if (CollectionUtil.isNotEmpty(joinBuilderList)) {
            sql.append(" ").append(CollectionUtil.join(joinBuilderList, " "));
        }
        if (CollectionUtil.isNotEmpty(whereConditionList)) {
            sql.append(" where ").append(CollectionUtil.join(whereConditionList, " and "));
        }
        return sql.toString();
    }

    public boolean isDistinct() {
        return isDistinct;
    }

    public void setDistinct(boolean distinct) {
        isDistinct = distinct;
    }

    public List<SelectColumn> getReturnColumnList() {
        return returnColumnList;
    }

    public void setReturnColumnList(List<SelectColumn> returnColumnList) {
        this.returnColumnList = returnColumnList;
    }

    public String getTable() {
        return table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<JoinBuilder> getJoinBuilderList() {
        return joinBuilderList;
    }

    public void setJoinBuilderList(List<JoinBuilder> joinBuilderList) {
        this.joinBuilderList = joinBuilderList;
    }

    public List<Criterion> getWhereConditionList() {
        return whereConditionList;
    }

    public void setWhereConditionList(List<Criterion> whereConditionList) {
        this.whereConditionList = whereConditionList;
    }
}
