package com.digiwin.monitor.scan.sdk.parse.builder.op;

import com.digiwin.monitor.scan.sdk.DataChangeGetExtensionContext;
import com.digiwin.monitor.scan.sdk.util.StringUtil;

/**
 * @description: op处理
 * @author: liunansheng
 * @date: 2021/11/24 15:33
 */
public abstract class IOperatorHandler {

    /**
     * 处理op与right
     * @param value
     * @param valueType
     * @param tableName
     * @param columnName
     * @return
     */
    public abstract String handle(String value, String valueType, String tableName, String columnName);

    /**
     * op类型
     * @return
     */
    public abstract String getOpType();

    /**
     * 如果有的表有特殊处理情况，可以根据表名做特殊转换
     * value处理
     */
    protected final String convertVal(String valueType, String value, String tableName, String columnName) {
        return DataChangeGetExtensionContext.getOpRightValConvertor().convertVal(valueType, value, tableName, columnName);
    }

    /**
     * like value 特殊字符转义
     * @param value
     * @return
     */
    protected final String escapeLike(String value) {
        value = StringUtil.replace(value, "\\", "\\\\");
        value = StringUtil.replace(value, "%", "\\%");
        value = StringUtil.replace(value,"_", "\\_");
        return value;
    }

}
